/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.properties;

import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.model.CVCProprtiesExpressionDTO;
import com.jaspersoft.studio.components.customvisualization.model.CVItemPropertiesDescriptor;
import com.jaspersoft.studio.components.customvisualization.model.MCustomVisualization;
import com.jaspersoft.studio.components.customvisualization.properties.CVItemPropertyDialog;
import com.jaspersoft.studio.components.customvisualization.properties.ItemPropertyNameLabelProvider;
import com.jaspersoft.studio.components.customvisualization.properties.ItemPropertyValueLabelProvider;
import com.jaspersoft.studio.components.customvisualization.properties.SectionCVCPropertyEditor;
import com.jaspersoft.studio.components.customvisualization.ui.UIManager;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.properties.layout.StackLayout;
import com.jaspersoft.studio.properties.view.SectionContainerComposite;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.DescriptorPropertyLabelProvider;
import com.jaspersoft.studio.property.itemproperty.dialog.FormItemDialog;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ExpressionInterpreter;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.SectionPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.providers.BaseLabelProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPCVItemPropertiesList
extends ASPropertyWidget<CVItemPropertiesDescriptor> {
    private TableViewer propertiesTV;
    private Button btnAddProperty;
    private Button btnModifyProperty;
    private Button btnRemoveProperty;
    private Group propertiesGrp;
    private CVCProprtiesExpressionDTO itemProps;
    private StackLayout stackLayout;
    private Composite form;
    private Composite cmp;
    private Composite mainContainer;
    private CVCWidgetsDescriptor currentDescriptor;
    private List<WItemProperty> wIProps = new ArrayList<WItemProperty>();
    private SectionContainerComposite propertyPageContainer;

    public SPCVItemPropertiesList(Composite parent, AbstractSection section, CVItemPropertiesDescriptor pdescriptor) {
        super(parent, section, (IPropertyDescriptor)pdescriptor);
    }

    protected void createComponent(Composite parent) {
        this.mainContainer = new Composite(parent, 0);
        GridLayout mainContainerLayout = new GridLayout(1, false);
        mainContainerLayout.horizontalSpacing = 0;
        mainContainerLayout.marginHeight = 0;
        mainContainerLayout.marginWidth = 0;
        mainContainerLayout.verticalSpacing = 0;
        this.mainContainer.setLayout((Layout)mainContainerLayout);
        this.cmp = new Composite(this.mainContainer, 0);
        this.cmp.setLayoutData((Object)new GridData(768));
        this.stackLayout = new StackLayout();
        this.cmp.setLayout((Layout)this.stackLayout);
        this.createPropertiesTable(this.cmp);
        this.stackLayout.setTopControl((Control)this.propertiesGrp);
        this.form = new Composite(this.cmp, 0);
        GridLayout formLayout = new GridLayout(2, false);
        formLayout.horizontalSpacing = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.verticalSpacing = 0;
        this.form.setLayout((Layout)formLayout);
        this.propertyPageContainer = parent instanceof SectionContainerComposite ? (SectionContainerComposite)parent : null;
    }

    private void addNewPropertyBtnPressed() {
        CVItemPropertyDialog d = new CVItemPropertyDialog(UIUtils.getShell(), null, null);
        d.setExpressionContext(this.getExpressionContext());
        if (d.open() == 0) {
            this.itemProps.getItemProps().add(d.getItemProperty());
            this.section.changeProperty((Object)"itemProperties", (Object)this.itemProps);
        }
    }

    private void modifyPropertyBtnPressed() {
        ItemProperty p = this.getCurrentSelectedProperty();
        if (p != null) {
            ItemProperty clonedP = (ItemProperty)p.clone();
            CVItemPropertyDialog d = new CVItemPropertyDialog(UIUtils.getShell(), clonedP, null);
            d.setExpressionContext(this.getExpressionContext());
            if (d.open() == 0) {
                int idx = this.itemProps.getItemProps().indexOf(p);
                this.itemProps.getItemProps().remove(p);
                this.itemProps.getItemProps().add(idx, clonedP);
                this.section.changeProperty((Object)"itemProperties", (Object)this.itemProps);
            }
        }
    }

    private void removePropertyBtnPressed() {
        ItemProperty p = this.getCurrentSelectedProperty();
        if (p != null) {
            this.itemProps.getItemProps().remove(p);
            this.section.changeProperty((Object)"itemProperties", (Object)this.itemProps);
        }
    }

    private ItemProperty getCurrentSelectedProperty() {
        Object selEl = ((IStructuredSelection)this.propertiesTV.getSelection()).getFirstElement();
        if (selEl instanceof ItemProperty) {
            return (ItemProperty)selEl;
        }
        return null;
    }

    private TableViewer createPropertiesTable(Composite parent) {
        this.propertiesGrp = new Group(parent, 0);
        this.propertiesGrp.setLayout((Layout)new GridLayout(2, false));
        Composite tableContainer = new Composite((Composite)this.propertiesGrp, 0);
        tableContainer.setLayout((Layout)new GridLayout(1, false));
        tableContainer.setLayoutData((Object)new GridData(1808));
        this.propertiesTV = new TableViewer(tableContainer, 68100);
        this.propertiesTV.getTable().setHeaderVisible(true);
        this.propertiesTV.getTable().setLinesVisible(true);
        this.propertiesTV.getTable().setLayoutData((Object)new GridData(1808));
        TableViewerColumn tvcName = new TableViewerColumn(this.propertiesTV, 0);
        tvcName.getColumn().setText(Messages.SPCVItemPropertiesList_ColName);
        tvcName.getColumn().setWidth(100);
        tvcName.setLabelProvider((CellLabelProvider)new ItemPropertyNameLabelProvider());
        TableViewerColumn tvcValue = new TableViewerColumn(this.propertiesTV, 0);
        tvcValue.getColumn().setText(Messages.SPCVItemPropertiesList_ColValue);
        tvcValue.setLabelProvider((CellLabelProvider)new ItemPropertyValueLabelProvider());
        tvcValue.getColumn().setWidth(100);
        this.propertiesTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propertiesTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPCVItemPropertiesList.this.modifyPropertyBtnPressed();
            }
        });
        Composite buttonsComposite = new Composite((Composite)this.propertiesGrp, 0);
        GridLayout buttonsCompositeLayout = new GridLayout(1, false);
        buttonsCompositeLayout.horizontalSpacing = 0;
        buttonsCompositeLayout.marginWidth = 0;
        buttonsCompositeLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        buttonsComposite.setLayoutData((Object)new GridData(1040));
        this.btnAddProperty = new Button(buttonsComposite, 8);
        this.btnAddProperty.setText(Messages.SPCVItemPropertiesList_Add);
        this.btnAddProperty.setLayoutData((Object)new GridData(768));
        this.btnAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemPropertiesList.this.addNewPropertyBtnPressed();
            }
        });
        this.btnModifyProperty = new Button(buttonsComposite, 8);
        this.btnModifyProperty.setText(Messages.SPCVItemPropertiesList_Edit);
        this.btnModifyProperty.setLayoutData((Object)new GridData(768));
        this.btnModifyProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemPropertiesList.this.modifyPropertyBtnPressed();
            }
        });
        this.btnRemoveProperty = new Button(buttonsComposite, 8);
        this.btnRemoveProperty.setText(Messages.SPCVItemPropertiesList_Remove);
        this.btnRemoveProperty.setLayoutData((Object)new GridData(768));
        this.btnRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPCVItemPropertiesList.this.removePropertyBtnPressed();
            }
        });
        this.propertiesTV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPCVItemPropertiesList.this.enablePropertiesTVButtons();
            }
        });
        this.propertiesTV.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (SPCVItemPropertiesList.this.btnRemoveProperty.isEnabled() && (e.keyCode == 127 || e.keyCode == 8)) {
                    SPCVItemPropertiesList.this.removePropertyBtnPressed();
                }
            }
        });
        this.enablePropertiesTVButtons();
        return this.propertiesTV;
    }

    public void setData(APropertyNode pnode, Object value) {
        this.itemProps = (CVCProprtiesExpressionDTO)value;
        if (this.itemProps == null) {
            this.itemProps = new CVCProprtiesExpressionDTO(new ArrayList<ItemProperty>(), (MCustomVisualization)pnode, pnode.getJasperDesign(), pnode.getJasperConfiguration());
        }
        this.propertiesTV.setInput(this.itemProps.getItemProps());
        JasperDesign jd = pnode.getJasperDesign();
        JasperReportsConfiguration jConf = pnode.getJasperConfiguration();
        JRDesignDataset dataset = null;
        if (dataset == null) {
            dataset = ModelUtils.getDataset((ANode)pnode);
        }
        if (dataset == null) {
            dataset = (JRDesignDataset)jd.getMainDataset();
        }
        ExpressionInterpreter expIntr = ExpressionUtil.getCachedInterpreter((JRDesignDataset)dataset, (JasperDesign)jd, (JasperReportsConfiguration)jConf);
        String module = null;
        for (ItemProperty ip : this.itemProps.getItemProps()) {
            if (!ip.getName().equals("module") || Misc.isNullOrEmpty((String)(module = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)((StandardItemProperty)ip), (ExpressionInterpreter)expIntr)))) continue;
            CVCWidgetsDescriptor newDescriptor = UIManager.getDescriptor(jConf, module);
            if (newDescriptor == null) {
                this.stackLayout.setTopControl((Control)this.propertiesGrp);
                if (this.propertyPageContainer == null) continue;
                this.propertyPageContainer.refreshPageComposite();
                continue;
            }
            if (newDescriptor == this.currentDescriptor) {
                this.setDataIntoWidgets();
                this.stackLayout.setTopControl((Control)this.form);
                continue;
            }
            this.currentDescriptor = newDescriptor;
            this.wIProps.clear();
            Control[] controlArray = this.form.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            ExpressionContext ec = this.getExpressionContext();
            CVCPropertyDescriptor descriptor = new CVCPropertyDescriptor();
            DescriptorPropertyLabelProvider descriptorLabelProvider = new DescriptorPropertyLabelProvider((ADescriptor)descriptor);
            if (this.currentDescriptor == null || this.currentDescriptor.getSections() == null) continue;
            boolean first = true;
            for (SectionPropertyDescriptor csd : this.currentDescriptor.getSections()) {
                Composite c = null;
                if (csd.isExpandable()) {
                    c = this.createSection(this.form, csd.getName());
                } else if (!Misc.isNullOrEmpty((String)csd.getName())) {
                    c = this.createGroup(this.form, csd.getName());
                } else {
                    c = this.form;
                    if (!first) {
                        FormItemDialog.createSeparator((Composite)this.form);
                    }
                }
                first = false;
                SectionCVCPropertyEditor editor = new SectionCVCPropertyEditor(this.section, this.itemProps);
                for (WidgetPropertyDescriptor pd : csd.getProperties()) {
                    ItemPropertyDescription ipdesc = WidgetFactory.createItemPropertyDescriptor((WidgetsDescriptor)this.currentDescriptor, (WidgetPropertyDescriptor)pd, (JasperReportsConfiguration)jConf);
                    if (ipdesc == null) continue;
                    descriptor.addItemPropertyDescriptor(ipdesc);
                    this.wIProps.add(this.createItemProperty(c, ipdesc, descriptorLabelProvider, ec, (IPropertyEditor)editor));
                }
            }
            this.setDataIntoWidgets();
            this.stackLayout.setTopControl((Control)this.form);
            if (this.propertyPageContainer == null) continue;
            this.propertyPageContainer.getParent().layout(true, true);
            this.propertyPageContainer.refreshPageComposite();
        }
        if (Misc.isNullOrEmpty(module)) {
            this.stackLayout.setTopControl((Control)this.propertiesGrp);
            this.cmp.layout(true);
        }
    }

    private void setDataIntoWidgets() {
        SectionCVCPropertyEditor editor = new SectionCVCPropertyEditor(this.section, this.itemProps);
        for (WItemProperty wip : this.wIProps) {
            wip.setPropertyEditor((IPropertyEditor)editor);
            wip.updateWidget();
        }
    }

    public Control getControl() {
        return this.mainContainer;
    }

    private ExpressionContext getExpressionContext() {
        return ModelUtils.getElementExpressionContext(null, (ANode)this.section.getElement());
    }

    protected Composite createSection(Composite parent, String text) {
        Composite c = this.section.getWidgetFactory().createSection(parent, text, true, 2, 2);
        return c;
    }

    protected Composite createGroup(Composite parent, String text) {
        Composite c = this.section.getWidgetFactory().createSection(parent, text, false, 2, 2);
        return c;
    }

    private void enablePropertiesTVButtons() {
        this.btnModifyProperty.setEnabled(!this.propertiesTV.getSelection().isEmpty());
        this.btnRemoveProperty.setEnabled(!this.propertiesTV.getSelection().isEmpty());
    }

    protected WItemProperty createItemProperty(Composite cmp, ItemPropertyDescription<?> ipd, DescriptorPropertyLabelProvider descriptorLabelProvider, ExpressionContext ec, IPropertyEditor editor) {
        Object layoutData;
        Label lbl = new Label(cmp, 0);
        lbl.setText(Misc.nvl((String)ipd.getLabel()));
        lbl.setToolTipText(ipd.getToolTip());
        WItemProperty expr = new WItemProperty(cmp, 0, ipd, editor);
        DoubleControlComposite control = (DoubleControlComposite)expr.getControl();
        Control simpleControl = control.getSimpleControlToHighlight();
        if ((simpleControl instanceof Combo || simpleControl instanceof Text) && (layoutData = simpleControl.getLayoutData()) != null && layoutData.getClass().equals(GridData.class)) {
            GridData oldData = (GridData)layoutData;
            if (!oldData.grabExcessHorizontalSpace || oldData.horizontalAlignment != 4 || oldData.widthHint == -1) {
                // empty if block
            }
            GridData newGridData = new GridData(oldData.horizontalAlignment, oldData.verticalAlignment, oldData.grabExcessHorizontalSpace, oldData.grabExcessVerticalSpace, oldData.horizontalSpan, oldData.verticalSpan);
            int w = SPCVItemPropertiesList.getCharWidth((Control)simpleControl) * 15;
            if (w > 50) {
                w = 50;
            }
            newGridData.widthHint = w;
            simpleControl.setLayoutData((Object)newGridData);
        }
        expr.setLabelProvider((BaseLabelProvider)descriptorLabelProvider);
        expr.setLayoutData((Object)new GridData(768));
        expr.setExpressionContext(ec);
        if (ipd.isReadOnly()) {
            expr.setEnabled(false);
        }
        return expr;
    }

    private class CVCPropertyDescriptor
    extends ADescriptor {
        private CVCPropertyDescriptor() {
        }

        public void addItemPropertyDescriptor(ItemPropertyDescription<?> ipd) {
            if (this.itemProperties == null) {
                this.itemProperties = new ItemPropertyDescription[]{ipd};
                return;
            }
            ItemPropertyDescription[] ip = new ItemPropertyDescription[this.itemProperties.length + 1];
            System.arraycopy(this.itemProperties, 0, ip, 0, this.itemProperties.length);
            ip[ip.length - 1] = ipd;
            this.itemProperties = ip;
        }

        protected void initItemPropertyDescriptors() {
        }

        public IPropertyEditor getPropertyEditor() {
            return null;
        }
    }
}

