/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.ui.editor;

import com.jaspersoft.studio.widgets.framework.ui.ColorPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyDescriptorDialog
extends ATitledDialog {
    private ItemPropertyDescription<?> descriptor;
    private Text tname;
    private Text tlabel;
    private Text tdesc;
    private Button bMandatory;
    private Combo ctype;
    private String[] types = new String[]{"Text", "Float", "Integer", "Double", "Combo", "Color"};

    protected PropertyDescriptorDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("Property");
        this.setDefaultSize(400, 400);
    }

    public ItemPropertyDescription<?> getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ItemPropertyDescription<?> descriptor) {
        this.descriptor = descriptor;
    }

    public boolean close() {
        this.createDescriptor();
        return super.close();
    }

    private void createDescriptor() {
        switch (this.ctype.getSelectionIndex()) {
            case 0: {
                this.descriptor = new TextPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection());
                break;
            }
            case 1: {
                this.descriptor = new TextPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection());
                break;
            }
            case 2: {
                this.descriptor = new TextPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection());
                break;
            }
            case 3: {
                this.descriptor = new TextPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection());
                break;
            }
            case 4: {
                this.descriptor = new ComboItemPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection(), new String[0]);
                break;
            }
            case 5: {
                this.descriptor = new ColorPropertyDescription(this.tname.getText(), this.tlabel.getText(), this.tdesc.getText(), this.bMandatory.getSelection());
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setLayoutData((Object)new GridData(1808));
        new Label(cmp, 0).setText("Name");
        this.tname = new Text(cmp, 2048);
        this.tname.setLayoutData((Object)new GridData(768));
        new Label(cmp, 0).setText("Label");
        this.tlabel = new Text(cmp, 2048);
        this.tlabel.setLayoutData((Object)new GridData(768));
        new Label(cmp, 0).setText("Description");
        this.tdesc = new Text(cmp, 2048);
        this.tdesc.setLayoutData((Object)new GridData(768));
        this.bMandatory = new Button(cmp, 32);
        this.bMandatory.setText("Mandatory");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.bMandatory.setLayoutData((Object)gd);
        new Label(cmp, 0).setText("Type");
        this.ctype = new Combo(cmp, 8);
        this.ctype.setLayoutData((Object)new GridData(768));
        this.ctype.setItems(this.types);
        this.ctype.select(0);
        this.fillDescriptor();
        return parent;
    }

    private void fillDescriptor() {
        if (this.descriptor == null) {
            return;
        }
        this.tname.setText(Misc.nvl((String)this.descriptor.getName()));
        this.tlabel.setText(Misc.nvl((String)this.descriptor.getLabel()));
        this.tdesc.setText(Misc.nvl((String)this.descriptor.getDescription()));
        this.bMandatory.setSelection(this.descriptor.isMandatory());
        if (this.descriptor instanceof TextPropertyDescription) {
            this.ctype.select(0);
        } else if (this.descriptor instanceof ColorPropertyDescription) {
            this.ctype.select(5);
        } else if (this.descriptor instanceof ComboItemPropertyDescription) {
            this.ctype.select(4);
        }
    }
}

