/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.jdbc;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.Activator;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.jdbc.JDBCDataAdapterDescriptor;
import com.jaspersoft.studio.data.messages.Messages;
import java.util.UUID;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapterImpl;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.eclipse.equinox.security.storage.StorageException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCCreator
implements IDataAdapterCreator {
    public DataAdapterDescriptor buildFromXML(Document docXML) {
        JdbcDataAdapterImpl result = new JdbcDataAdapterImpl();
        NamedNodeMap rootAttributes = docXML.getChildNodes().item(0).getAttributes();
        String connectionName = rootAttributes.getNamedItem("name").getTextContent();
        result.setName(connectionName);
        NodeList children = docXML.getChildNodes().item(0).getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeName().equals("connectionParameter")) {
                String paramName = node.getAttributes().getNamedItem("name").getTextContent();
                if (paramName.equals("ServerAddress")) {
                    result.setServerAddress(node.getTextContent());
                }
                if (paramName.equals("SavePassword")) {
                    result.setSavePassword(node.getTextContent().equals("true"));
                }
                if (paramName.equals("Url")) {
                    result.setUrl(node.getTextContent());
                }
                if (paramName.equals("Database")) {
                    result.setDatabase(node.getTextContent());
                }
                if (paramName.equals("Password")) {
                    result.setPassword(this.getPasswordValue(node.getTextContent()));
                }
                if (paramName.equals("Username")) {
                    result.setUsername(node.getTextContent());
                }
                if (paramName.equals("JDBCDriver")) {
                    result.setDriver(node.getTextContent());
                }
            }
            ++i;
        }
        JDBCDataAdapterDescriptor desc = new JDBCDataAdapterDescriptor();
        desc.setDataAdapter((DataAdapter)result);
        return desc;
    }

    private String getPasswordValue(String passwordFieldTxt) {
        return JaspersoftStudioPlugin.shouldUseSecureStorage() ? this.getSecretStorageKey(passwordFieldTxt) : passwordFieldTxt;
    }

    public String getID() {
        return "com.jaspersoft.ireport.designer.connection.JDBCConnection";
    }

    private String getSecretStorageKey(String pass) {
        try {
            UUID uuidKey = UUID.randomUUID();
            SecureStorageUtils.saveToDefaultSecurePreferences((String)"net.sf.jasperreports.data.adapter", (String)uuidKey.toString(), (String)pass);
            return uuidKey.toString();
        }
        catch (StorageException e) {
            Activator.getDefault().logError(Messages.JDBCCreator_ErrSecurPrefStorage, e);
            return pass;
        }
    }
}

