/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.jdbc;

import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.parameter.ParameterUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JDBCFieldsProvider
implements IFieldsProvider {
    private static String JAVA_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static Pattern PATTERN = Pattern.compile(String.valueOf(JAVA_PATTERN) + "(\\." + JAVA_PATTERN + ")*");
    private static Map<String, String> types = new HashMap<String, String>();

    static {
        types.put("CHAR", String.class.getCanonicalName());
        types.put("VARCHAR", String.class.getCanonicalName());
        types.put("NVARCHAR", String.class.getCanonicalName());
        types.put("LONGVARCHAR", String.class.getCanonicalName());
        types.put("DECIMAL", BigDecimal.class.getCanonicalName());
        types.put("NUMERIC", Number.class.getCanonicalName());
        types.put("BIT", Boolean.class.getCanonicalName());
        types.put("BOOLEAN", Boolean.class.getCanonicalName());
        types.put("TINYINT", Byte.class.getCanonicalName());
        types.put("SMALLINT", Short.class.getCanonicalName());
        types.put("INTEGER", Integer.class.getCanonicalName());
        types.put("BIGINT", BigInteger.class.getCanonicalName());
        types.put("REAL", Float.class.getCanonicalName());
        types.put("FLOAT", Double.class.getCanonicalName());
        types.put("DOUBLE", Double.class.getCanonicalName());
        types.put("BINARY", byte[].class.getCanonicalName());
        types.put("VARBINARY", byte[].class.getCanonicalName());
        types.put("LONGVARBINARY", byte[].class.getCanonicalName());
        types.put("DATE", Date.class.getCanonicalName());
        types.put("TIME", Time.class.getCanonicalName());
        types.put("TIME_WITH_TIMEZONE", Time.class.getCanonicalName());
        types.put("TIMESTAMP", Timestamp.class.getCanonicalName());
        types.put("TIMESTAMP_WITH_TIMEZONE", Timestamp.class.getCanonicalName());
        types.put("CLOB", Clob.class.getCanonicalName());
        types.put("NCLOB", Clob.class.getCanonicalName());
        types.put("BLOB", Blob.class.getCanonicalName());
        types.put("ARRAY", Array.class.getCanonicalName());
        types.put("DISTINCT", "Mapping of underlying type");
        types.put("ROWID", RowId.class.getCanonicalName());
        types.put("DATALINK", URL.class.getCanonicalName());
        types.put("STRUCT", Struct.class.getCanonicalName());
        types.put("REF", Ref.class.getCanonicalName());
        types.put("JAVA_OBJECT", "Underlying Java class");
        types.put("SQLXML", SQLXML.class.getCanonicalName());
        types.put("REF_CURSOR", ResultSet.class.getCanonicalName());
        types.put("OTHER", Object.class.getCanonicalName());
    }

    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        return true;
    }

    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset jDataset) throws JRException, UnsupportedOperationException {
        ArrayList<JRDesignField> columns;
        block20: {
            Connection c = null;
            columns = null;
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            con.contributeParameters(parameters);
            try {
                try {
                    ResultSet rs;
                    c = (Connection)parameters.get("REPORT_CONNECTION");
                    ParameterUtil.setParameters((JasperReportsConfiguration)jConfig, (JRDataset)jDataset, parameters);
                    parameters.put("net.sf.jasperreports.jdbc.fetch.size", 0);
                    parameters.put("REPORT_MAX_COUNT", 1);
                    Map tmpMap = ParameterUtil.convertMap(parameters, (JRDataset)jDataset);
                    QueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getInstance((JasperReportsContext)jConfig).getExecuterFactory(jDataset.getQuery().getLanguage());
                    JRQueryExecuter qe = queryExecuterFactory.createQueryExecuter((JasperReportsContext)jConfig, jDataset, tmpMap);
                    qe.createDatasource();
                    if (!(qe instanceof JRJdbcQueryExecuter) || (rs = ((JRJdbcQueryExecuter)qe).getResultSet()) == null) break block20;
                    ResultSetMetaData metaData = rs.getMetaData();
                    int cc = metaData.getColumnCount();
                    HashSet<String> colset = new HashSet<String>();
                    columns = new ArrayList<JRDesignField>(cc);
                    String driverName = c.getMetaData().getDriverName().toLowerCase();
                    int i = 1;
                    while (i <= cc) {
                        boolean isSlowMetadataDB;
                        JRDesignField field = new JRDesignField();
                        String name = metaData.getColumnLabel(i);
                        field.getPropertiesMap().setProperty("com.jaspersoft.studio.field.name", metaData.getColumnName(i));
                        field.getPropertiesMap().setProperty("com.jaspersoft.studio.field.label", name);
                        if (colset.contains(name)) {
                            name = "COLUMN_" + i;
                        }
                        colset.add(name);
                        field.setName(StringUtils.xmlEncode((String)name, null));
                        String jdbcTypeClass = JDBCFieldsProvider.getJdbcTypeClass(metaData, i);
                        boolean bl = isSlowMetadataDB = !driverName.contains("simba") && !driverName.contains("impala");
                        if (Misc.isNullOrEmpty((String)jdbcTypeClass) || isSlowMetadataDB) {
                            try {
                                ResultSet rsmc;
                                String catalog = metaData.getCatalogName(i);
                                String schema = metaData.getSchemaName(i);
                                String table = metaData.getTableName(i);
                                if (!(Misc.isNullOrEmpty((String)catalog) && Misc.isNullOrEmpty((String)schema) && Misc.isNullOrEmpty((String)table) || !(rsmc = c.getMetaData().getColumns(catalog, schema, table, name)).next())) {
                                    String remarksStr;
                                    if (Misc.isNullOrEmpty((String)jdbcTypeClass)) {
                                        jdbcTypeClass = JDBCFieldsProvider.getColumnType(rsmc.getInt("SQL_DATA_TYPE"));
                                    }
                                    if (isSlowMetadataDB && (remarksStr = rsmc.getString("REMARKS")) != null && !remarksStr.trim().isEmpty()) {
                                        field.setDescription(StringUtils.xmlEncode((String)remarksStr, null));
                                    }
                                }
                            }
                            catch (SQLException se) {
                                se.printStackTrace();
                            }
                        }
                        if (Misc.isNullOrEmpty((String)jdbcTypeClass)) {
                            jdbcTypeClass = Object.class.getCanonicalName();
                        }
                        field.setValueClassName(jdbcTypeClass);
                        String tbl = metaData.getTableName(i);
                        if (!Misc.isNullOrEmpty((String)tbl)) {
                            field.getPropertiesMap().setProperty("com.jaspersoft.studio.field.tree.path", tbl);
                        }
                        columns.add(field);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    throw new JRException((Throwable)e);
                }
            }
            finally {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (SQLException e) {
                        throw new JRException((Throwable)e);
                    }
                }
            }
        }
        return columns;
    }

    public static String getJdbcTypeClass(ResultSetMetaData rsmd, int t) {
        try {
            String cl = rsmd.getColumnClassName(t);
            if (Misc.isNullOrEmpty((String)cl) || !PATTERN.matcher(cl).matches()) {
                return JDBCFieldsProvider.getColumnType(rsmd, t);
            }
            return JDBCFieldsProvider.getJRFieldType(cl);
        }
        catch (SQLException sQLException) {
            return JDBCFieldsProvider.getColumnType(rsmd, t);
        }
    }

    protected static String getColumnType(ResultSetMetaData rsmd, int ind) {
        try {
            return JDBCFieldsProvider.getColumnType(rsmd.getColumnType(ind));
        }
        catch (SQLException ex2) {
            ex2.printStackTrace();
            return null;
        }
    }

    protected static String getColumnType(int type) {
        switch (type) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return String.class.getCanonicalName();
            }
            case 2: {
                return Number.class.getCanonicalName();
            }
            case 3: {
                return BigDecimal.class.getCanonicalName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getCanonicalName();
            }
            case -6: {
                return Byte.class.getCanonicalName();
            }
            case 5: {
                return Short.class.getCanonicalName();
            }
            case 4: {
                return Integer.class.getCanonicalName();
            }
            case -5: {
                return BigInteger.class.getCanonicalName();
            }
            case 7: {
                return Float.class.getCanonicalName();
            }
            case 6: 
            case 8: {
                return Double.class.getCanonicalName();
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class.getCanonicalName();
            }
            case 91: {
                return Date.class.getCanonicalName();
            }
            case 92: 
            case 2013: {
                return Time.class.getCanonicalName();
            }
            case 93: 
            case 2014: {
                return Timestamp.class.getCanonicalName();
            }
            case 2005: {
                return Clob.class.getCanonicalName();
            }
            case 2011: {
                return NClob.class.getCanonicalName();
            }
            case 2004: {
                return Blob.class.getCanonicalName();
            }
            case 2003: {
                return Array.class.getCanonicalName();
            }
            case 2002: {
                return Struct.class.getCanonicalName();
            }
            case -8: {
                return RowId.class.getCanonicalName();
            }
            case 2006: {
                return Ref.class.getCanonicalName();
            }
            case 70: {
                return URL.class.getCanonicalName();
            }
            case 2009: {
                return SQLXML.class.getCanonicalName();
            }
            case 2012: {
                return ResultSet.class.getCanonicalName();
            }
        }
        return Object.class.getCanonicalName();
    }

    public static String getJRFieldType(String type) {
        if (type == null) {
            return Object.class.getName();
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return Boolean.class.getName();
        }
        if (type.equals(Byte.TYPE.getName())) {
            return Byte.class.getName();
        }
        if (type.equals(Integer.TYPE.getName())) {
            return Integer.class.getName();
        }
        if (type.equals(Long.TYPE.getName())) {
            return Long.class.getName();
        }
        if (type.equals(Double.TYPE.getName())) {
            return Double.class.getName();
        }
        if (type.equals(Float.TYPE.getName())) {
            return Float.class.getName();
        }
        if (type.equals(Short.TYPE.getName())) {
            return Short.class.getName();
        }
        if (type.startsWith("[")) {
            return Object.class.getName();
        }
        return type;
    }

    public static String getJavaType4SQL(String type) {
        if (type == null) {
            return Object.class.getCanonicalName();
        }
        return Misc.nvl((Object)types.get(type.toUpperCase()), (String)"java.lang.String");
    }
}

