/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jaspersoft.studio.data.designer.tree.ISelectableNodes;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.querydesigner.json.JsonQueryHelper;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.datasource.json.JsonSupportNode;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.json.JsonExpressionLanguageEnum;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.util.JsonUtil;
import net.sf.jasperreports.engine.util.json.DefaultJsonQLExecuter;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class JsonDataManager
implements ISelectableNodes<JsonSupportNode> {
    private ObjectMapper mapper;
    private JsonNode jsonRoot;
    private MRoot jsonSupportModel;
    private Map<JsonSupportNode, JsonNode> jsonNodesMap;
    private String language;

    public JsonDataManager(String language) {
        this.language = language;
    }

    public void loadJsonDataFile(DataFile dataFile, JasperReportsConfiguration jconfig, JRDataset jDataset) throws IOException, JRException {
        this.getJsonNodesMap().clear();
        DataFileStream ins = null;
        try {
            HashMap parameters = jconfig.getJRParameters();
            if (parameters == null) {
                parameters = new HashMap();
            }
            ParameterContributorContext paramContributorCtx = new ParameterContributorContext((JasperReportsContext)jconfig, jDataset, parameters);
            ins = DataFileUtils.instance((ParameterContributorContext)paramContributorCtx).getDataStream(dataFile, parameters);
            this.jsonRoot = this.getJsonMapper().readTree((InputStream)ins);
            this.buildJsonSupportTree();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ins);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ins);
    }

    public void loadJsonDataString(String jsonData) throws IOException {
        this.jsonRoot = this.getJsonMapper().readTree(jsonData);
        this.buildJsonSupportTree();
    }

    private ObjectMapper getJsonMapper() {
        if (this.mapper == null) {
            this.mapper = JsonUtil.createObjectMapper();
        }
        return this.mapper;
    }

    public JsonNode getJsonTreeRoot() {
        return this.jsonRoot;
    }

    public MRoot getJsonSupportModel() {
        return this.jsonSupportModel;
    }

    private void buildJsonSupportTree() {
        this.jsonSupportModel = new MRoot(null, null);
        List<JsonSupportNode> children = this.getChildrenJsonNodes(this.getJsonTreeRoot());
        for (JsonSupportNode c : children) {
            c.setParent((ANode)this.jsonSupportModel, -1);
        }
        if (children.isEmpty()) {
            UIUtils.getDisplay().asyncExec(() -> MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.JsonDataManager_errorTitle, (String)Messages.JsonDataManager_errorMsg));
        }
    }

    private List<JsonSupportNode> getChildrenJsonNodes(JsonNode jsonNode) {
        ArrayList<JsonSupportNode> children = new ArrayList<JsonSupportNode>();
        if (jsonNode.isArray() && jsonNode.equals((Object)this.jsonRoot)) {
            jsonNode = jsonNode.get(0);
        }
        Iterator fieldNames = jsonNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonSupportNode child;
            String name = (String)fieldNames.next();
            JsonNode tmpNode = jsonNode.get(name);
            if (tmpNode.isObject()) {
                child = new JsonSupportNode();
                child.setNodeText(name);
                List<JsonSupportNode> innerChildren = this.getChildrenJsonNodes(tmpNode);
                for (JsonSupportNode innerChild : innerChildren) {
                    innerChild.setParent((ANode)child, -1);
                }
                this.getJsonNodesMap().put(child, tmpNode);
                children.add(child);
                continue;
            }
            if (tmpNode.isArray()) {
                Iterator elements = tmpNode.elements();
                while (elements.hasNext()) {
                    JsonNode el = (JsonNode)elements.next();
                    JsonSupportNode child2 = new JsonSupportNode();
                    child2.setNodeText(name);
                    List<JsonSupportNode> innerChildren = this.getChildrenJsonNodes(el);
                    for (JsonSupportNode innerChild : innerChildren) {
                        innerChild.setParent((ANode)child2, -1);
                    }
                    this.getJsonNodesMap().put(child2, el);
                    children.add(child2);
                }
                continue;
            }
            if (!tmpNode.isValueNode()) continue;
            child = new JsonSupportNode();
            child.setNodeText(name);
            this.getJsonNodesMap().put(child, tmpNode);
            children.add(child);
        }
        return children;
    }

    public List<JsonSupportNode> getSelectableNodes(String query) {
        ArrayList<JsonSupportNode> selectedList = new ArrayList<JsonSupportNode>();
        if (this.language.equalsIgnoreCase(JsonExpressionLanguageEnum.JSONQL.getName())) {
            JRJsonNode jrJsonNode = new JRJsonNode(null, this.jsonRoot);
            DefaultJsonQLExecuter jsonqlExec = new DefaultJsonQLExecuter();
            try {
                List jrSelectedNodes = jsonqlExec.selectNodes(jrJsonNode, query);
                ArrayList<JsonNode> elementsList = new ArrayList<JsonNode>();
                if (jrSelectedNodes != null) {
                    for (JRJsonNode n : jrSelectedNodes) {
                        elementsList.add(n.getDataNode());
                    }
                    for (JsonSupportNode sn : this.getJsonNodesMap().keySet()) {
                        if (!elementsList.contains(this.getJsonNodesMap().get(sn))) continue;
                        selectedList.add(sn);
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            JsonQueryHelper jsonQueryHelper = new JsonQueryHelper(this.mapper);
            try {
                JsonNode jsonData = jsonQueryHelper.getJsonData(this.jsonRoot, query);
                if (jsonData != null) {
                    ArrayList<JsonNode> elementsList = new ArrayList<JsonNode>();
                    if (jsonData.isArray()) {
                        Iterator elements = jsonData.elements();
                        while (elements.hasNext()) {
                            elementsList.add((JsonNode)elements.next());
                        }
                    } else if (jsonData.isObject()) {
                        elementsList.add(jsonData);
                    }
                    for (JsonSupportNode sn : this.getJsonNodesMap().keySet()) {
                        if (!elementsList.contains(this.getJsonNodesMap().get(sn))) continue;
                        selectedList.add(sn);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return selectedList;
    }

    public List<JRDesignField> extractFields(String query) {
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JsonNode jsonData = null;
        try {
            if (this.language.equalsIgnoreCase(JsonExpressionLanguageEnum.JSONQL.getName())) {
                JRJsonNode jrJsonNode = new JRJsonNode(null, this.jsonRoot);
                DefaultJsonQLExecuter jsonqlExec = new DefaultJsonQLExecuter();
                List jrSelectedNodes = jsonqlExec.selectNodes(jrJsonNode, query);
                ArrayList<JsonNode> elementsList = new ArrayList<JsonNode>();
                if (jrSelectedNodes != null) {
                    for (JRJsonNode n : jrSelectedNodes) {
                        elementsList.add(n.getDataNode());
                    }
                }
                if (!elementsList.isEmpty()) {
                    jsonData = (JsonNode)elementsList.get(0);
                }
            } else {
                JsonQueryHelper jsonQueryHelper = new JsonQueryHelper(this.mapper);
                jsonData = jsonQueryHelper.getJsonData(this.jsonRoot, query);
            }
        }
        catch (Exception exception) {}
        if (jsonData != null) {
            if (jsonData.isArray()) {
                return this.getFieldsFromArrayNode((ArrayNode)jsonData, result);
            }
            if (jsonData.isObject()) {
                return this.getFieldsFromObjectNode((ObjectNode)jsonData, result);
            }
            return this.getFieldFromGenericJsonNode(jsonData, result);
        }
        return result;
    }

    private List<JRDesignField> getFieldFromGenericJsonNode(JsonNode node, List<JRDesignField> fields) {
        JRDesignField f = new JRDesignField();
        f.setName(ModelUtils.getNameForField(fields, (String)"node"));
        String infoStr = ".";
        if (this.language.equalsIgnoreCase(JsonExpressionLanguageEnum.JSONQL.getName())) {
            infoStr = "[0]";
        }
        f.setDescription(infoStr);
        f.getPropertiesMap().setProperty(this.getFieldExpressionName(), infoStr);
        f.setValueClass(String.class);
        fields.add(f);
        return fields;
    }

    private List<JRDesignField> getFieldsFromObjectNode(ObjectNode node, List<JRDesignField> fields) {
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String name = (String)fieldNames.next();
            JRDesignField f = new JRDesignField();
            f.setName(ModelUtils.getNameForField(fields, (String)name));
            f.setDescription(name);
            f.getPropertiesMap().setProperty(this.getFieldExpressionName(), name);
            f.setValueClass(String.class);
            fields.add(f);
        }
        return fields;
    }

    private List<JRDesignField> getFieldsFromArrayNode(ArrayNode node, List<JRDesignField> fields) {
        JsonNode firstEl = node.get(0);
        if (firstEl instanceof ObjectNode) {
            return this.getFieldsFromObjectNode((ObjectNode)firstEl, fields);
        }
        if (firstEl instanceof ArrayNode) {
            return this.getFieldsFromArrayNode((ArrayNode)firstEl, fields);
        }
        return this.getFieldFromGenericJsonNode(firstEl, fields);
    }

    private String getFieldExpressionName() {
        if (JsonExpressionLanguageEnum.JSONQL.getName().equalsIgnoreCase(this.language)) {
            return "net.sf.jasperreports.jsonql.field.expression";
        }
        return "net.sf.jasperreports.json.field.expression";
    }

    public Map<JsonSupportNode, JsonNode> getJsonNodesMap() {
        if (this.jsonNodesMap == null) {
            this.jsonNodesMap = new HashMap<JsonSupportNode, JsonNode>();
        }
        return this.jsonNodesMap;
    }

    public String getQueryExpression(String existingQuery, JsonSupportNode selectedNode) {
        String absoluteQuery = this.getAbsoluteQueryExpression(selectedNode);
        if (existingQuery != null && absoluteQuery.startsWith(existingQuery) && absoluteQuery.length() > existingQuery.length()) {
            int qLength = existingQuery.length();
            return absoluteQuery.substring(qLength + Math.min(qLength, 1));
        }
        return absoluteQuery;
    }

    private String getAbsoluteQueryExpression(JsonSupportNode selectedNode) {
        StringBuilder querysb = new StringBuilder();
        querysb.insert(0, selectedNode.getNodeText());
        JsonSupportNode tmpNode = selectedNode;
        while (tmpNode.getParent() != null && !(tmpNode.getParent() instanceof MRoot)) {
            tmpNode = (JsonSupportNode)tmpNode.getParent();
            querysb.insert(0, String.valueOf(tmpNode.getNodeText()) + ".");
        }
        return querysb.toString();
    }
}

