/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.json;

import com.jaspersoft.studio.data.querydesigner.json.JsonScanner;
import com.jaspersoft.studio.data.querydesigner.json.JsonTokensType;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.swt.ResourceManager;

public class JsonLineStyler
implements LineStyleListener {
    private JsonScanner jsonScanner;
    private Map<JsonTokensType, Color> colorsMap;

    public JsonLineStyler() {
        this.initializeColors();
        this.jsonScanner = new JsonScanner();
    }

    private void initializeColors() {
        this.colorsMap = new HashMap<JsonTokensType, Color>(JsonTokensType.getColoredTokensNum());
        this.colorsMap.put(JsonTokensType.TEXT, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(JsonTokensType.KEYWORD, ResourceManager.getColor((int)196, (int)58, (int)34));
        this.colorsMap.put(JsonTokensType.QUOTED_LITERAL, ResourceManager.getColor((int)15, (int)128, (int)0));
        this.colorsMap.put(JsonTokensType.SYMBOL, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(JsonTokensType.OTHER, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(JsonTokensType.NUMBER, ResourceManager.getColor((int)45, (int)0, (int)255));
        this.colorsMap.put(JsonTokensType.JRPARAMETER, ResourceManager.getColor((int)178, (int)0, (int)0));
        this.colorsMap.put(JsonTokensType.JRFIELD, ResourceManager.getColor((int)32, (int)187, (int)34));
        this.colorsMap.put(JsonTokensType.JRVARIABLE, ResourceManager.getColor((int)17, (int)18, (int)254));
    }

    private Color getColor(JsonTokensType type) {
        if (type != null) {
            return this.colorsMap.get((Object)type);
        }
        return null;
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        JsonTokensType token = null;
        StyleRange lastStyle = null;
        Color defaultFgColor = ((Control)event.widget).getForeground();
        this.jsonScanner.setRange(event.lineText);
        token = this.jsonScanner.nextToken();
        while (token != JsonTokensType.EOF) {
            if (token != JsonTokensType.OTHER) {
                if (token != JsonTokensType.SPACE) {
                    Color color = this.getColor(token);
                    if (!color.equals((Object)defaultFgColor) || token == JsonTokensType.SYMBOL) {
                        StyleRange style = new StyleRange(this.jsonScanner.getStartOffset() + event.lineOffset, this.jsonScanner.getLength(), color, null);
                        if (token == JsonTokensType.SYMBOL) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                } else if (!styles.isEmpty()) {
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle == 1) {
                        int start = this.jsonScanner.getStartOffset() + event.lineOffset;
                        lastStyle = (StyleRange)styles.lastElement();
                        if (lastStyle.start + lastStyle.length == start) {
                            lastStyle.length += this.jsonScanner.getLength();
                        }
                    }
                }
            }
            token = this.jsonScanner.nextToken();
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }
}

