/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.sql.text;

import com.jaspersoft.studio.data.querydesigner.sql.text.SQLScanner;
import com.jaspersoft.studio.data.querydesigner.sql.text.SQLTokensType;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.swt.ResourceManager;

public class SQLLineStyler
implements LineStyleListener {
    private SQLScanner sqlScanner;
    private Map<SQLTokensType, Color> colorsMap;
    private List<int[]> blockComments;

    public SQLLineStyler() {
        this.initializeColors();
        this.sqlScanner = this.getSQLBasedScanner();
        this.blockComments = new ArrayList<int[]>();
    }

    protected SQLScanner getSQLBasedScanner() {
        return new SQLScanner();
    }

    protected void initializeColors() {
        this.colorsMap = new HashMap<SQLTokensType, Color>(SQLTokensType.getColoredTokensNum());
        this.colorsMap.put(SQLTokensType.STANDARD_TEXT, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(SQLTokensType.KEYWORD, ResourceManager.getColor((int)126, (int)12, (int)88));
        this.colorsMap.put(SQLTokensType.COMMENT, ResourceManager.getColor((int)63, (int)127, (int)104));
        this.colorsMap.put(SQLTokensType.QUOTED_LITERAL, ResourceManager.getColor((int)42, (int)0, (int)255));
        this.colorsMap.put(SQLTokensType.BRACKETED_LITERAL, ResourceManager.getColor((int)42, (int)0, (int)255));
        this.colorsMap.put(SQLTokensType.SYMBOL, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(SQLTokensType.OTHER, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(SQLTokensType.NUMBER, ResourceManager.getColor((int)0, (int)0, (int)0));
        this.colorsMap.put(SQLTokensType.JRPARAMETER, ResourceManager.getColor((int)190, (int)39, (int)39));
        this.colorsMap.put(SQLTokensType.JRFIELD, ResourceManager.getColor((int)0, (int)178, (int)0));
        this.colorsMap.put(SQLTokensType.JRVARIABLE, ResourceManager.getColor((int)0, (int)0, (int)255));
    }

    private Color getColor(SQLTokensType type) {
        if (type != null) {
            return this.colorsMap.get((Object)type);
        }
        return null;
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        SQLTokensType token = null;
        StyleRange lastStyle = null;
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            styles.add(new StyleRange(event.lineOffset, event.lineText.length(), this.getColor(SQLTokensType.COMMENT), null));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        Color defaultFgColor = ((Control)event.widget).getForeground();
        this.sqlScanner.setRange(event.lineText);
        token = this.sqlScanner.nextToken();
        while (token != SQLTokensType.EOF) {
            if (token != SQLTokensType.OTHER) {
                if (token != SQLTokensType.SPACE) {
                    Color color = this.getColor(token);
                    if (!color.equals((Object)defaultFgColor) || token == SQLTokensType.KEYWORD || token == SQLTokensType.SYMBOL) {
                        StyleRange style = new StyleRange(this.sqlScanner.getStartOffset() + event.lineOffset, this.sqlScanner.getLength(), color, null);
                        if (token == SQLTokensType.KEYWORD || token == SQLTokensType.SYMBOL) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                } else if (!styles.isEmpty()) {
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle == 1) {
                        int start = this.sqlScanner.getStartOffset() + event.lineOffset;
                        lastStyle = (StyleRange)styles.lastElement();
                        if (lastStyle.start + lastStyle.length == start) {
                            lastStyle.length += this.sqlScanner.getLength();
                        }
                    }
                }
            }
            token = this.sqlScanner.nextToken();
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }

    private boolean inBlockComment(int start, int end) {
        int i = 0;
        while (i < this.blockComments.size()) {
            int[] offsets = this.blockComments.get(i);
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] <= start && offsets[1] >= end) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void parseBlockComments(String text) {
        this.blockComments = new ArrayList<int[]>();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        int cnt = 0;
        int[] offsets = new int[2];
        boolean done = false;
        try {
            while (!done) {
                int ch = buffer.read();
                switch (ch) {
                    case -1: {
                        if (blkComment) {
                            offsets[1] = cnt;
                            this.blockComments.add(offsets);
                        }
                        done = true;
                        break;
                    }
                    case 47: {
                        ch = buffer.read();
                        if (ch == 42 && !blkComment) {
                            offsets = new int[2];
                            offsets[0] = cnt++;
                            blkComment = true;
                        } else {
                            ++cnt;
                        }
                        ++cnt;
                        break;
                    }
                    case 42: {
                        if (blkComment) {
                            ch = buffer.read();
                            ++cnt;
                            if (ch == 47) {
                                blkComment = false;
                                offsets[1] = cnt;
                                this.blockComments.add(offsets);
                            }
                        }
                        ++cnt;
                        break;
                    }
                    default: {
                        ++cnt;
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }
}

