/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xls;

import com.jaspersoft.studio.data.AFileDataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DateNumberFormatWidget;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.xls.XLSDataAdapterDescriptor;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class XLSDataAdapterComposite
extends AFileDataAdapterComposite {
    private TableViewer tableViewer;
    private Table table;
    private TableViewerColumn tableViewerColumnName;
    private TableViewerColumn tableViewerColumnIndex;
    private Button btnAdd;
    private Button btnDelete;
    private Button btnCheckSkipFirstLine;
    private Button btnCheckQEMode;
    private DateNumberFormatWidget dnf;
    private List<String[]> rows;
    private JasperReportsConfiguration jConfig;

    public XLSDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        this.setLayout((Layout)new GridLayout(1, false));
        this.rows = new ArrayList<String[]>();
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createFileNameWidgets(composite);
        this.btnCheckQEMode = new Button((Composite)this, 32);
        this.btnCheckQEMode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCheckQEMode.setText(Messages.XLSDataAdapterComposite_2);
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayout((Layout)new FillLayout(512));
        composite_1.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Group grpColumnNames = new Group(composite_1, 0);
        grpColumnNames.setText(Messages.XLSDataAdapterComposite_3);
        GridLayout gl_grpColumnNames = new GridLayout(1, false);
        grpColumnNames.setLayout((Layout)gl_grpColumnNames);
        Button btnGetExcelColumnsName = new Button((Composite)grpColumnNames, 0);
        btnGetExcelColumnsName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnGetExcelColumnsName.setText(Messages.XLSDataAdapterComposite_4);
        Composite composite_3 = new Composite((Composite)grpColumnNames, 0);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginWidth = 0;
        gl_composite_3.marginHeight = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        composite_3.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(composite_3, 68354);
        this.tableViewer.setContentProvider((IContentProvider)new XLSContentProvider());
        this.tableViewer.setInput(this.rows);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnName = this.tableViewerColumnName.getColumn();
        tblclmnColumnName.setMoveable(true);
        tblclmnColumnName.setWidth(100);
        tblclmnColumnName.setText(Messages.XLSDataAdapterComposite_5);
        this.tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnNameIndexLabelProvider(0));
        this.tableViewerColumnName.setEditingSupport((EditingSupport)new NameIndexEditingSupport(this.tableViewer, 0));
        this.tableViewerColumnIndex = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnIndex = this.tableViewerColumnIndex.getColumn();
        tblclmnColumnIndex.setMoveable(true);
        tblclmnColumnIndex.setWidth(100);
        tblclmnColumnIndex.setText(Messages.XLSDataAdapterComposite_6);
        this.tableViewerColumnIndex.setLabelProvider((CellLabelProvider)new ColumnNameIndexLabelProvider(1));
        this.tableViewerColumnIndex.setEditingSupport((EditingSupport)new NameIndexEditingSupport(this.tableViewer, 1));
        int i = 0;
        int n = this.table.getColumnCount();
        while (i < n) {
            this.table.getColumn(i).pack();
            ++i;
        }
        Composite composite_4 = new Composite(composite_3, 0);
        composite_4.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout gl_composite_4 = new GridLayout(1, false);
        gl_composite_4.marginWidth = 0;
        gl_composite_4.marginHeight = 0;
        composite_4.setLayout((Layout)gl_composite_4);
        this.btnAdd = new Button(composite_4, 0);
        GridData gd_btnAdd = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_btnAdd.widthHint = 100;
        this.btnAdd.setLayoutData((Object)gd_btnAdd);
        this.btnAdd.setText(Messages.XLSDataAdapterComposite_7);
        this.btnDelete = new Button(composite_4, 0);
        GridData gd_btnDelete = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_btnDelete.widthHint = 100;
        this.btnDelete.setLayoutData((Object)gd_btnDelete);
        this.btnDelete.setText(Messages.XLSDataAdapterComposite_8);
        this.btnDelete.setEnabled(false);
        new ListOrderButtons().createOrderButtons(composite_4, this.tableViewer);
        Composite composite_2 = new Composite((Composite)this, 0);
        composite_2.setLayout((Layout)new FillLayout(256));
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpOther = new Group(composite_2, 0);
        grpOther.setText(Messages.XLSDataAdapterComposite_9);
        GridLayout gl_grpOther = new GridLayout(3, false);
        grpOther.setLayout((Layout)gl_grpOther);
        this.dnf = new DateNumberFormatWidget((Composite)grpOther);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.dnf.setLayoutData(gd);
        this.btnCheckSkipFirstLine = new Button((Composite)grpOther, 32);
        this.btnCheckSkipFirstLine.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnCheckSkipFirstLine.setText(Messages.XLSDataAdapterComposite_14);
        btnGetExcelColumnsName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    XLSDataAdapterComposite.this.getExcelColumns();
                }
                catch (Exception e1) {
                    UIUtils.showError((Throwable)e1);
                }
            }
        });
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLSDataAdapterComposite.this.rows.add(XLSDataAdapterComposite.this.createDataModelEntry());
                if (XLSDataAdapterComposite.this.rows.size() == 1) {
                    XLSDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
                XLSDataAdapterComposite.this.tableViewer.refresh();
                XLSDataAdapterComposite.this.setTableSelection(-1);
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLSDataAdapterComposite.this.removeEntries();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    XLSDataAdapterComposite.this.removeEntries();
                }
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (XLSDataAdapterComposite.this.rows.size() <= 0) {
                    XLSDataAdapterComposite.this.btnDelete.setEnabled(false);
                    XLSDataAdapterComposite.this.btnCheckSkipFirstLine.setSelection(false);
                } else {
                    XLSDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
            }
        });
    }

    protected void bindWidgets(DataAdapter dataAdapter) {
        XlsDataAdapter xlsDataAdapter = (XlsDataAdapter)dataAdapter;
        this.doBindFileNameWidget((DataAdapter)xlsDataAdapter);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.btnCheckQEMode), PojoProperties.value((String)"queryExecuterMode").observe((Object)dataAdapter));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.btnCheckSkipFirstLine), PojoProperties.value((String)"useFirstRowAsHeader").observe((Object)dataAdapter));
        this.dnf.bindWidgets((DataAdapter)xlsDataAdapter, this.bindingContext, xlsDataAdapter.getLocale(), xlsDataAdapter.getTimeZone());
        List listColumnNames = xlsDataAdapter.getColumnNames();
        List listColumnIndexes = xlsDataAdapter.getColumnIndexes();
        if (listColumnNames != null && listColumnNames.size() > 0 && listColumnIndexes != null && listColumnIndexes.size() > 0 && listColumnNames.size() == listColumnIndexes.size()) {
            int i = 0;
            while (i < listColumnNames.size()) {
                this.rows.add(new String[]{(String)listColumnNames.get(i), ((Integer)listColumnIndexes.get(i)).toString()});
                ++i;
            }
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.btnDelete.setEnabled(true);
        }
    }

    public DataAdapterDescriptor getDataAdapter() {
        if (this.dataAdapterDesc == null) {
            this.dataAdapterDesc = new XLSDataAdapterDescriptor();
        }
        XlsDataAdapter dataAdapter = (XlsDataAdapter)this.dataAdapterDesc.getDataAdapter();
        dataAdapter.setQueryExecuterMode(this.btnCheckQEMode.getSelection());
        ArrayList<String> listColumnNames = new ArrayList<String>();
        ArrayList<Integer> listColumnIndexes = new ArrayList<Integer>();
        for (String[] row : this.rows) {
            listColumnNames.add(row[0]);
            listColumnIndexes.add(Integer.valueOf(row[1]));
        }
        dataAdapter.setColumnNames(listColumnNames);
        dataAdapter.setColumnIndexes(listColumnIndexes);
        dataAdapter.setDatePattern(this.dnf.getTextDatePattern());
        dataAdapter.setNumberPattern(this.dnf.getTextNumberPattern());
        dataAdapter.setLocale(this.dnf.getLocale());
        dataAdapter.setTimeZone(this.dnf.getTimeZone());
        dataAdapter.setUseFirstRowAsHeader(this.btnCheckSkipFirstLine.getSelection());
        return this.dataAdapterDesc;
    }

    private String excelCellLabelRenderer(Integer index) {
        String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (index != null && index instanceof Integer) {
            int val = index;
            String number = "" + digits.charAt(val % 26);
            while (val > 0) {
                int i = (val /= 26) % 26 - 1;
                if (val == 0) break;
                if (val % 26 == 0) {
                    val -= 26;
                    i = 25;
                }
                number = String.valueOf(digits.charAt(i)) + number;
            }
            return number;
        }
        return null;
    }

    private String[] createDataModelEntry() {
        int i = 0;
        String column = "COLUMN_" + i;
        while (!this.isColumnValid(column)) {
            column = "COLUMN_" + ++i;
        }
        return new String[]{column, String.valueOf(i)};
    }

    private void setTableSelection(int index) {
        if (this.rows != null && this.rows.size() > 0) {
            if (index == 0) {
                this.table.setSelection(index);
            } else if (index > 0 && index < this.rows.size() - 1) {
                this.table.setSelection(index - 1);
            } else {
                this.table.setSelection(this.rows.size() - 1);
            }
        }
    }

    @Override
    protected void fireFileChanged(boolean showWarning) {
        try {
            if (showWarning) {
                if (UIUtils.showConfirmation((String)Messages.CSVDataAdapterComposite_0, (String)Messages.CSVDataAdapterComposite_1)) {
                    this.getExcelColumns();
                }
            } else {
                this.getExcelColumns();
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private void getExcelColumns() throws Exception {
        if (this.textFileName.getText().length() > 0) {
            DataAdapterDescriptor da = this.getDataAdapter();
            if (this.jConfig == null) {
                this.jConfig = JasperReportsConfiguration.getDefaultJRConfig();
            }
            DataAdapterService das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)this.jConfig, null, null)).getService(da.getDataAdapter());
            ((AbstractDataAdapterService)das).getDataAdapter();
            JasperDesign jd = new JasperDesign();
            jd.setJasperReportsContext((JasperReportsContext)this.jConfig);
            this.jConfig.setJasperDesign(jd);
            XlsDataAdapter xlsAdapter = (XlsDataAdapter)da.getDataAdapter();
            boolean useRowHeader = xlsAdapter.isUseFirstRowAsHeader();
            xlsAdapter.setUseFirstRowAsHeader(true);
            List fields = ((IFieldsProvider)da).getFields(das, this.jConfig, (JRDataset)new JRDesignDataset((JasperReportsContext)this.jConfig, false));
            xlsAdapter.setUseFirstRowAsHeader(useRowHeader);
            this.rows.clear();
            int columnIndex = 0;
            for (JRDesignField f : fields) {
                this.rows.add(new String[]{f.getName(), String.valueOf(columnIndex++)});
            }
            this.tableViewer.setInput(this.rows);
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.btnDelete.setEnabled(true);
        }
    }

    public void dispose() {
        if (this.jConfig != null) {
            this.jConfig.dispose();
            this.jConfig = null;
        }
        super.dispose();
    }

    private void removeEntries() {
        int[] indices = this.table.getSelectionIndices();
        if (indices.length > 0) {
            Arrays.sort(indices);
            int removedItems = 0;
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.rows.remove(i - removedItems);
                ++removedItems;
                ++n2;
            }
            this.tableViewer.refresh();
            this.setTableSelection(indices[0]);
        }
    }

    private boolean isColumnValid(String column) {
        if (column == null || "".equals(column)) {
            return false;
        }
        for (String[] row : this.rows) {
            if (!row[0].equals(column)) continue;
            return false;
        }
        return true;
    }

    public String getHelpContextId() {
        return "com.jaspersoft.studio.doc.".concat("adapter_excel");
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{"*.xls", "*.*"};
    }

    private class ColumnNameIndexLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        private ColumnNameIndexLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            String[] row = (String[])element;
            if (this.columnIndex == 0) {
                return row[this.columnIndex].toString();
            }
            String excelCellLabel = XLSDataAdapterComposite.this.excelCellLabelRenderer(Integer.valueOf(row[this.columnIndex].toString()));
            return String.valueOf(row[this.columnIndex]) + Messages.XLSDataAdapterComposite_22 + excelCellLabel + Messages.XLSDataAdapterComposite_23;
        }
    }

    private class NameIndexEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private int columnIndex;

        public NameIndexEditingSupport(TableViewer viewer, int columnIndex) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.columnIndex = columnIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((String[])element)[this.columnIndex].toString();
        }

        protected void setValue(Object element, Object value) {
            ((String[])element)[this.columnIndex] = String.valueOf(value);
            this.viewer.refresh();
        }
    }

    private class XLSContentProvider
    implements IStructuredContentProvider {
        private XLSContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

