/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.data.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthenticationDialog
extends PersistentLocationDialog {
    private static final String usernameKey = "j_username=";
    private static final String passwordKey = "j_password=";
    private Text usernameText;
    private Text passwordText;
    private String username = "";
    private String password = "";
    private int authenticationAttempt = 0;
    private boolean cancelOperation = false;

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AuthenticationDialog_title);
    }

    public AuthenticationDialog(Shell parent, String urlString) {
        super(parent);
        int userStart = urlString.indexOf(usernameKey);
        int passwordStart = urlString.indexOf(passwordKey);
        if (userStart == -1 || passwordStart == -1) {
            this.username = "";
            this.password = "";
        } else {
            int userEnd = urlString.indexOf(38, (userStart += usernameKey.length()) + 1);
            this.username = userEnd == -1 ? urlString.substring(userStart) : urlString.substring(userStart, userEnd);
            int passwordEnd = urlString.indexOf(38, (passwordStart += passwordKey.length()) + 1);
            this.password = passwordEnd == -1 ? urlString.substring(passwordStart) : urlString.substring(passwordStart, passwordEnd - 1);
        }
    }

    public AuthenticationDialog(Shell parent, String urlString, String username, String password) {
        super(parent);
        this.username = username;
        this.password = password;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout(2, false));
        Label lblUserName = new Label(dialogArea, 0);
        lblUserName.setText(Messages.AuthenticationDialog_usernameLbl);
        this.usernameText = new Text(dialogArea, 2048);
        this.usernameText.setText(this.username);
        GridData usernameData = new GridData(768);
        usernameData.widthHint = 200;
        this.usernameText.setLayoutData((Object)usernameData);
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthenticationDialog.this.username = AuthenticationDialog.this.usernameText.getText();
            }
        });
        Label lblPassword = new Label(dialogArea, 0);
        lblPassword.setText(Messages.AuthenticationDialog_passwordLbl);
        this.passwordText = new Text(dialogArea, 0x400800);
        this.passwordText.setText(this.password);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthenticationDialog.this.password = AuthenticationDialog.this.passwordText.getText();
            }
        });
        return dialogArea;
    }

    public boolean cancelOperation() {
        return this.cancelOperation;
    }

    public void openDialog() {
        int returnCode = super.open();
        if (returnCode == 1) {
            this.cancelOperation = true;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public char[] getPasswordCA() {
        return this.password != null ? this.password.toCharArray() : null;
    }

    public void resetFields() {
        this.username = "";
        this.password = "";
        this.cancelOperation = false;
        this.authenticationAttempt = 0;
    }

    public void resetFields(String usernameInit, String passwordInit) {
        this.username = usernameInit != null ? usernameInit : "";
        this.password = passwordInit != null ? passwordInit : "";
        this.cancelOperation = false;
        this.authenticationAttempt = 0;
    }

    public void incrementAuthAttempt() {
        ++this.authenticationAttempt;
    }

    public int getAuthenticationAttempt() {
        return this.authenticationAttempt;
    }

    public String getUsername() {
        return this.username;
    }
}

