/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map;

import com.jaspersoft.studio.widgets.map.messages.Messages;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MapActivator
extends AbstractUIPlugin {
    public static final String FIND_BTN_IMG = "FIND_BTN";
    public static final String PLUGIN_ID = "com.jaspersoft.studio.widgets.map";
    private static MapActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        MapActivator.getFileLocation("mapfiles/gmaps_library/");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MapActivator getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable exception) {
        Platform.getLog((Bundle)MapActivator.getDefault().getBundle()).log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }

    public static String getFileLocation(String path) {
        Assert.isNotNull((Object)path);
        Bundle bundle = MapActivator.getDefault().getBundle();
        String fullPath = null;
        try {
            if (bundle != null) {
                fullPath = new Path(FileLocator.toFileURL((URL)bundle.getEntry(path)).getPath()).toOSString();
            }
        }
        catch (IOException ex) {
            MapActivator.logError(Messages.MapActivator_FileError, ex);
        }
        return fullPath;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Path path = new Path("icons/find-20.png");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(FIND_BTN_IMG, desc);
    }
}

