/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.core;

import java.io.Serializable;

public class LatLng
implements Serializable {
    private static final long serialVersionUID = 3334965103527376772L;
    private Double lat;
    private Double lng;

    public LatLng(Double lat, Double lng) {
        this(lat, lng, false);
    }

    public LatLng(Double lat, Double lng, boolean noWrap) {
        this.lat = lat;
        this.lng = lng;
        if (!noWrap) {
            if (Math.abs(lat) >= 85.05115) {
                lat = lat % 85.05115;
            }
            if (Math.abs(lng) >= 180.0) {
                lng = lng % 180.0;
            }
        }
    }

    public Double getLng() {
        return this.lng % 180.0;
    }

    public Double getLat() {
        return this.lat % 90.0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LatLng) {
            LatLng coords = (LatLng)obj;
            return this.getLat() == coords.getLat() && this.getLng() == coords.getLng();
        }
        return false;
    }

    public String toJsString() {
        return String.format("new google.maps.LatLng(%.7f,%.7f,true)", this.lat, this.lng);
    }
}

