/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.core;

import com.jaspersoft.studio.widgets.map.messages.Messages;

public enum MapType {
    ROADMAP("roadmap", "google.maps.MapTypeId.ROADMAP"),
    SATELLITE("satellite", "google.maps.MapTypeId.SATELLITE"),
    TERRAIN("terrain", "google.maps.MapTypeId.TERRAIN"),
    HYBRID("hybrid", "google.maps.MapTypeId.HYBRID");

    private String stringID;
    private String googleConstant;

    private MapType(String stringID, String googleConstant) {
        this.stringID = stringID;
        this.googleConstant = googleConstant;
    }

    public String getStringID() {
        return this.stringID;
    }

    public String getGoogleConstant() {
        return this.googleConstant;
    }

    public static MapType fromStringID(String stringID) {
        MapType[] mapTypeArray = MapType.values();
        int n = mapTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapType val = mapTypeArray[n2];
            if (val.getStringID().equals(stringID)) {
                return val;
            }
            ++n2;
        }
        throw new IllegalArgumentException(Messages.MapType_InvalidType);
    }
}

