/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.support.java;

import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.jrexpressions.functions.AdditionalStaticFunctions;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.Arguments;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.ExpressionList;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.FullMethodName;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JasperReportsExpression;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.MethodInvocation;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.MethodsExpression;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategorySelectionEvent;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategorySelectionListener;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.StyledTextXtextAdapter2;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;

public class EditingAreaHelper {
    private boolean update;
    private StyledTextXtextAdapter2 xtextAdapter;
    private StyledText textArea;
    private List<ObjectCategorySelectionListener> categorySelectionListeners = new ArrayList<ObjectCategorySelectionListener>();

    public EditingAreaHelper(StyledTextXtextAdapter2 xtextAdapter, StyledText textArea) {
        this.xtextAdapter = xtextAdapter;
        this.textArea = textArea;
    }

    public String getCurrentLibraryFunctionName() {
        String methodName;
        FullMethodName fullyQualifiedMethodName;
        MethodInvocation methodInv;
        ICompositeNode methodInvNode;
        Arguments args = this.getMethodArguments();
        if (args != null && args.eContainer() instanceof MethodInvocation && (methodInvNode = NodeModelUtils.findActualNodeFor((EObject)(methodInv = (MethodInvocation)args.eContainer()))) != null && methodInvNode.getText().endsWith(")") && (fullyQualifiedMethodName = methodInv.getFullyQualifiedMethodName()) != null && (FunctionsLibraryUtil.existsFunction((String)(methodName = fullyQualifiedMethodName.getMethodName())) || AdditionalStaticFunctions.getAllNames().contains(methodName))) {
            return methodName;
        }
        return null;
    }

    public int getArgumentPosition() {
        Arguments args = this.getMethodArguments();
        int actualNodeOffset = this.getActualNodeOffset();
        if (args != null) {
            ExpressionList exprLst = args.getExprLst();
            if (exprLst != null) {
                ICompositeNode expressionsLst = NodeModelUtils.getNode((EObject)exprLst);
                if (actualNodeOffset >= expressionsLst.getOffset()) {
                    int argumentPos = 1;
                    for (INode child : expressionsLst.getChildren()) {
                        if (child.getOffset() >= actualNodeOffset || !(child.getGrammarElement() instanceof Keyword) || !",".equals(((Keyword)child.getGrammarElement()).getValue())) continue;
                        ++argumentPos;
                    }
                    return argumentPos;
                }
            } else if (actualNodeOffset >= NodeModelUtils.getNode((EObject)args).getOffset() + 1) {
                return 1;
            }
        }
        return -1;
    }

    public String getTextForArgument(int position) {
        ExpressionList exprLst;
        Arguments args = this.getMethodArguments();
        if (args != null && (exprLst = args.getExprLst()) != null) {
            if (exprLst.getCommas().size() > 0) {
                if (position > exprLst.getCommas().size() + 1) {
                    return null;
                }
                int commasNum = exprLst.getCommas().size();
                ICompositeNode argsNode = NodeModelUtils.getNode((EObject)args);
                int argsStart = argsNode.getOffset();
                int argsEnd = argsNode.getTotalEndOffset();
                int selectionStart = -1;
                int selectionEnd = -1;
                ArrayList<Integer> commasOffsets = new ArrayList<Integer>();
                for (INode c : NodeModelUtils.findActualNodeFor((EObject)exprLst).getChildren()) {
                    if (!(c.getGrammarElement() instanceof Keyword) || !",".equals(((Keyword)c.getGrammarElement()).getValue())) continue;
                    commasOffsets.add(c.getOffset());
                }
                if (position == 1) {
                    selectionStart = argsStart + 1;
                    selectionEnd = (Integer)commasOffsets.get(0);
                } else if (position == commasNum + 1) {
                    selectionStart = (Integer)commasOffsets.get(commasNum - 1) + 1;
                    selectionEnd = argsEnd - 1;
                } else {
                    selectionStart = (Integer)commasOffsets.get(position - 2) + 1;
                    selectionEnd = (Integer)commasOffsets.get(position - 1);
                }
                if (selectionStart != -1 && selectionEnd != -1 && selectionEnd > selectionStart) {
                    try {
                        return this.textArea.getText(selectionStart, selectionEnd - 1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return null;
                    }
                }
                return null;
            }
            if (exprLst.getExpressions().size() == 1 && position == 1) {
                ICompositeNode exprNode = NodeModelUtils.getNode((EObject)((EObject)exprLst.getExpressions().get(0)));
                return NodeModelUtils.getTokenText((INode)exprNode);
            }
        }
        return null;
    }

    public void selectMethodArgument(int position, int lastPosition, List<String> parametersTexts) {
        Arguments args = this.getMethodArguments();
        if (args != null) {
            ICompositeNode methodsExprNode;
            JasperReportsExpression firstExpr;
            ICompositeNode argsNode = NodeModelUtils.findActualNodeFor((EObject)args);
            int argsStart = argsNode.getOffset();
            int argsEnd = argsNode.getTotalEndOffset();
            if (args.getExprLst() != null && args.getExprLst().getExpressions() != null && args.getExprLst().getExpressions().size() > 0 && (firstExpr = (JasperReportsExpression)args.getExprLst().getExpressions().get(0)) instanceof MethodsExpression && !(methodsExprNode = NodeModelUtils.findActualNodeFor((EObject)firstExpr)).getText().endsWith(")")) {
                argsStart = methodsExprNode.getTotalEndOffset() - 1;
            }
            int positionStart = -1;
            int positionEnd = -1;
            this.textArea.setSelection(argsStart + 1, argsEnd - 1);
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < lastPosition - 1) {
                String paramTxt = parametersTexts.get(i);
                int paramTxtLength = paramTxt.length();
                if (i == position - 1) {
                    positionStart = argsStart + sb.length() + 1;
                    positionEnd = positionStart + Math.max(paramTxtLength, 1);
                }
                sb.append(paramTxt);
                if (paramTxtLength == 0) {
                    sb.append(" ");
                }
                sb.append(",");
                ++i;
            }
            String lastParamTxt = parametersTexts.get(lastPosition - 1);
            int lastParamTextLength = lastParamTxt.length();
            if (position == lastPosition) {
                positionStart = argsStart + sb.length() + 1;
                positionEnd = positionStart + Math.max(lastParamTextLength, 1);
            }
            if (lastParamTextLength == 0) {
                sb.append(" ");
            }
            sb.append(lastParamTxt);
            this.textArea.insert(sb.toString());
            this.textArea.setSelection(positionStart, positionEnd);
            return;
        }
    }

    private Arguments getMethodArguments() {
        try {
            ICompositeNode actualNode;
            if (this.xtextAdapter.getXtextParseResult() != null && (actualNode = this.getActualNode()) != null) {
                ICompositeNode tmpParentNode = actualNode;
                boolean foundParentNode = false;
                while (!foundParentNode && tmpParentNode != null) {
                    if (tmpParentNode.getSemanticElement() instanceof Arguments || tmpParentNode.getSemanticElement() instanceof MethodInvocation) {
                        foundParentNode = true;
                        continue;
                    }
                    tmpParentNode = tmpParentNode.getParent();
                }
                if (foundParentNode) {
                    Arguments args = null;
                    args = tmpParentNode.getSemanticElement() instanceof MethodInvocation ? ((MethodInvocation)tmpParentNode.getSemanticElement()).getArgs() : (Arguments)tmpParentNode.getSemanticElement();
                    return args;
                }
            }
        }
        catch (Exception ex) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"A problem occurred during the expression parsing.", (Throwable)ex);
        }
        return null;
    }

    public ICompositeNode getActualNode() {
        if (this.xtextAdapter.getXtextParseResult() != null) {
            int caretOffset = this.textArea.getCaretOffset();
            EObjectAtOffsetHelper eobjHelper = new EObjectAtOffsetHelper();
            EObject resolvedEObj = eobjHelper.resolveElementAt(this.xtextAdapter.getFakeResourceContext().getFakeResource(), caretOffset);
            return NodeModelUtils.findActualNodeFor((EObject)resolvedEObj);
        }
        return null;
    }

    public int getActualNodeOffset() {
        ICompositeNode actualNode = this.getActualNode();
        return actualNode != null ? actualNode.getOffset() : -1;
    }

    public void insertAtCurrentLocation(String partialExpression, boolean selectNewText, boolean moveAfterText) {
        int start;
        Point currSelection = this.textArea.getSelection();
        this.textArea.insert(partialExpression);
        this.textArea.redraw();
        int end = start = currSelection.x;
        if (selectNewText) {
            end = start + partialExpression.length();
        }
        if (moveAfterText) {
            int newPosition;
            start = end = (newPosition = end + partialExpression.length());
        }
        this.textArea.setSelection(start, end);
    }

    public void drawFakeCursor() {
        int selectionStart = this.textArea.getSelection().x;
        int selectionEnd = this.textArea.getSelection().y;
        if (selectionStart == selectionEnd) {
            Point position = this.textArea.getLocationAtOffset(selectionEnd);
            int height = this.textArea.getLineHeight(selectionEnd);
            GC gc = new GC((Drawable)this.textArea);
            gc.setBackground(this.textArea.getDisplay().getSystemColor(2));
            gc.fillRectangle(position.x, position.y, 2, height);
            gc.dispose();
        }
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void removeCategorySelectionListener(ObjectCategorySelectionListener listener) {
        this.categorySelectionListeners.remove(listener);
    }

    public void addCategorySelectionListener(ObjectCategorySelectionListener listener) {
        this.categorySelectionListeners.add(listener);
    }

    public void notifyCategorySelection(ObjectCategorySelectionEvent selectionEvent) {
        for (ObjectCategorySelectionListener l : this.categorySelectionListeners) {
            l.select(selectionEvent);
        }
    }

    public void ignoreAutoEditStrategies(boolean ignore) {
        this.xtextAdapter.ignoreAutoEditStrategies(ignore);
    }

    public void moveCaretToNextParenthesis() {
        int caretOffset = this.textArea.getCaretOffset();
        int textLength = this.textArea.getText().length();
        String text = this.textArea.getText();
        int newPosition = -1;
        int i = caretOffset;
        while (i <= textLength) {
            if (text.charAt(i) == '(') {
                newPosition = i + 1;
                break;
            }
            ++i;
        }
        if (newPosition != -1) {
            this.textArea.setSelection(newPosition, newPosition);
        }
    }

    public void moveCaretAhead(int positions) {
        int newpos = this.textArea.getSelection().y + positions;
        this.textArea.setSelection(newpos, newpos);
    }
}

