/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IChangeSetMergeInput;
import com.collabnet.subversion.merge.IChangeSetMergeInputProvider;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.IMergeWizardChangeSetPage;
import com.collabnet.subversion.merge.wizards.MergeWizardBestPracticesPage;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class MergeWizard
extends Wizard {
    private IResource[] resources;
    private IChangeSetMergeInput[] changeSetMergeInputs;
    private IWorkbenchPart targetPart;
    private IMergeInputProvider[] mergeInputProviders;
    private MergeWizardMainPage mainPage;
    private MergeWizardBestPracticesPage bestPracticesPage;
    private MergeWizardLastPage lastPage;
    private IWizardPage[][] pages;
    private IChangeSetMergeInputProvider changeSetMergeInputProvider;
    private String commonRoot;
    private String[] urlStrings;
    private boolean checkBestPractices;
    private boolean retrieveRevisionsMethodChanged;
    public static final String LAST_RELATIVE_PATH_CHOICE = "MergeWizard.relativePath";
    public static final String LAST_RETRIEVE_ELIGIBLE_REVISIONS_SEPARATELY = "MergeWizard.retrieveEligibleRevisionsSeparately";

    public MergeWizard(IResource[] resources, IWorkbenchPart targetPart) {
        this.resources = resources;
        this.targetPart = targetPart;
    }

    public MergeWizard(IChangeSetMergeInput[] changeSetMergeInputs, IWorkbenchPart targetPart) {
        this.changeSetMergeInputs = changeSetMergeInputs;
        this.targetPart = targetPart;
    }

    public void addPages() {
        IWizardPage[] providerPages;
        super.addPages();
        try {
            this.mergeInputProviders = Activator.getMergeInputProviders();
        }
        catch (Exception e) {
            Activator.handleError(e);
        }
        this.setWindowTitle(Messages.MergeWizard_title);
        if (this.changeSetMergeInputs == null) {
            this.mainPage = new MergeWizardMainPage("main", Messages.MergeWizard_selectType, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), this.mergeInputProviders);
            this.addPage((IWizardPage)this.mainPage);
        }
        this.bestPracticesPage = new MergeWizardBestPracticesPage("bestPractices", Messages.MergeWizard_bestPractices, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"));
        if (this.changeSetMergeInputs == null) {
            this.addPage((IWizardPage)this.bestPracticesPage);
        }
        this.pages = new WizardPage[this.mergeInputProviders.length][];
        int i = 0;
        while (i < this.mergeInputProviders.length) {
            providerPages = this.mergeInputProviders[i].getWizardPages(true);
            this.pages[i] = providerPages;
            if (this.changeSetMergeInputs != null && this.mergeInputProviders[i] instanceof IChangeSetMergeInputProvider) {
                this.changeSetMergeInputProvider = (IChangeSetMergeInputProvider)this.mergeInputProviders[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.pages.length) {
            providerPages = this.pages[i];
            if (providerPages != null && (this.changeSetMergeInputs == null || this.mergeInputProviders[i] instanceof IChangeSetMergeInputProvider)) {
                int j = 0;
                while (j < providerPages.length) {
                    this.addPage(providerPages[j]);
                    if (this.changeSetMergeInputs != null && providerPages[j] instanceof IMergeWizardChangeSetPage) {
                        this.addPage((IWizardPage)this.bestPracticesPage);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.lastPage = new MergeWizardLastPage("last", Messages.MergeWizard_selectOptions, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"));
        this.addPage((IWizardPage)this.lastPage);
    }

    public boolean canFinish() {
        if (this.mainPage != null && !this.mainPage.isPageComplete() || !this.lastPage.isPageComplete()) {
            return false;
        }
        if (this.mainPage != null && this.mainPage.showBestPracticesPage() && !this.bestPracticesPage.isPageComplete()) {
            return false;
        }
        IWizardPage[] providerPages = this.changeSetMergeInputProvider == null ? this.mainPage.getSelectedMergeInputProvider().getWizardPages(false) : this.changeSetMergeInputProvider.getWizardPages(false);
        if (providerPages == null) {
            return true;
        }
        int i = 0;
        while (i < providerPages.length) {
            if (!providerPages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IMergeWizardChangeSetPage changeSetPage;
        if (page instanceof MergeWizardLastPage) {
            return null;
        }
        if (page instanceof MergeWizardMainPage) {
            if (this.mainPage.showBestPracticesPage() && this.checkBestPractices) {
                if (this.bestPracticesPage.isPageShown()) {
                    return this.bestPracticesPage;
                }
                if (this.bestPracticesPage.needsChecks()) {
                    this.bestPracticesPage.performChecks(true);
                }
                if (this.bestPracticesPage.hasWarnings()) {
                    return this.bestPracticesPage;
                }
            }
            this.checkBestPractices = true;
            IWizardPage[] providerPages = this.mainPage.getSelectedMergeInputProvider().getWizardPages(false);
            if (providerPages == null || providerPages.length == 0) {
                if (!Activator.getDefault().isDesktopInstalled()) {
                    return null;
                }
                return this.lastPage;
            }
            return providerPages[0];
        }
        if (page instanceof IMergeWizardChangeSetPage && this.changeSetMergeInputs != null && (changeSetPage = (IMergeWizardChangeSetPage)page).showBestPracticesPage()) {
            if (this.bestPracticesPage.isPageShown()) {
                return this.bestPracticesPage;
            }
            if (this.bestPracticesPage.needsChecks()) {
                this.bestPracticesPage.performChecks(true);
            }
            if (this.bestPracticesPage.hasWarnings()) {
                return this.bestPracticesPage;
            }
        }
        if (page instanceof MergeWizardBestPracticesPage) {
            IWizardPage[] providerPages = this.changeSetMergeInputProvider == null ? this.mainPage.getSelectedMergeInputProvider().getWizardPages(false) : this.changeSetMergeInputProvider.getWizardPages(false);
            if (providerPages == null || providerPages.length == 0) {
                return this.lastPage;
            }
            if (this.changeSetMergeInputProvider == null) {
                return providerPages[0];
            }
            return providerPages[1];
        }
        IWizardPage nextPage = this.changeSetMergeInputProvider == null ? this.mainPage.getSelectedMergeInputProvider().getNextPage(page) : this.changeSetMergeInputProvider.getNextPage(page);
        if (nextPage == null) {
            if (this.mainPage != null && this.mainPage.getSelectedMergeInputProvider().showOptionsPage()) {
                return this.lastPage;
            }
            if (this.changeSetMergeInputProvider != null && this.changeSetMergeInputProvider.showOptionsPage()) {
                return this.lastPage;
            }
        }
        return nextPage;
    }

    public boolean performFinish() {
        IMergeInputProvider selectedMergeInputProvider = this.changeSetMergeInputProvider == null ? this.mainPage.getSelectedMergeInputProvider() : this.changeSetMergeInputProvider;
        return selectedMergeInputProvider.performMerge(this.mainPage, this.lastPage, this.targetPart);
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public IChangeSetMergeInput[] getChangeSetMergeInputs() {
        return this.changeSetMergeInputs;
    }

    public IResource getResource() {
        this.resources = this.getResources();
        if (this.resources == null) {
            return null;
        }
        return this.resources[0];
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }

    public MergeWizardBestPracticesPage getBestPracticesPage() {
        return this.bestPracticesPage;
    }

    public boolean isRetrieveRevisionsMethodChanged() {
        return this.retrieveRevisionsMethodChanged;
    }

    public void setRetrieveRevisionsMethodChanged(boolean retrieveRevisionsMethodChanged) {
        this.retrieveRevisionsMethodChanged = retrieveRevisionsMethodChanged;
    }

    public boolean suggestMergeSources() {
        return SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_suggest_merge_sources");
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public IMergeInputProvider getSelectedMergeInputProvider() {
        if (this.changeSetMergeInputProvider == null) {
            return this.mainPage.getSelectedMergeInputProvider();
        }
        return this.changeSetMergeInputProvider;
    }

    public void setCommonRoot(String commonRoot) {
        this.commonRoot = commonRoot;
    }

    public String getCommonRoot() {
        if (this.commonRoot == null) {
            ArrayList<String> urlList = new ArrayList<String>();
            int i = 0;
            while (i < this.resources.length) {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
                try {
                    String anUrl = svnResource.getStatus().getUrlString();
                    if (anUrl != null) {
                        urlList.add(anUrl);
                    }
                }
                catch (SVNException sVNException) {}
                ++i;
            }
            this.urlStrings = new String[urlList.size()];
            urlList.toArray(this.urlStrings);
            if (this.urlStrings.length == 0) {
                return null;
            }
            String urlString = this.urlStrings[0];
            if (this.urlStrings.length == 1) {
                return urlString;
            }
            this.commonRoot = null;
            int i2 = 0;
            block3: while (i2 < urlString.length()) {
                String partialPath = urlString.substring(0, i2 + 1);
                if (partialPath.endsWith("/")) {
                    int j = 1;
                    while (j < this.urlStrings.length) {
                        if (!this.urlStrings[j].startsWith(partialPath)) break block3;
                        ++j;
                    }
                    this.commonRoot = partialPath.substring(0, i2);
                }
                ++i2;
            }
        }
        return this.commonRoot;
    }

    public String[] getUrlStrings() {
        if (this.commonRoot == null) {
            this.commonRoot = this.getCommonRoot();
        }
        return this.urlStrings;
    }

    public IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }
}

