/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.jdbc.JDBCDataAdapterDescriptor;
import com.jaspersoft.studio.data.querydesigner.sql.SimpleSQLQueryDesigner;
import com.jaspersoft.studio.data.sql.QueryWriter;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderBy;
import com.jaspersoft.studio.data.sql.text2model.Text2Model;
import com.jaspersoft.studio.data.sql.ui.SQLQueryOutline;
import com.jaspersoft.studio.data.sql.ui.SQLQuerySource;
import com.jaspersoft.studio.data.sql.ui.gef.SQLQueryDiagram;
import com.jaspersoft.studio.data.sql.ui.metadata.DBMetadata;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.property.dataset.dialog.DatasetDialog;
import com.jaspersoft.studio.swt.widgets.CSashForm;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.jobs.CheckedRunnableWithProgress;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SQLQueryDesigner
extends SimpleSQLQueryDesigner {
    public static final String SQLQUERYDESIGNER = "SQLQUERYDESIGNER";
    private CSashForm sf;
    private DBMetadata dbMetadata;
    private SQLQuerySource source;
    private SQLQueryOutline outline;
    private SQLQueryDiagram diagram;
    private MSQLRoot root;
    private boolean isModelRefresh = false;
    private boolean refreshMetadata = false;
    private IProgressMonitor runningmonitor;
    private CTabFolder tabFolder;
    private Set<MSQLRoot> roots = new HashSet<MSQLRoot>();
    private DataAdapterDescriptor da;
    private PreferenceListener preferenceListener = new PreferenceListener();
    private PropertyChangeListener tblListener = arg0 -> {
        if (this.getjDataset() == null) {
            return;
        }
        final HashSet tables = new HashSet();
        new ModelVisitor<String>((INode)arg0.getSource()){

            public boolean visit(INode n) {
                if (n instanceof MFromTable) {
                    MFromTable ft = (MFromTable)n;
                    Object x = ft.getPropertyActualValue("x");
                    Object y = ft.getPropertyActualValue("y");
                    if (x != null && y != null) {
                        String str = String.valueOf(((MSqlTable)ft.getValue()).toSQLString()) + ft.getAliasKeyString() + "," + x + "," + y + "," + ft.getId();
                        String sm = (String)ft.getPropertyValue("showMode");
                        if (sm != null) {
                            str = String.valueOf(str) + "," + sm;
                        }
                        str = String.valueOf(str) + ";";
                        tables.add(str);
                    }
                } else if (n instanceof MFrom) {
                    MFrom ft = (MFrom)n;
                    Object x = ft.getPropertyActualValue("x");
                    Object y = ft.getPropertyActualValue("y");
                    if (x != null && y != null) {
                        tables.add("\t\tFROM," + x + "," + y + "," + ft.getId() + ";");
                    }
                }
                return true;
            }
        };
        StringBuilder input = new StringBuilder();
        for (String t : tables) {
            input.append(t);
        }
        try {
            this.getjDataset().setProperty("com.jaspersoft.studio.data.sql.tables", Misc.encodeBase64String((String)input.toString(), (String)"ISO-8859-1"));
        }
        catch (IOException e) {
            this.container.getQueryStatus().showError((Throwable)e);
        }
    };

    public SQLQueryDesigner() {
        this.refreshViewer();
    }

    public Control getControl() {
        return this.sf;
    }

    protected void parameterNameChanged(String oldValue, String newValue) {
        String q = this.source.getQuery();
        q = q.replaceAll("\\$P\\{" + oldValue + "\\}", Matcher.quoteReplacement("$P{" + newValue + "}"));
        this.source.setQuery(q);
        Text2Model.text2model(this, this.source.getXTextDocument(), true);
        this.outline.scheduleRefresh();
        this.diagram.scheduleRefresh(false, true);
    }

    public Control createControl(Composite parent) {
        this.sf = new CSashForm(parent, 256);
        this.sf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dbMetadata = new DBMetadata(this);
        this.dbMetadata.createControl((Composite)this.sf);
        this.tabFolder = new CTabFolder((Composite)this.sf, 0x800C00);
        this.createSource(this.tabFolder);
        this.createOutline(this.tabFolder);
        this.createDiagram(this.tabFolder);
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SQLQueryDesigner.this.source.isDirty()) {
                    Text2Model.text2model(SQLQueryDesigner.this, SQLQueryDesigner.this.source.getXTextDocument(), true);
                }
                switch (SQLQueryDesigner.this.tabFolder.getSelectionIndex()) {
                    case 1: {
                        SQLQueryDesigner.this.outline.scheduleRefresh();
                        break;
                    }
                    case 2: {
                        SQLQueryDesigner.this.diagram.scheduleRefresh(false, true);
                    }
                }
                SQLQueryDesigner.this.source.setDirty(false);
            }
        });
        this.sf.setWeights(new int[]{250, 750});
        return this.sf;
    }

    public boolean isDiagram() {
        return this.tabFolder.getSelectionIndex() == 2;
    }

    protected void createDiagram(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.SQLQueryDesigner_diagram);
        this.diagram = new SQLQueryDiagram(this);
        bptab.setControl(this.diagram.createDiagram((Composite)tabFolder));
    }

    protected void createOutline(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.SQLQueryDesigner_outline);
        this.outline = new SQLQueryOutline(this);
        bptab.setControl(this.outline.createOutline((Composite)tabFolder));
    }

    private void createSource(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.SQLQueryDesigner_text);
        this.source = new SQLQuerySource(this);
        bptab.setControl(this.source.createSource((Composite)tabFolder));
        this.setupSourceEditorFont();
    }

    public void doSourceTextChanged() {
        super.doSourceTextChanged();
    }

    protected String getQueryFromWidget() {
        return this.source.getQuery();
    }

    protected void createLineStyler() {
    }

    protected void setupSourceEditorFont() {
        this.source.setupFont(this.jConfig);
    }

    protected void updateQueryText(String txt) {
        if (this.refreshMetadata) {
            return;
        }
        if (this.source != null) {
            this.source.setQuery(txt);
        }
        if (!this.isModelRefresh) {
            this.refreshQueryModel();
        }
    }

    public void refreshModel() {
        ModelVisitor.printModel((ANode)this.root);
        if (this.outline != null) {
            this.outline.getTreeViewer().setInput((Object)this.root);
            this.outline.getTreeViewer().refresh();
            this.outline.getTreeViewer().setSelection(null);
        }
        if (this.tabFolder.getSelectionIndex() == 2) {
            this.diagram.scheduleRefresh(false, false);
        }
    }

    public void refreshQueryModel() {
        if (this.source != null) {
            Text2Model.text2model(this, this.source.getXTextDocument());
        }
    }

    public void setRefreshMetadata(boolean refreshMetadata) {
        this.refreshMetadata = refreshMetadata;
    }

    public void refreshedMetadata() {
        if (this.tabFolder.getSelectionIndex() == 0) {
            this.source.setDirty(true);
        }
        if (this.tabFolder.getSelectionIndex() == 1) {
            this.outline.scheduleRefresh();
        }
        if (this.tabFolder.getSelectionIndex() == 2) {
            this.diagram.scheduleRefresh(false, false);
        }
    }

    public void refreshQueryText() {
        if (this.refreshMetadata) {
            return;
        }
        if (this.root != null) {
            this.isModelRefresh = true;
            this.updateQueryText(QueryWriter.writeQuery((ANode)this.root));
            this.isModelRefresh = false;
        }
    }

    public void refreshQuery() {
        if (this.refreshMetadata) {
            return;
        }
        if (this.root != null) {
            this.isModelRefresh = true;
            if (!this.isQueryModelEmpty()) {
                this.updateQueryText(QueryWriter.writeQuery((ANode)this.root));
            }
            if (this.tabFolder.getSelectionIndex() == 2) {
                this.diagram.scheduleRefresh(false, false);
            }
            this.isModelRefresh = false;
        }
    }

    protected boolean isQueryModelEmpty() {
        boolean update = true;
        for (INode c : this.root.getChildren()) {
            if (c.getChildren().isEmpty()) continue;
            update = false;
            break;
        }
        return update;
    }

    public Object getActiveEditor() {
        switch (this.tabFolder.getSelectionIndex()) {
            case 0: {
                return this.source;
            }
            case 1: {
                return this.outline;
            }
            case 2: {
                return this.diagram;
            }
        }
        return null;
    }

    public void setDataAdapter(DataAdapterDescriptor da) {
        if (this.da == da) {
            return;
        }
        this.da = da;
        super.setDataAdapter(da);
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.runningmonitor != null) {
                this.runningmonitor.setCanceled(true);
            }
            this.updateMetadata();
        });
    }

    private boolean canUpdateMetadata() {
        if (this.jConfig != null) {
            String loading = this.jConfig.getProperty("com.jaspersoft.studio.data.sql.prefs.JDBCMETADATALOADING", "ALWAYS_ENABLED");
            if (DatasetDialog.isInitialJDBCMetadataLoading()) {
                return "ALWAYS_ENABLED".equals(loading);
            }
            return "ALWAYS_ENABLED".equals(loading) || "DISABLED_ON_STARTUP".equals(loading);
        }
        return true;
    }

    private void updateMetadataMessage() {
        if (this.jConfig != null) {
            String loading = this.jConfig.getProperty("com.jaspersoft.studio.data.sql.prefs.JDBCMETADATALOADING", "ALWAYS_ENABLED");
            if ("ALWAYS_DISABLED".equals(loading)) {
                this.dbMetadata.updateMessageText(Messages.SQLQueryDesigner_MetadataLoadingAlwaysDisabledMsg);
            } else if (DatasetDialog.isInitialJDBCMetadataLoading() && "DISABLED_ON_STARTUP".equals(loading)) {
                this.dbMetadata.updateMessageText(Messages.SQLQueryDesigner_MetadataLoadingDisabledOnOpenMsg);
            }
        }
    }

    public void updateMetadata() {
        this.updateMetadataMessage();
        if (this.canUpdateMetadata() && this.da instanceof JDBCDataAdapterDescriptor) {
            try {
                this.getRoot().setValue(this.getjDataset());
                this.container.run(true, true, (IRunnableWithProgress)new CheckedRunnableWithProgress(){

                    protected void runOperations(IProgressMonitor monitor) {
                        try {
                            SQLQueryDesigner.this.runningmonitor = monitor;
                            monitor.beginTask(Messages.SQLQueryDesigner_readmetadata, -1);
                            SQLQueryDesigner.this.dbMetadata.closeConnection();
                            DataAdapterService das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)SQLQueryDesigner.this.jConfig, null, null)).getService(SQLQueryDesigner.this.da.getDataAdapter());
                            SQLQueryDesigner.this.dbMetadata.updateMetadata(SQLQueryDesigner.this.da, das, monitor);
                        }
                        finally {
                            monitor.done();
                            SQLQueryDesigner.this.runningmonitor = null;
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.container.getQueryStatus().showError(ex.getTargetException());
                this.runningmonitor = null;
                this.dbMetadata.forceRunningStatus(false);
            }
            catch (InterruptedException ex) {
                this.container.getQueryStatus().showError((Throwable)ex);
                this.runningmonitor = null;
                this.dbMetadata.forceRunningStatus(false);
            }
        }
        if (DatasetDialog.isInitialJDBCMetadataLoading()) {
            DatasetDialog.initialJDBCMetadataPerformed();
        }
    }

    public SQLQueryOutline getOutline() {
        return this.outline;
    }

    public SQLQueryDiagram getDiagram() {
        return this.diagram;
    }

    public void dispose() {
        if (this.dbMetadata != null) {
            this.dbMetadata.dispose();
        }
        if (this.outline != null) {
            this.outline.dispose();
        }
        if (this.diagram != null) {
            this.diagram.dispose();
        }
        JaspersoftStudioPlugin.getInstance().removePreferenceListener((IPropertyChangeListener)this.preferenceListener);
        super.dispose();
    }

    public DBMetadata getDbMetadata() {
        return this.dbMetadata;
    }

    public MSQLRoot getRoot() {
        return this.root;
    }

    public void setQuery(JasperDesign jDesign, JRDataset jDataset, JasperReportsConfiguration jConfig) {
        super.setQuery(jDesign, jDataset, jConfig);
        JaspersoftStudioPlugin.getInstance().addPreferenceListener((IPropertyChangeListener)this.preferenceListener, (IResource)jConfig.get("ifile"));
        this.initSashForm(this.sf);
        this.doRefreshRoots(false);
    }

    public MSQLRoot createRoot(MSQLRoot oldRoot) {
        if (oldRoot != null) {
            oldRoot.getPropertyChangeSupport().removePropertyChangeListener(this.tblListener);
            this.roots.remove((Object)oldRoot);
        }
        MSQLRoot rt = new MSQLRoot(null, this.getjDataset());
        if (this.jConfig != null) {
            rt.setIdentifierQuote(this.jConfig.getProperty("com.jaspersoft.studio.data.sql.prefs.IDENTIFIER_QUOTE", ""));
        }
        this.roots.add(rt);
        rt.getPropertyChangeSupport().addPropertyChangeListener(this.tblListener);
        return rt;
    }

    public void refreshViewer() {
        if (this.root != null) {
            this.root.removeChildren();
        } else {
            this.root = this.createRoot(this.root);
        }
        Util.createSelect((ANode)this.root);
        new MOrderBy((ANode)this.root);
    }

    public void doRefreshRoots(boolean updateText) {
        String iq = this.jConfig.getProperty("com.jaspersoft.studio.data.sql.prefs.IDENTIFIER_QUOTE", "");
        boolean useJDBCQuote = this.jConfig.getPropertyBoolean("com.jaspersoft.studio.data.sql.prefs.USEJDBCQUOTE", true);
        if (useJDBCQuote) {
            iq = this.dbMetadata.getIdentifierQuote();
        }
        boolean quoteExceptions = this.jConfig.getPropertyBoolean("com.jaspersoft.studio.data.sql.prefs.QUOTE_ONLY_EXCEPTIONS", true);
        for (MSQLRoot r : this.roots) {
            r.setSchemaTableQuote(this.dbMetadata.isSchemaTableQuote());
            r.setIdentifierQuote(iq);
            r.setQuoteExceptions(quoteExceptions);
        }
        if (updateText) {
            this.refreshQueryText();
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String p = event.getProperty();
            if (p.equals("com.jaspersoft.studio.data.sql.prefs.IDENTIFIER_QUOTE")) {
                SQLQueryDesigner.this.doRefreshRoots(true);
            }
        }
    }
}

