/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.designer.IFilterQuery;
import com.jaspersoft.studio.data.designer.SelectParameterDialog;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpressionX;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ParameterPOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.UnknownOperand;
import com.jaspersoft.studio.data.sql.widgets.AOperandWidget;
import com.jaspersoft.studio.data.sql.widgets.Factory;
import com.jaspersoft.studio.data.sql.widgets.ParameterWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EditExpressionXDialog
extends ATitledDialog
implements IFilterQuery {
    private MExpressionX value;
    private AQueryDesigner designer;
    private List<AOperand> operands;
    private String prevcond;
    private String function;
    private Map<String, Composite> map = new HashMap<String, Composite>();
    private Composite rcmp;
    private StackLayout stackLayout;

    public EditExpressionXDialog(Shell parentShell, AQueryDesigner designer) {
        super(parentShell);
        this.designer = designer;
        this.setTitle("Expression ${X} Dialog");
        this.setDescription("SQL syntax is different in case of NULL or not NULL comparison. Example: b = 1 , b IS NULL. Before query execution\nthe $X{} function will adapt the SQL string in the correct way, depending if parameter is null or not null.");
    }

    public boolean close() {
        if (this.isTwoOperands() && this.operands.size() > 1) {
            Util.removeFrom(this.operands, 1);
        } else if (this.isThreeOperands() && this.operands.size() > 2) {
            Util.removeFrom(this.operands, 2);
        }
        return super.close();
    }

    public void setValue(MExpressionX value) {
        this.value = value;
        this.setFunction(value.getFunction());
        this.setPrevcond(value.getPrevCond());
        this.operands = new ArrayList<AOperand>(value.getOperands());
    }

    public String getPrevcond() {
        return this.prevcond;
    }

    public void setPrevcond(String prevcond) {
        this.prevcond = prevcond;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public List<AOperand> getOperands() {
        return this.operands;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(5, false));
        DataBindingContext bindingContext = new DataBindingContext();
        if (!this.value.isFirst()) {
            Composite c = new Composite(cmp, 0);
            GridLayout layout = new GridLayout(5, false);
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            c.setLayoutData((Object)gd);
            new Label(c, 0).setText("Previous condition ");
            Combo prevoperator = new Combo(c, 8);
            prevoperator.setItems(AMKeyword.CONDITIONS);
            new Label(c, 0).setText(" this one.");
            bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)prevoperator), PojoProperties.value((String)"prevcond").observe((Object)this));
        } else {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            new Label(cmp, 0).setLayoutData((Object)gd);
        }
        this.createSQLWidget(cmp);
        Combo operator = new Combo(cmp, 8);
        operator.setItems(MExpressionX.FUNCTIONS);
        operator.setLayoutData((Object)new GridData(2));
        operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionXDialog.this.showRight();
            }
        });
        this.rcmp = new Composite(cmp, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.rcmp.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 300;
        gd.verticalSpan = 2;
        gd.horizontalSpan = 3;
        this.rcmp.setLayoutData((Object)gd);
        this.showRight();
        bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)operator), PojoProperties.value((String)"function").observe((Object)this));
        return cmp;
    }

    protected void createSQLWidget(Composite cmp) {
        Composite parent = new Composite(cmp, 0);
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        parent.setLayout((Layout)gd);
        HashSet<Class<? extends AOperand>> mop = new HashSet<Class<? extends AOperand>>();
        mop.add(FieldOperand.class);
        mop.add(UnknownOperand.class);
        Factory.createWidget(parent, this.operands, 0, this.value, mop, this.designer);
    }

    private void showRight() {
        Composite cmp = this.map.get(this.getFunction());
        if (cmp == null) {
            if (this.isTwoOperands()) {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                if (this.operands.size() < 2) {
                    this.operands.add(new ParameterPOperand(this.value, false));
                }
                AOperandWidget<?> w = Factory.createWidget(cmp, this.operands.get(1), this.designer);
                w.setOperandMap(w.getOperandMap());
                w.setOperands(this.operands, 0);
                GridData gd = new GridData(768);
                gd.widthHint = 200;
                w.setLayoutData(gd);
            } else if (this.isThreeOperands()) {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(3, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                if (this.operands.size() < 2) {
                    this.operands.add(new ParameterPOperand(this.value, false));
                }
                AOperandWidget<?> w = Factory.createWidget(cmp, this.operands.get(1), this.designer);
                w.setOperandMap(w.getOperandMap());
                w.setOperands(this.operands, 0);
                GridData gd = new GridData(768);
                gd.widthHint = 200;
                w.setLayoutData(gd);
                new Label(cmp, 0).setText("AND");
                if (this.operands.size() < 3) {
                    this.operands.add(new ParameterPOperand(this.value, false));
                }
                w = Factory.createWidget(cmp, this.operands.get(2), this.designer);
                w.setOperandMap(w.getOperandMap());
                w.setOperands(this.operands, 0);
                gd = new GridData(768);
                gd.widthHint = 200;
                w.setLayoutData(gd);
            } else if (this.isManyOperands()) {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                this.createInList(cmp);
            }
        }
        this.stackLayout.topControl = cmp;
        this.rcmp.layout(true);
    }

    protected boolean isManyOperands() {
        return this.function.equals("IN") || this.function.equals("NOTIN");
    }

    protected boolean isThreeOperands() {
        return this.function.equals("BETWEEN") || this.function.equals("[BETWEEN]") || this.function.equals("[BETWEEN") || this.function.equals("BETWEEN]");
    }

    protected boolean isTwoOperands() {
        return this.function.equals("EQUAL") || this.function.equals("NOTEQUAL") || this.function.equals("GREATER") || this.function.equals("[GREATER") || this.function.equals("LESS") || this.function.equals("LESS]");
    }

    protected void createInList(Composite cmp) {
        final org.eclipse.swt.widgets.List inlist = new org.eclipse.swt.widgets.List(cmp, 2058);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.widthHint = 200;
        inlist.setLayoutData((Object)gd);
        Button op3 = new Button(cmp, 8);
        op3.setText("&Add");
        gd = new GridData(768);
        op3.setLayoutData((Object)gd);
        op3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionXDialog.this.handleAddInList(inlist);
            }
        });
        op3 = new Button(cmp, 8);
        op3.setText("&Edit");
        gd = new GridData(768);
        op3.setLayoutData((Object)gd);
        op3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionXDialog.this.handleEditInList(inlist);
            }
        });
        op3 = new Button(cmp, 8);
        op3.setText("&Delete");
        gd = new GridData(770);
        op3.setLayoutData((Object)gd);
        op3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = inlist.getSelectionIndex() + 1;
                if (index >= 0 && index < EditExpressionXDialog.this.operands.size()) {
                    EditExpressionXDialog.this.operands.remove(index);
                    EditExpressionXDialog.this.showInList(inlist);
                }
            }
        });
        inlist.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EditExpressionXDialog.this.handleEditInList(inlist);
            }
        });
        this.showInList(inlist);
    }

    private void handleAddInList(org.eclipse.swt.widgets.List inlist) {
        SelectParameterDialog d = new SelectParameterDialog(this.rcmp.getShell(), this.designer, (IFilterQuery)this);
        if (d.open() == 0) {
            int index = inlist.getSelectionIndex();
            ParameterPOperand op = new ParameterPOperand(this.value);
            op.setJrParameter(d.getPname());
            if (index >= 0 && index < this.operands.size()) {
                this.operands.add(index + 1, op);
            } else {
                this.operands.add(op);
            }
            this.showInList(inlist);
        }
    }

    private void handleEditInList(org.eclipse.swt.widgets.List inlist) {
        int index = inlist.getSelectionIndex() + 1;
        if (index >= 0 && index < this.operands.size()) {
            ParameterPOperand pop = (ParameterPOperand)this.operands.get(index);
            SelectParameterDialog d = new SelectParameterDialog(this.rcmp.getShell(), this.designer, pop.getJrParameter(), (IFilterQuery)this);
            if (d.open() == 0) {
                pop.setJrParameter(d.getPname());
                this.showInList(inlist);
            }
        }
    }

    private void showInList(org.eclipse.swt.widgets.List inlist) {
        String[] ilarray = new String[Math.max(this.operands.size() - 1, 0)];
        if (!this.operands.isEmpty()) {
            int i = 1;
            while (i < this.operands.size()) {
                ilarray[i - 1] = this.operands.get(i).toXString();
                ++i;
            }
        }
        inlist.setItems(ilarray);
    }

    public String getFilterQuery() {
        return ParameterWidget.getFilterQueryObject(this.operands);
    }

    public String getLanguage() {
        return "sql";
    }
}

