/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.sql.QueryWriter;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.data.sql.validator.TableAliasStringValidator;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.validator.ValidatorUtil;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EditFromTableDialog
extends ATitledDialog {
    private MFromTable mFromTable;
    private String alias;
    private String aliasKeyword;
    private Text talias;
    private Combo keyword;

    public EditFromTableDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.EditFromTableDialog_0);
    }

    public void setValue(MFromTable value) {
        this.mFromTable = value;
        this.setAlias(value.getAlias());
        this.setAliasKeyword(value.getAliasKeyword());
        if (value.getValue() instanceof MQueryTable) {
            this.setTitle(Messages.EditFromTableDialog_2);
        } else {
            this.setTitle(Messages.EditFromTableDialog_0);
        }
    }

    public void setAliasKeyword(String aliasKeyword) {
        this.aliasKeyword = aliasKeyword;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAliasKeyword() {
        return this.aliasKeyword;
    }

    public String getAlias() {
        return this.alias;
    }

    protected Control createDialogArea(Composite parent) {
        Label lbl;
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(3, false));
        if (this.mFromTable.getValue() instanceof MQueryTable) {
            lbl = new Label(cmp, 8);
            UIUtil.setBold((Control)lbl);
            lbl.setText(Messages.EditFromTableDialog_3);
            lbl.setToolTipText(QueryWriter.writeSubQuery((ANode)this.mFromTable));
        } else {
            lbl = new Text(cmp, 2056);
            lbl.setText(ConvertUtil.cleanDbNameFull(((MSqlTable)this.mFromTable.getValue()).toSQLString()));
            lbl.setToolTipText(lbl.getText());
            GridData gd = new GridData(768);
            gd.widthHint = 200;
            lbl.setLayoutData((Object)gd);
        }
        this.keyword = new Combo(cmp, 8);
        this.keyword.setItems(AMKeyword.ALIAS_KEYWORDS);
        this.talias = new Text(cmp, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        gd.horizontalIndent = 8;
        this.talias.setLayoutData((Object)gd);
        return cmp;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        DataBindingContext bindingContext = new DataBindingContext();
        Binding b = bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.talias), PojoProperties.value((String)"alias").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new TableAliasStringValidator(){

            @Override
            public IStatus validate(final Object value) {
                ModelVisitor<Boolean> mv;
                IStatus status = super.validate(value);
                if (status.equals(Status.OK_STATUS) && value != null && !((String)value).isEmpty() && (mv = new ModelVisitor<Boolean>((INode)EditFromTableDialog.this.mFromTable.getRoot()){

                    public boolean visit(INode n) {
                        if (n instanceof MFrom || n instanceof MFromTable) {
                            String al;
                            if (n instanceof MFromTable && n != (this).EditFromTableDialog.this.mFromTable && (al = ((MFromTable)n).getAlias()) != null && al.equals(value)) {
                                this.setObject(Boolean.TRUE);
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                }).getObject() != null && ((Boolean)mv.getObject()).booleanValue()) {
                    return ValidationStatus.error((String)Messages.EditFromTableDialog_1);
                }
                return status;
            }
        }), null);
        bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.keyword), PojoProperties.value((String)"aliasKeyword").observe((Object)this));
        ValidatorUtil.controlDecorator((Binding)b, (Button)this.getButton(0));
        return createButtonBar;
    }
}

