/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FromTableColumnsDialog
extends ATitledDialog {
    private TreeViewer treeViewer;
    private Map<MSQLColumn, MFromTable> cols = new HashMap<MSQLColumn, MFromTable>();
    private MFrom root;
    private int style = 2;
    private MetaDataListener metaDataListener;

    public FromTableColumnsDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.FromTableColumnsDialog_0);
        this.setDefaultSize(650, 780);
    }

    public FromTableColumnsDialog(Shell parentShell, int style) {
        this(parentShell);
        this.style = style;
    }

    public void setSelection(ANode sel) {
        ANode mr = Util.getQueryRoot(sel);
        if (mr == null) {
            mr = sel.getRoot();
        }
        if (mr != null) {
            for (INode n : mr.getChildren()) {
                if (!(n instanceof MFrom)) continue;
                this.root = (MFrom)n;
                break;
            }
        }
    }

    public boolean close() {
        if (this.root != null && this.root.getRoot() != null) {
            this.root.getRoot().getPropertyChangeSupport().removePropertyChangeListener(this.metaDataListener);
        }
        if (this.getReturnCode() == 0) {
            TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
            TreePath[] treePathArray = ts.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath tp = treePathArray[n2];
                if (tp.getSegmentCount() == 2) {
                    this.cols.put((MSQLColumn)tp.getLastSegment(), (MFromTable)tp.getFirstSegment());
                }
                ++n2;
            }
        }
        return super.close();
    }

    public Map<MSQLColumn, MFromTable> getColumns() {
        return this.cols;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        this.treeViewer = new TreeViewer(cmp, this.style | 0x800);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof MFrom) {
                    List<MFromTable> tables = Util.getFromTables((ANode)((MFrom)parentElement));
                    return tables.toArray();
                }
                if (parentElement instanceof MFromTable) {
                    MFromTable mftable = (MFromTable)parentElement;
                    return ((MSqlTable)mftable.getValue()).getChildren().toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider(){

            public Image getImage(Object element) {
                ImageDescriptor imagePath;
                if (element instanceof MFromTable && (imagePath = ((MSqlTable)((MFromTable)element).getValue()).getImagePath()) != null) {
                    return JaspersoftStudioPlugin.getInstance().getImage(imagePath);
                }
                return super.getImage(element);
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof MFromTableJoin) {
                    MFromTableJoin mft = (MFromTableJoin)element;
                    StyledString ss = new StyledString(mft.getValue().toSQLString());
                    mft.addAlias(ss);
                    return ss;
                }
                return super.getStyledText(element);
            }
        });
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)FromTableColumnsDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof MSQLColumn) {
                    FromTableColumnsDialog.this.okPressed();
                } else if (FromTableColumnsDialog.this.treeViewer.getExpandedState(el)) {
                    FromTableColumnsDialog.this.treeViewer.collapseToLevel(el, 1);
                } else {
                    FromTableColumnsDialog.this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection ts = (TreeSelection)FromTableColumnsDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                FromTableColumnsDialog.this.getButton(0).setEnabled(el instanceof MSQLColumn);
            }
        });
        this.treeViewer.setInput((Object)this.root);
        this.metaDataListener = new MetaDataListener();
        if (this.root != null && this.root.getRoot() != null) {
            this.root.getRoot().getPropertyChangeSupport().addPropertyChangeListener(this.metaDataListener);
        }
        this.treeViewer.expandAll();
        return cmp;
    }

    private final class MetaDataListener
    implements PropertyChangeListener {
        private MetaDataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FromTableColumnsDialog.this.treeViewer.refresh(true);
        }
    }
}

