/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.metadata;

import com.jaspersoft.studio.data.sql.model.AMSQLObject;
import com.jaspersoft.studio.data.sql.model.metadata.keys.ForeignKey;
import com.jaspersoft.studio.data.sql.model.metadata.keys.PrimaryKey;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDragable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class MSQLColumn
extends AMSQLObject
implements IDragable {
    public static final long serialVersionUID = 10200L;
    private List<ForeignKey> foreignKeys;
    private PrimaryKey primaryKey;
    private String remarks;
    private String typeName;
    private int columnSize;
    private int precission;
    private int scale;
    private boolean nullable;

    public MSQLColumn(ANode parent, String value, ResultSet rs) {
        super(parent, value, null);
        try {
            if (rs != null) {
                this.typeName = rs.getString("TYPE_NAME");
                this.columnSize = rs.getInt("COLUMN_SIZE");
                this.scale = rs.getInt("DECIMAL_DIGITS");
                this.precission = rs.getInt("NUM_PREC_RADIX");
                this.nullable = rs.getInt("NULLABLE") == 1;
                this.tooltip = this.formatedType();
                this.remarks = rs.getString("REMARKS");
                if (this.remarks != null) {
                    this.tooltip = String.valueOf(this.tooltip) + "\n" + this.remarks;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getToolTip() {
        String tt = ConvertUtil.cleanDbNameFull(super.getToolTip());
        if (this.primaryKey != null) {
            tt = String.valueOf(tt) + "\n" + this.primaryKey.toSqlString();
        }
        if (this.foreignKeys != null) {
            for (ForeignKey fk : this.foreignKeys) {
                tt = String.valueOf(tt) + "\n" + fk.toSqlString();
            }
        }
        return tt;
    }

    @Override
    public ImageDescriptor getImagePath() {
        if (this.primaryKey != null) {
            return JasperReportsPlugin.getDefault().getImageDescriptor("icons/key.png");
        }
        if (this.foreignKeys != null && !this.foreignKeys.isEmpty()) {
            return JasperReportsPlugin.getDefault().getImageDescriptor("icons/key--arrow.png");
        }
        return super.getImagePath();
    }

    public String getUnformattedTypeName() {
        return this.typeName;
    }

    public String getTypeName() {
        return this.formatedType();
    }

    private String formatedType() {
        if (this.typeName == null) {
            return "";
        }
        String tname = "\n" + this.typeName;
        if (this.typeName.equalsIgnoreCase("VARCHAR") || this.typeName.equalsIgnoreCase("CHAR") || this.typeName.equalsIgnoreCase("CHARACTER") || this.typeName.equalsIgnoreCase("NATIONAL CHARACTER") || this.typeName.equalsIgnoreCase("NCHAR") || this.typeName.equalsIgnoreCase("CHARACTER VARYING") || this.typeName.equalsIgnoreCase("NATIONAL CHARACTER VARYING") || this.typeName.equalsIgnoreCase("NVARCHAR") || this.typeName.equalsIgnoreCase("BIT") || this.typeName.equalsIgnoreCase("BIT VARYING") || this.typeName.equalsIgnoreCase(" TEXT") || this.typeName.equalsIgnoreCase("STRING") || this.typeName.equalsIgnoreCase("BINARY") || this.typeName.equalsIgnoreCase("VARBINARY") || this.typeName.equalsIgnoreCase("LONGVARBINARY") || this.typeName.equalsIgnoreCase("NVARCHAR2")) {
            tname = String.valueOf(tname) + "(" + this.columnSize + ")";
        } else if (this.typeName.equalsIgnoreCase("NUMERIC") || this.typeName.equalsIgnoreCase("DECIMAL") || this.typeName.equalsIgnoreCase("NUMBER")) {
            tname = String.valueOf(tname) + "(" + this.precission + ", " + this.scale + ")";
        }
        if (!this.nullable) {
            tname = String.valueOf(tname) + " NOT NULL";
        }
        return tname;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void addForeignKey(ForeignKey fk) {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKey>();
        }
        this.foreignKeys.add(fk);
    }
}

