/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.metadata.keys;

import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import java.io.Serializable;
import net.sf.jasperreports.eclipse.util.Misc;

public class ForeignKey
implements Serializable {
    public static final long serialVersionUID = 10200L;
    private String fkName;
    private MSQLColumn[] srcColumns;
    private MSQLColumn[] destColumns;
    private MSqlTable tbl;
    private String sql;

    public ForeignKey(String fkName, MSqlTable tbl) {
        this.fkName = fkName;
        this.tbl = tbl;
    }

    public void setColumns(MSQLColumn[] srcColumns, MSQLColumn[] destColumns) {
        this.srcColumns = srcColumns;
        this.destColumns = destColumns;
    }

    public String getFkName() {
        return this.fkName;
    }

    public MSQLColumn[] getSrcColumns() {
        return this.srcColumns;
    }

    public MSQLColumn[] getDestColumns() {
        return this.destColumns;
    }

    public boolean equals(Object obj) {
        return this.fkName.equals(obj);
    }

    public int hashCode() {
        return this.fkName.hashCode();
    }

    public MSqlTable getTable() {
        return this.tbl;
    }

    public String toSqlString() {
        if (this.sql == null) {
            int n;
            StringBuffer sb = new StringBuffer("CONSTRAINT ");
            sb.append(Misc.nvl((String)this.fkName));
            sb.append(" FOREIGN KEY (");
            String sep = "";
            if (this.srcColumns != null) {
                MSQLColumn[] mSQLColumnArray = this.srcColumns;
                n = this.srcColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    MSQLColumn c = mSQLColumnArray[n2];
                    sb.append(sep);
                    sep = ", ";
                    sb.append(c.getValue());
                    ++n2;
                }
            }
            sb.append(") REFERENCES ");
            if (this.destColumns != null && this.destColumns.length > 0) {
                MSqlTable destTable = (MSqlTable)this.destColumns[0].getParent();
                sb.append(destTable.toSQLString()).append(" (");
                sep = "";
                MSQLColumn[] mSQLColumnArray = this.destColumns;
                int n3 = this.destColumns.length;
                n = 0;
                while (n < n3) {
                    MSQLColumn c = mSQLColumnArray[n];
                    sb.append(sep);
                    sep = ", ";
                    sb.append(c.getValue());
                    ++n;
                }
            }
            sb.append(")");
            this.sql = sb.toString();
        }
        return this.sql;
    }
}

