/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.expression;

import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import org.eclipse.jface.viewers.StyledString;

public class MExpressionX
extends AMExpression<Object> {
    public static final String[] FUNCTIONS = new String[]{"EQUAL", "NOTEQUAL", "GREATER", "[GREATER", "LESS", "LESS]", "BETWEEN", "[BETWEEN]", "[BETWEEN", "BETWEEN]", "IN", "NOTIN"};
    public static final long serialVersionUID = 10200L;
    private String function = "EQUAL";

    public MExpressionX(ANode parent, Object value, int newIndex) {
        super(parent, value, newIndex);
    }

    @Override
    public String getDisplayText() {
        String dt = "";
        if (!this.isFirst()) {
            if (this.getParent() instanceof MFromTableJoin && this.getParent().getValue() instanceof MQueryTable) {
                MFromTableJoin mftj = (MFromTableJoin)this.getParent();
                dt = String.valueOf(dt) + ") " + mftj.addAlias() + " ON ";
            } else {
                dt = String.valueOf(dt) + this.prevCond + " ";
            }
        }
        dt = String.valueOf(dt) + "$X{" + this.function;
        String sep = ",";
        for (AOperand op : this.operands) {
            if (!op.toXString().contains(",")) continue;
            sep = "|";
            break;
        }
        for (AOperand op : this.operands) {
            dt = String.valueOf(dt) + sep + op.toXString();
        }
        dt = String.valueOf(dt) + "}";
        return String.valueOf(dt) + this.isLastInGroup(this.getParent(), (ANode)this);
    }

    public StyledString getStyledDisplayText() {
        String dt = this.getDisplayText();
        StyledString ss = new StyledString(dt);
        if (!this.isFirst()) {
            StyledString.Styler ks = FontUtils.getKeywordStyler();
            if (this.getParent() instanceof MFromTableJoin && this.getParent().getValue() instanceof MQueryTable) {
                int ind = dt.indexOf(" AS ");
                if (ind >= 0) {
                    ss.setStyle(ind, " AS ".length(), ks);
                }
                if ((ind = dt.indexOf(" ON ")) >= 0) {
                    ss.setStyle(ind, " ON ".length(), ks);
                }
            } else {
                ss.setStyle(0, (String.valueOf(this.prevCond) + " ").length(), ks);
            }
        }
        ss.setStyle(dt.lastIndexOf("$X{"), 3, FontUtils.CLASSTYPE_STYLER);
        ss.setStyle(dt.lastIndexOf("}"), 1, FontUtils.CLASSTYPE_STYLER);
        return ss;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }
}

