/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.text2model;

import com.jaspersoft.studio.data.sql.ColumnFull;
import com.jaspersoft.studio.data.sql.ColumnOperand;
import com.jaspersoft.studio.data.sql.ColumnOrAlias;
import com.jaspersoft.studio.data.sql.Concat;
import com.jaspersoft.studio.data.sql.Division;
import com.jaspersoft.studio.data.sql.ExpOperand;
import com.jaspersoft.studio.data.sql.Minus;
import com.jaspersoft.studio.data.sql.Multiply;
import com.jaspersoft.studio.data.sql.OpFunction;
import com.jaspersoft.studio.data.sql.OpFunctionArg;
import com.jaspersoft.studio.data.sql.OpFunctionArgOperand;
import com.jaspersoft.studio.data.sql.OpFunctionCast;
import com.jaspersoft.studio.data.sql.Operand;
import com.jaspersoft.studio.data.sql.Operands;
import com.jaspersoft.studio.data.sql.OrColumn;
import com.jaspersoft.studio.data.sql.POperand;
import com.jaspersoft.studio.data.sql.Plus;
import com.jaspersoft.studio.data.sql.SQLCaseOperand;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.ScalarOperand;
import com.jaspersoft.studio.data.sql.SqlCaseWhen;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.impl.DbObjectNameImpl;
import com.jaspersoft.studio.data.sql.impl.OperandImpl;
import com.jaspersoft.studio.data.sql.impl.OperandsImpl;
import com.jaspersoft.studio.data.sql.impl.OrColumnImpl;
import com.jaspersoft.studio.data.sql.impl.SelectImpl;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.query.AMQueryAliased;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectSubQuery;
import com.jaspersoft.studio.data.sql.text2model.ConvertExpression;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.data.sql.text2model.Text2Model;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ConvertSelectColumns {
    public static void convertSelectColumns(SQLQueryDesigner designer, ANode qroot, OrColumn cols) {
        if (cols == null) {
            return;
        }
        if (cols instanceof ColumnOrAlias) {
            ConvertSelectColumns.doColumns(designer, qroot, Util.getKeyword(qroot, MSelect.class), (ColumnOrAlias)cols);
        } else if (cols instanceof OrColumnImpl) {
            MSelect msel = Util.getKeyword(qroot, MSelect.class);
            for (ColumnOrAlias fcol : cols.getEntries()) {
                ConvertSelectColumns.doColumns(designer, qroot, msel, fcol);
            }
        }
    }

    private static void doColumns(SQLQueryDesigner designer, ANode qroot, MSelect msel, ColumnOrAlias fcol) {
        try {
            if (fcol.getAllCols() != null) {
                new MSelectExpression((ANode)msel, "*");
            } else if (fcol.getDbAllCols() != null) {
                new MSelectExpression((ANode)msel, String.valueOf(fcol.getDbAllCols().getDbname()) + ".*");
            } else {
                Operands ce = fcol.getCe();
                if (ce != null) {
                    if (ce instanceof OperandImpl) {
                        ConvertSelectColumns.setupAlias(ConvertSelectColumns.getMSelectColumn(designer, qroot, (OperandImpl)ce, msel), fcol);
                    } else if (ce instanceof OperandsImpl) {
                        AMQueryAliased mscol = null;
                        if (ce.getOp1() != null && ce.getLeft() == null && ce.getRight() == null) {
                            mscol = ConvertSelectColumns.getMSelectColumn(designer, qroot, (OperandImpl)ce.getOp1(), msel);
                        } else {
                            mscol = ConvertSelectColumns.getColumnUnknown(msel, "");
                            mscol.setValue(ConvertSelectColumns.operands2String(designer, qroot, (ANode)mscol, ce, msel));
                        }
                        ConvertSelectColumns.setupAlias(mscol, fcol);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String operands2String(SQLQueryDesigner designer, ANode qroot, ANode parent, Operands ops, MSelect msel) {
        String str = "";
        if (ops.getLeft() != null) {
            Operand op = ops.getOp1();
            if (op != null) {
                op = ops.getLeft().getOp1();
                str = String.valueOf(str) + ConvertSelectColumns.operand2String(designer, qroot, parent, op, msel);
            } else if (ops.getLeft() instanceof Operands) {
                str = String.valueOf(str) + ConvertSelectColumns.operands2String(designer, qroot, parent, ops.getLeft(), msel);
            } else {
                ops.getLeft().toString();
            }
        }
        if (ops instanceof Plus) {
            str = String.valueOf(str) + " + ";
        } else if (ops instanceof Minus) {
            str = String.valueOf(str) + " - ";
        } else if (ops instanceof Multiply) {
            str = String.valueOf(str) + " * ";
        } else if (ops instanceof Division) {
            str = String.valueOf(str) + " / ";
        } else if (ops instanceof Concat) {
            str = String.valueOf(str) + " || ";
        }
        if (ops.getRight() != null) {
            str = String.valueOf(str) + ConvertSelectColumns.operand2String(designer, qroot, parent, ops.getRight(), msel);
        }
        if (ops.getOp1() != null) {
            str = String.valueOf(str) + ConvertSelectColumns.operand2String(designer, qroot, parent, ops.getOp1(), msel);
        }
        return str;
    }

    private static AMQueryAliased<?> getMSelectColumn(SQLQueryDesigner designer, ANode qroot, OperandImpl op, MSelect msel) {
        AMQueryAliased mscol = null;
        if (op.getSubq() != null) {
            mscol = new MSelectSubQuery((ANode)msel);
            Util.createSelect((ANode)mscol);
            Text2Model.convertSelect(designer, (ANode)mscol, (SelectImpl)op.getSubq().getSel());
        } else if (op.getColumn() != null) {
            mscol = ConvertSelectColumns.getColumn(msel, op.getColumn().getCfull(), designer);
        } else if (op.getFunc() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, "");
            mscol.setValue(ConvertSelectColumns.getFunctionString(designer, qroot, (ANode)mscol, op.getFunc(), msel));
        } else if (op.getFcast() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, "");
            mscol.setValue(ConvertSelectColumns.getFunctionString(designer, qroot, (ANode)mscol, op.getFcast(), msel));
        } else if (op.getParam() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, op.getParam().getPrm());
        } else if (op.getEparam() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, op.getEparam().getPrm());
        } else if (op.getScalar() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, ConvertSelectColumns.getScalarString(op.getScalar()));
        } else if (op.getSqlcase() != null) {
            mscol = ConvertSelectColumns.getColumnUnknown(msel, "");
            mscol.setValue(ConvertSelectColumns.case2string(designer, qroot, (ANode)mscol, op.getSqlcase(), msel));
        } else if (op.getXop() != null) {
            mscol = ConvertSelectColumns.getMSelectColumn(designer, qroot, (OperandImpl)op.getXop(), msel);
        }
        return mscol;
    }

    protected static String case2string(SQLQueryDesigner designer, ANode qroot, ANode parent, SQLCaseOperand scase, MSelect msel) {
        StringBuilder res = new StringBuilder("CASE ");
        if (scase.getExpr() != null) {
            res.append(" ").append(ConvertExpression.convertExpression2String(designer, qroot, parent, scase.getExpr()));
        }
        if (scase.getWhen() != null) {
            for (EObject eobj : scase.getWhen().eContents()) {
                if (!(eobj instanceof SqlCaseWhen)) continue;
                SqlCaseWhen scasewhen = (SqlCaseWhen)eobj;
                res.append("\nWHEN ");
                if (scasewhen.getExpr() != null) {
                    res.append(" ").append(ConvertExpression.convertExpression2String(designer, qroot, parent, scasewhen.getExpr()));
                }
                if (scasewhen.getTexp() != null) {
                    res.append("THEN ").append(ConvertSelectColumns.operands2String(designer, qroot, parent, scasewhen.getTexp(), msel));
                }
                if (scasewhen.getEexp() == null) continue;
                res.append("ELSE ").append(ConvertSelectColumns.operands2String(designer, qroot, parent, scasewhen.getEexp(), msel));
            }
        }
        parent.removeChildren();
        return res.append("\nEND").toString();
    }

    protected static String operand2String(SQLQueryDesigner designer, ANode qroot, ANode parent, Operand oper, MSelect msel) {
        if (oper != null) {
            if (oper.getColumn() != null) {
                return ConvertSelectColumns.getColumn(oper.getColumn().getCfull(), msel, designer);
            }
            if (oper.getFunc() != null) {
                return ConvertSelectColumns.getFunctionString(designer, qroot, parent, oper.getFunc(), msel);
            }
            if (oper.getFcast() != null) {
                return ConvertSelectColumns.getFunctionString(designer, qroot, parent, oper.getFcast(), msel);
            }
            if (oper.getParam() != null) {
                return oper.getParam().getPrm();
            }
            if (oper.getEparam() != null) {
                return oper.getEparam().getPrm();
            }
            if (oper.getScalar() != null) {
                return ConvertSelectColumns.getScalarString(oper.getScalar());
            }
            if (oper.getSqlcase() != null) {
                return ConvertSelectColumns.case2string(designer, qroot, parent, oper.getSqlcase(), msel);
            }
            if (oper.getXop() != null) {
                return ConvertSelectColumns.operand2String(designer, qroot, parent, oper.getXop(), msel);
            }
        }
        return "";
    }

    public static String getFunctionString(SQLQueryDesigner designer, ANode qroot, ANode parent, OpFunction f, MSelect msel) {
        StringBuilder sargs = new StringBuilder(" ");
        OpFunctionArg args = f.getArgs();
        if (f.getStar() != null) {
            sargs = new StringBuilder("*");
        } else if (args != null) {
            String sep = "";
            for (EObject eobj : args.eContents()) {
                sargs.append(sep);
                if (eobj instanceof OpFunctionArgOperand) {
                    eobj = ((OpFunctionArgOperand)eobj).getOp();
                }
                if (eobj instanceof OperandImpl) {
                    sargs.append(ConvertSelectColumns.operand2String(designer, qroot, parent, (Operand)((OperandImpl)eobj), msel));
                } else if (eobj instanceof ColumnOperand) {
                    sargs.append(ConvertSelectColumns.getColumn(((ColumnOperand)eobj).getCfull(), msel, designer));
                } else if (eobj instanceof POperand) {
                    sargs.append(((POperand)eobj).getPrm());
                } else if (eobj instanceof ExpOperand) {
                    sargs.append(((ExpOperand)eobj).getPrm());
                } else if (eobj instanceof ScalarOperand) {
                    sargs.append(eobj.toString());
                } else if (eobj instanceof Operands) {
                    sargs.append(ConvertSelectColumns.operands2String(designer, qroot, parent, (Operands)eobj, msel));
                }
                sep = ",";
            }
        }
        return String.valueOf(f.getFname()) + sargs.toString() + ")";
    }

    public static String getFunctionString(SQLQueryDesigner designer, ANode qroot, ANode parent, OpFunctionCast f, MSelect msel) {
        String sargs = "";
        Operands eobj = f.getOp();
        if (eobj instanceof OperandImpl) {
            sargs = String.valueOf(sargs) + ConvertSelectColumns.operand2String(designer, qroot, parent, (Operand)((OperandImpl)eobj), msel);
        } else if (eobj instanceof ColumnOperand) {
            sargs = String.valueOf(sargs) + ConvertSelectColumns.getColumn(((ColumnOperand)eobj).getCfull(), msel, designer);
        } else if (eobj instanceof POperand) {
            sargs = String.valueOf(sargs) + ((POperand)eobj).getPrm();
        } else if (eobj instanceof ExpOperand) {
            sargs = String.valueOf(sargs) + ((ExpOperand)eobj).getPrm();
        } else if (eobj instanceof ScalarOperand) {
            sargs = String.valueOf(sargs) + eobj.toString();
        } else if (eobj instanceof Operands) {
            sargs = String.valueOf(sargs) + ConvertSelectColumns.operands2String(designer, qroot, parent, eobj, msel);
        }
        if (f.getType() != null) {
            sargs = String.valueOf(sargs) + " AS " + f.getType();
        }
        if (f.getP() > 0L) {
            sargs = String.valueOf(sargs) + "(" + f.getP();
            if (f.getP2() > 0L) {
                sargs = String.valueOf(sargs) + "," + f.getP2();
            }
            sargs = String.valueOf(sargs) + ")";
        }
        return "CAST(" + sargs + ")";
    }

    private static String getScalarString(ScalarOperand sc) {
        if (sc.getSodate() != null) {
            return sc.getSodate();
        }
        if (sc.getSodbl() != null) {
            return sc.getSodbl().toString();
        }
        if (sc.getSodt() != null) {
            return sc.getSodt();
        }
        if (sc.getSostr() != null) {
            return sc.getSostr();
        }
        if (sc.getSotime() != null) {
            return sc.getSotime();
        }
        if (sc.getSodbl() != null) {
            return sc.getSodbl().toString();
        }
        if (sc.getSoUInt() != null) {
            return sc.getSoUInt().toString();
        }
        if (sc.getSoint() != null) {
            return sc.getSoint().toString();
        }
        return "";
    }

    private static void setupAlias(AMQueryAliased<?> mscol, ColumnOrAlias fcol) {
        if (mscol == null) {
            return;
        }
        mscol.setAliasKeyword(Misc.nvl((Object)fcol.getAlias(), (String)" "));
        if (fcol.getColAlias() != null) {
            mscol.setAlias(fcol.getColAlias().getDbname());
        }
    }

    private static String getColumn(ColumnFull tf, MSelect msel, SQLQueryDesigner designer) {
        EList eContents = tf.eContents();
        String column = null;
        column = tf instanceof DbObjectNameImpl ? ((DbObjectNameImpl)tf).getDbname() : ConvertUtil.getDbObjectName((EList<EObject>)eContents, 1);
        String table = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 2);
        String schema = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 3);
        ConvertUtil.findColumn(msel, schema, table, column, designer);
        if (table != null) {
            column = String.valueOf(table) + "." + column;
        }
        if (schema != null) {
            column = String.valueOf(schema) + "." + column;
        }
        return column;
    }

    private static AMQueryAliased<?> getColumn(MSelect msel, ColumnFull tf, SQLQueryDesigner designer) {
        EList eContents = tf.eContents();
        String column = null;
        column = tf instanceof DbObjectNameImpl ? ((DbObjectNameImpl)tf).getDbname() : ConvertUtil.getDbObjectName((EList<EObject>)eContents, 1);
        String table = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 2);
        String schema = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 3);
        MSelectColumn msqlt = ConvertSelectColumns.findColumn(msel, schema, table, column, designer);
        if (msqlt == null) {
            return ConvertSelectColumns.getColumnUnknown(msel, column);
        }
        return msqlt;
    }

    private static MSelectExpression getColumnUnknown(MSelect msel, String column) {
        return new MSelectExpression((ANode)msel, column);
    }

    private static MSelectColumn findColumn(MSelect msel, String schema, String table, String column, SQLQueryDesigner designer) {
        KeyValue<MSQLColumn, MFromTable> kv = ConvertUtil.findColumn(msel, schema, table, column, designer);
        if (kv != null) {
            return new MSelectColumn((ANode)msel, (MSQLColumn)kv.key, (MFromTable)kv.value);
        }
        return null;
    }
}

