/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.action.ActionFactory;
import com.jaspersoft.studio.data.sql.action.DeleteAction;
import com.jaspersoft.studio.data.sql.action.expression.ChangeOperator;
import com.jaspersoft.studio.data.sql.action.expression.CreateExpression;
import com.jaspersoft.studio.data.sql.action.expression.EditExpression;
import com.jaspersoft.studio.data.sql.action.expression.NotExpressionGroup;
import com.jaspersoft.studio.data.sql.action.groupby.CreateGroupByColumn;
import com.jaspersoft.studio.data.sql.action.order.CreateOrderByColumn;
import com.jaspersoft.studio.data.sql.action.order.OrderByDesc;
import com.jaspersoft.studio.data.sql.action.select.CreateColumn;
import com.jaspersoft.studio.data.sql.action.select.EditColumn;
import com.jaspersoft.studio.data.sql.action.select.SelectDistinct;
import com.jaspersoft.studio.data.sql.action.table.CreateTable;
import com.jaspersoft.studio.data.sql.action.table.EditTable;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.MHaving;
import com.jaspersoft.studio.data.sql.model.query.MUnion;
import com.jaspersoft.studio.data.sql.model.query.MWhere;
import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpressionGroup;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupBy;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByColumn;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByExpression;
import com.jaspersoft.studio.data.sql.model.query.orderby.AMOrderByMember;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderBy;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderByColumn;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderByExpression;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.dnd.NodeTreeDropAdapter;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PluginTransfer;

public class SQLQueryOutline {
    private SQLQueryDesigner designer;
    private boolean isRefresh = false;
    private TreeViewer treeViewer;
    private ActionFactory afactory;

    public SQLQueryOutline(SQLQueryDesigner designer) {
        this.designer = designer;
    }

    public Control createOutline(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2050){

            public void refresh(boolean updateLabels) {
                if (SQLQueryOutline.this.isRefresh) {
                    super.refresh(updateLabels);
                    return;
                }
                SQLQueryOutline.this.isRefresh = true;
                super.refresh(updateLabels);
                SQLQueryOutline.this.designer.refreshQuery();
                SQLQueryOutline.this.isRefresh = false;
            }
        };
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider());
        this.treeViewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        this.afactory = new ActionFactory(this.designer, this.treeViewer);
        menuMgr.addMenuListener(mgr -> {
            TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
            this.afactory.fillMenu(s != null ? s.toArray() : null, mgr);
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{NodeTransfer.getInstance(), PluginTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new NodeDragListener((StructuredViewer)this.treeViewer){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object fe = selection.getFirstElement();
                event.doit = !this.viewer.getSelection().isEmpty() && this.isDragable(fe);
            }

            public boolean isDragable(Object fe) {
                return !(fe instanceof MSelect) && !(fe instanceof MFrom) && !(fe instanceof MGroupBy) && !(fe instanceof MHaving) && !(fe instanceof MWhere) && !(fe instanceof MOrderBy) && !(fe instanceof MUnion);
            }
        });
        transfers = new Transfer[]{NodeTransfer.getInstance(), TemplateTransfer.getInstance(), PluginTransfer.getInstance()};
        NodeTreeDropAdapter dropAdapter = new NodeTreeDropAdapter(this.treeViewer){

            public boolean validateDrop(Object target, int op, TransferData type) {
                return super.validateDrop(target, op, type) || TemplateTransfer.getInstance().isSupportedType(type);
            }

            public boolean performDrop(Object data) {
                if (data == null) {
                    return false;
                }
                ArrayList<ANode> nodes = new ArrayList<ANode>();
                ArrayList<Object> objects = new ArrayList<Object>();
                if (data.getClass().isArray()) {
                    Object[] ar;
                    Object[] objectArray = ar = (Object[])data;
                    int n = ar.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof ANode) {
                            nodes.add((ANode)obj);
                        } else {
                            objects.add(obj);
                        }
                        ++n2;
                    }
                } else if (data instanceof ANode) {
                    nodes.add((ANode)data);
                } else {
                    objects.add(data);
                }
                Object target = this.getCurrentTarget();
                if (target instanceof ANode && ((ANode)target).getParent() == null) {
                    return false;
                }
                if (target instanceof MFromTableJoin && !((MFromTableJoin)target).getJoinKey().equals("ON")) {
                    return false;
                }
                this.doDropObjects((ANode)target, objects);
                return this.doDrop((ANode)target, Util.getAllNodes(data));
            }

            private void doDropObjects(ANode target, List<Object> objects) {
                ArrayList<JRDesignParameter> prms = new ArrayList<JRDesignParameter>();
                for (Object obj : objects) {
                    if (!(obj instanceof JRDesignParameter)) continue;
                    prms.add((JRDesignParameter)obj);
                }
                if (!prms.isEmpty()) {
                    CreateExpression ce = SQLQueryOutline.this.afactory.getAction(CreateExpression.class);
                    if (ce.calculateEnabled(new Object[]{target})) {
                        ce.run((List<JRDesignParameter>)prms);
                    }
                }
            }

            private boolean doDrop(ANode target, List<ANode> node) {
                LinkedHashSet<MSqlTable> tablesset = new LinkedHashSet<MSqlTable>();
                LinkedHashSet<MSQLColumn> colsset = new LinkedHashSet<MSQLColumn>();
                LinkedHashSet<ANode> others = new LinkedHashSet<ANode>();
                Util.filterTables(node, tablesset, colsset, others);
                this.doDropTable(target, tablesset);
                this.doDropColumn(target, colsset);
                if (!others.isEmpty()) {
                    for (ANode n : others) {
                        ANode p;
                        ANode oldNode = Util.getOldNode(target, n);
                        if ((target instanceof MExpressionGroup || target instanceof MWhere || target instanceof MHaving || target instanceof MFromTableJoin) && (n instanceof MExpression || n instanceof MExpressionGroup)) {
                            oldNode.setParent(null, -1);
                            oldNode.setParent(target, -1);
                            SQLQueryOutline.this.refreshAndReveal(oldNode);
                            continue;
                        }
                        if (target instanceof AMExpression && (n instanceof AMExpression || n instanceof MExpressionGroup)) {
                            oldNode.setParent(null, -1);
                            AMExpression mexpr = (AMExpression)target;
                            p = mexpr.getParent();
                            oldNode.setParent(p, p.getChildren().indexOf(mexpr));
                            SQLQueryOutline.this.refreshAndReveal(oldNode);
                            continue;
                        }
                        if (n instanceof MSelectColumn || n instanceof MSelectExpression) {
                            int ind = -1;
                            boolean cfr_ignored_0 = target instanceof MWhere;
                            if (target instanceof MGroupByColumn || target instanceof MGroupByExpression) {
                                p = target.getParent();
                                ind = p.getChildren().indexOf(target);
                                target = p;
                            }
                            if (target instanceof MGroupBy) {
                                if (n instanceof MSelectExpression) {
                                    SQLQueryOutline.this.refreshAndReveal((ANode)new MGroupByExpression((ANode)((MGroupBy)target), (MSelectExpression)n, ind));
                                    continue;
                                }
                                if (!(n instanceof MSelectColumn)) continue;
                                SQLQueryOutline.this.refreshAndReveal((ANode)new MGroupByColumn((ANode)((MGroupBy)target), (MSelectColumn)n, ind));
                                continue;
                            }
                            boolean cfr_ignored_1 = target instanceof MHaving;
                            if (target instanceof AMOrderByMember) {
                                p = ((AMOrderByMember)target).getParent();
                                ind = p.getChildren().indexOf(target);
                                target = p;
                            }
                            if (target instanceof MOrderBy) {
                                if (n instanceof MSelectExpression) {
                                    SQLQueryOutline.this.refreshAndReveal((ANode)new MOrderByExpression((ANode)((MOrderBy)target), (MSelectExpression)n, ind));
                                    continue;
                                }
                                SQLQueryOutline.this.refreshAndReveal((ANode)new MOrderByColumn((ANode)((MOrderBy)target), (MSelectColumn)n, ind));
                                continue;
                            }
                        }
                        this.reorder(target, n);
                    }
                }
                return false;
            }

            private void reorder(Object target, ANode n) {
                int ind;
                ANode parent = null;
                if (target instanceof AMKeyword) {
                    parent = (ANode)target;
                } else if (target.getClass().isAssignableFrom(n.getClass())) {
                    parent = ((ANode)target).getParent();
                } else if (target instanceof ANode && n instanceof ANode && ((ANode)target).getParent() != null && ((ANode)target).getParent().equals(n.getParent())) {
                    parent = ((ANode)target).getParent();
                }
                if (n.getParent().equals(parent) && (ind = parent.getChildren().indexOf(n)) >= 0 && ind < parent.getChildren().size()) {
                    n = (ANode)parent.getChildren().get(ind);
                    int pos = 0;
                    if (target != parent) {
                        pos = parent.getChildren().indexOf(target);
                    }
                    parent.removeChild(n);
                    parent.addChild(n, pos);
                    SQLQueryOutline.this.refreshAndReveal(n);
                }
            }

            protected void doDropTable(Object target, Set<MSqlTable> tablesset) {
                if (!tablesset.isEmpty()) {
                    LinkedHashSet<MSqlTable> tmp = new LinkedHashSet<MSqlTable>();
                    for (MSqlTable t : tablesset) {
                        MSqlTable mt = Util.getTable(SQLQueryOutline.this.designer.getDbMetadata().getRoot(), t);
                        SQLQueryOutline.this.designer.getDbMetadata().loadTable(mt);
                        tmp.add(mt);
                    }
                    tablesset.clear();
                    tablesset.addAll(tmp);
                    for (MSqlTable t : tablesset) {
                        SQLQueryOutline.this.designer.getDbMetadata().loadTable(t);
                    }
                    if (target instanceof MSelect || target instanceof MSelectColumn || target instanceof MSelectExpression) {
                        HashSet<MSQLColumn> cols = new HashSet<MSQLColumn>();
                        for (MSqlTable t : tablesset) {
                            for (INode n : t.getChildren()) {
                                cols.add((MSQLColumn)n);
                            }
                        }
                        this.doDropColumn(target, cols);
                        return;
                    }
                    CreateTable ct = SQLQueryOutline.this.afactory.getAction(CreateTable.class);
                    if (ct.calculateEnabled(new Object[]{target})) {
                        ct.run(tablesset);
                    }
                }
            }

            protected void doDropColumn(Object target, Set<MSQLColumn> colsset) {
                if (!colsset.isEmpty()) {
                    CreateColumn ct = SQLQueryOutline.this.afactory.getAction(CreateColumn.class);
                    ct.setCheckTables(false);
                    if (ct.calculateEnabled(new Object[]{target})) {
                        ct.run(colsset);
                    }
                    CreateGroupByColumn cg = SQLQueryOutline.this.afactory.getAction(CreateGroupByColumn.class);
                    if (cg.calculateEnabled(new Object[]{target})) {
                        cg.run(colsset);
                    }
                    CreateOrderByColumn co = SQLQueryOutline.this.afactory.getAction(CreateOrderByColumn.class);
                    if (co.calculateEnabled(new Object[]{target})) {
                        co.run(colsset);
                    }
                    CreateExpression ce = SQLQueryOutline.this.afactory.getAction(CreateExpression.class);
                    if (ce.calculateEnabled(new Object[]{target})) {
                        ce.run(colsset);
                    }
                }
            }
        };
        this.treeViewer.addDropSupport(ops, transfers, (DropTargetListener)dropAdapter);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(SelectDistinct.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(NotExpressionGroup.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(OrderByDesc.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(ChangeOperator.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(EditColumn.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(EditTable.class));
                this.runAction(event, SQLQueryOutline.this.afactory.getAction(EditExpression.class));
            }

            private void runAction(DoubleClickEvent event, AAction sd) {
                if (sd.calculateEnabled(event.getSelection())) {
                    sd.run();
                }
            }
        });
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                TreeSelection s;
                List<DeleteAction<?>> dactions;
                Iterator<DeleteAction<?>> iterator;
                if ((event.character == '\u007f' && event.stateMask == 0 || event.keyCode == 8) && (iterator = (dactions = SQLQueryOutline.this.afactory.getDeleteActions((s = (TreeSelection)SQLQueryOutline.this.treeViewer.getSelection()) != null ? s.toArray() : null)).iterator()).hasNext()) {
                    DeleteAction<?> da = iterator.next();
                    da.run();
                }
            }
        });
        this.refreshViewer();
        return this.treeViewer.getControl();
    }

    protected void refreshViewer() {
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.treeViewer.getTree().isDisposed()) {
                return;
            }
            this.treeViewer.setInput((Object)this.designer.getRoot());
            this.treeViewer.expandToLevel(1);
        });
    }

    public ActionFactory getAfactory() {
        return this.afactory;
    }

    public void scheduleRefresh() {
        if (this.isRefresh) {
            return;
        }
        this.isRefresh = true;
        if (this.designer.getRoot() != null) {
            this.designer.getRoot().setValue(this.designer.getjDataset());
        }
        this.treeViewer.refresh(true);
        this.isRefresh = false;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void dispose() {
    }

    protected void refreshAndReveal(ANode toselect) {
        this.treeViewer.refresh(true);
        this.treeViewer.reveal((Object)toselect);
    }
}

