/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.parts;

import com.jaspersoft.studio.data.sql.QueryWriter;
import com.jaspersoft.studio.data.sql.model.ISubQuery;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.MUnion;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.ui.gef.command.SetSilentValuesCommand;
import com.jaspersoft.studio.data.sql.ui.gef.layout.GraphLayoutManager;
import com.jaspersoft.studio.data.sql.ui.gef.parts.TableEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.policy.FromContainerEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.NoSelectionEditPolicy;
import com.jaspersoft.studio.model.AMapElement;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wb.swt.SWTResourceManager;

public class FromEditPart
extends AbstractGraphicalEditPart {
    public static final Insets INSETS = new Insets(10, 10, 10, 10);
    private Point pmin;
    private boolean layout = true;
    private boolean isRunning = false;
    private XYLayout xyLayout = new XYLayout();
    private GraphLayoutManager grLayout = new GraphLayoutManager(this);

    protected IFigure createFigure() {
        FromFigure fig = new FromFigure();
        fig.setLayoutManager((LayoutManager)this.xyLayout);
        fig.setBackgroundColor(SWTResourceManager.getColor((int)248, (int)248, (int)255));
        fig.setOpaque(true);
        return fig;
    }

    public MFrom getModel() {
        return (MFrom)super.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new FromContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){
            private RoundedRectangle targetFeedback;

            protected void showLayoutTargetFeedback(Request request) {
                if (this.targetFeedback == null) {
                    this.targetFeedback = new RoundedRectangle();
                    this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    this.getFeedbackLayer().translateToRelative((Translatable)rect);
                    this.targetFeedback.setBounds(rect.shrink(1, 1));
                    this.targetFeedback.setBorder((Border)new LineBorder(ColorConstants.lightBlue, 2));
                    this.addFeedback((IFigure)this.targetFeedback);
                }
            }

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (this.targetFeedback != null) {
                    this.removeFeedback((IFigure)this.targetFeedback);
                    this.targetFeedback = null;
                }
            }

            protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
                Rectangle b = this.getHostFigure().getBounds();
                Rectangle r = (Rectangle)constraint;
                if (b.x + r.x + FromEditPart.INSETS.left < FromEditPart.INSETS.left) {
                    return null;
                }
                if (b.y + r.y + FromEditPart.INSETS.top < FromEditPart.INSETS.top) {
                    return null;
                }
                Point delta = request.getMoveDelta();
                if (child instanceof TableEditPart) {
                    SetValueCommand cmd = new SetValueCommand();
                    cmd.setPropertyId((Object)"x");
                    cmd.setPropertyValue((Object)new Point(b.x + r.x + FromEditPart.INSETS.left, b.y + r.y + FromEditPart.INSETS.top));
                    cmd.setTarget((IPropertySource)((TableEditPart)child).getModel());
                    return cmd;
                }
                if (child instanceof FromEditPart) {
                    FromEditPart fep = (FromEditPart)child;
                    CompoundCommand c = new CompoundCommand("Moving Tables");
                    List children = child.getChildren();
                    FromEditPart.moveTables(c, children, fep, delta);
                    return c;
                }
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof TableEditPart || child instanceof FromEditPart) {
                    return new NoSelectionEditPolicy(){

                        protected IFigure createDragSourceFeedbackFigure() {
                            return super.createDragSourceFeedbackFigure();
                        }

                        protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                            super.showChangeBoundsFeedback(request);
                        }
                    };
                }
                return super.createChildEditPolicy(child);
            }

            protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
                return this.createChangeConstraintCommand(null, child, constraint);
            }
        });
    }

    public static void moveTables(CompoundCommand c, List<? extends EditPart> children, FromEditPart fep, Point delta) {
        if (children.isEmpty()) {
            Point point = fep.readPoint((APropertyNode)fep.getModel());
            if (point == null) {
                return;
            }
            Point point2 = new Point(delta.x + point.x, delta.y + point.y);
            SetValueCommand cmd = new SetValueCommand();
            cmd.setPropertyId((Object)"x");
            cmd.setPropertyValue((Object)point2);
            cmd.setTarget((IPropertySource)fep.getModel());
            c.add((Command)cmd);
        } else {
            for (EditPart editPart : children) {
                MFromTable pn = null;
                if (editPart instanceof TableEditPart) {
                    pn = ((TableEditPart)editPart).getModel();
                } else if (editPart instanceof FromEditPart) {
                    FromEditPart.moveTables(c, editPart.getChildren(), (FromEditPart)editPart, delta);
                    continue;
                }
                if (pn == null) continue;
                Point p = fep.readPoint((APropertyNode)pn);
                if (p == null) {
                    return;
                }
                p = new Point(delta.x + p.x, delta.y + p.y);
                SetValueCommand cmd = new SetValueCommand();
                cmd.setPropertyId((Object)"x");
                cmd.setPropertyValue((Object)p);
                cmd.setTarget((IPropertySource)pn);
                c.add((Command)cmd);
            }
        }
    }

    protected List<?> getModelChildren() {
        final ArrayList list = new ArrayList();
        final MFrom mfrom = this.getModel();
        new ModelVisitor<ANode>((INode)mfrom){

            public boolean visit(INode n) {
                if (list.contains(n)) {
                    return false;
                }
                if (n instanceof MUnion || n instanceof ISubQuery) {
                    return false;
                }
                if (n instanceof MFromTable) {
                    if (n.getValue() instanceof MQueryTable) {
                        List<MFrom> lst = FromEditPart.this.getFrom((ANode)n, (ANode)mfrom);
                        if (!lst.isEmpty()) {
                            list.addAll(lst);
                        }
                    } else {
                        String name;
                        if (n.getValue() instanceof MSqlTable && (name = this.getTblName((MFromTable)n)) != null) {
                            boolean exists = false;
                            for (ANode en : list) {
                                if (!(en instanceof MFromTable)) continue;
                                String ename = this.getTblName((MFromTable)en);
                                if (en == null || !name.equals(ename)) continue;
                                exists = true;
                                break;
                            }
                            if (exists) {
                                return true;
                            }
                        }
                        list.add((ANode)n);
                    }
                }
                return true;
            }

            private String getTblName(MFromTable n) {
                if (n.getValue() instanceof MSqlTable) {
                    MSqlTable tbl = (MSqlTable)n.getValue();
                    return String.valueOf(tbl.getValue()) + " AS " + n.getAlias();
                }
                return null;
            }
        };
        return list;
    }

    private List<MFrom> getFrom(ANode n, final ANode ignore) {
        final ArrayList<MFrom> list = new ArrayList<MFrom>();
        new ModelVisitor<MFrom>((INode)n){

            public boolean visit(INode n) {
                if (n instanceof MFrom && n != ignore) {
                    list.add((MFrom)n);
                    return false;
                }
                return true;
            }
        };
        return list;
    }

    protected void refreshVisuals() {
        RoundedRectangle f = (RoundedRectangle)this.getFigure();
        MFrom mfrom = this.getModel();
        f.setToolTip((IFigure)new Label(QueryWriter.writeSubQuery(mfrom.getParent())));
    }

    public void refresh() {
        this.refreshChildren();
        List<?> children = this.getModelChildren();
        AbstractGraphicalEditPart parent = (AbstractGraphicalEditPart)this.getParent();
        Point p = this.getMinPoint(children);
        if (children.isEmpty()) {
            if (parent instanceof FromEditPart) {
                if (p == null) {
                    this.setupLayoutManager();
                    p = new Point(20, 20);
                    Point pmin = ((FromEditPart)parent).getMinPoint(children);
                    if (pmin != null) {
                        p.translate(pmin);
                        MFrom m = this.getModel();
                        SetSilentValuesCommand c = new SetSilentValuesCommand(false);
                        c.add(m, "x", p.x);
                        c.add(m, "y", p.y);
                        this.getViewer().getEditDomain().getCommandStack().execute((Command)c);
                    }
                }
                this.setupPoint(p, (FromEditPart)parent, ((FromEditPart)parent).getModelChildren());
            }
        } else {
            this.setupLayoutManager();
            if (parent instanceof FromEditPart) {
                this.setupPoint(p, (FromEditPart)parent, ((FromEditPart)parent).getModelChildren());
            }
        }
        if (p != null) {
            Rectangle r = new Rectangle(p.x, p.y, -1, -1);
            parent.setLayoutConstraint((EditPart)this, this.figure, (Object)r);
        }
        this.refreshVisuals();
    }

    private void setupPoint(Point p, FromEditPart fep, List<?> children) {
        if (p == null) {
            return;
        }
        Point pmin = fep.getMinPoint(children);
        if (pmin != null) {
            int count = this.getFromLevel();
            p.translate(pmin.getNegated());
            p.translate(-FromEditPart.INSETS.left * count, -FromEditPart.INSETS.top * count);
        }
    }

    public int getFromLevel() {
        int count = 1;
        EditPart eparent = this.getParent();
        while (eparent != null && eparent instanceof FromEditPart) {
            ++count;
            eparent = eparent.getParent();
        }
        return count - 2;
    }

    public Point getMinPoint() {
        if (this.pmin == null) {
            this.pmin = this.getMinPoint(this.getModelChildren());
        }
        return this.pmin;
    }

    public Point getMinPoint(List<?> childs) {
        Point pmin = null;
        if (childs.isEmpty()) {
            pmin = this.readPoint((APropertyNode)this.getModel());
        } else {
            for (Object item : childs) {
                if (!(item instanceof APropertyNode)) continue;
                Point p = null;
                p = item instanceof MFrom ? this.getMinPoint(((MFrom)item).getChildren()) : this.readPoint((APropertyNode)item);
                if (p == null) continue;
                if (pmin == null) {
                    pmin = new Point(p.x, p.y);
                    continue;
                }
                pmin.x = Math.min(pmin.x, p.x);
                pmin.y = Math.min(pmin.y, p.y);
            }
        }
        if (pmin != null) {
            return new Point(pmin.x - FromEditPart.INSETS.left, pmin.y - FromEditPart.INSETS.top);
        }
        return null;
    }

    public Point readPoint(APropertyNode item) {
        Integer x = null;
        Integer y = null;
        Object pv = item.getPropertyValue((Object)"x");
        if (pv != null && pv instanceof Integer) {
            x = (Integer)pv;
        } else {
            if (pv != null && pv instanceof Point) {
                return null;
            }
            if (!(item instanceof MFrom) || item instanceof MFrom && item.getChildren().isEmpty()) {
                this.layout = false;
            }
        }
        pv = item.getPropertyValue((Object)"y");
        if (pv != null && pv instanceof Integer) {
            y = (Integer)pv;
        }
        if (x != null && y != null) {
            return new Point(x.intValue(), y.intValue());
        }
        return null;
    }

    protected void setupLayoutManager() {
        if (this.layout) {
            return;
        }
        this.layout = true;
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        if (((Boolean)Misc.nvl((Object)((Boolean)new ModelVisitor<Boolean>((INode)this.getModel()){

            public boolean visit(INode n) {
                if (n instanceof MFromTable && !(n.getValue() instanceof MQueryTable) && ((AMapElement)n).getPropertyActualValue((Object)"x") == null) {
                    this.setObject(Boolean.FALSE);
                    this.stop();
                }
                return false;
            }
        }.getObject()), (Object)Boolean.FALSE)).booleanValue()) {
            this.figure.setLayoutManager((LayoutManager)this.xyLayout);
            this.isRunning = false;
        } else {
            this.figure.setLayoutManager((LayoutManager)this.grLayout);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                private void addToMap(Object aep, Map<AMapElement, Rectangle> map) {
                    if (aep instanceof TableEditPart) {
                        TableEditPart t = (TableEditPart)((Object)aep);
                        Rectangle b = t.getFigure().getBounds();
                        map.put(t.getModel(), b);
                    } else if (aep instanceof FromEditPart) {
                        FromEditPart f = (FromEditPart)((Object)aep);
                        if (f.getModel().getChildren().isEmpty()) {
                            Rectangle b = f.getFigure().getBounds();
                            map.put(f.getModel(), b);
                        } else {
                            for (Object obj : f.getChildren()) {
                                this.addToMap(obj, map);
                            }
                        }
                    }
                }

                @Override
                public void run() {
                    HashMap<AMapElement, Rectangle> map = new HashMap<AMapElement, Rectangle>();
                    for (Object p : FromEditPart.this.getChildren()) {
                        this.addToMap(p, map);
                    }
                    SetSilentValuesCommand c = new SetSilentValuesCommand(true);
                    for (AMapElement key : map.keySet()) {
                        if (key instanceof MFrom && !key.getChildren().isEmpty()) {
                            c.add(key, "x", null);
                            c.add(key, "y", null);
                            continue;
                        }
                        Rectangle b = (Rectangle)map.get(key);
                        c.add(key, "x", b.x);
                        c.add(key, "y", b.y);
                    }
                    FromEditPart.this.figure.setLayoutManager((LayoutManager)FromEditPart.this.xyLayout);
                    FromEditPart.this.layout = true;
                    if (FromEditPart.this.getViewer() != null) {
                        FromEditPart.this.getViewer().getEditDomain().getCommandStack().execute((Command)c);
                    }
                    FromEditPart.this.isRunning = false;
                }
            });
        }
    }

    class FromFigure
    extends RoundedRectangle {
        FromFigure() {
        }

        public Insets getInsets() {
            return INSETS;
        }

        public void setBounds(Rectangle rect) {
            if (Math.abs(rect.x) > 10000 || Math.abs(rect.y) > 10000) {
                return;
            }
            super.setBounds(rect);
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            return new Dimension(INSETS.getWidth(), INSETS.getHeight());
        }

        public IFigure getToolTip() {
            IFigure t = super.getToolTip();
            if (t instanceof Label) {
                Label l = (Label)t;
                MFrom mdl = FromEditPart.this.getModel();
                l.setText(mdl.getDisplayText());
            }
            return t;
        }
    }
}

