/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.parts;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.action.table.EditTableJoin;
import com.jaspersoft.studio.data.sql.model.query.IQueryString;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoin;
import com.jaspersoft.studio.data.sql.ui.gef.parts.RelationshipDetailPart;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

public class RelationshipPart
extends AbstractConnectionEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    public TableJoin getModel() {
        return (TableJoin)super.getModel();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            SQLQueryDesigner designer = (SQLQueryDesigner)((Object)this.getViewer().getProperty("SQLQUERYDIAGRAM"));
            EditTableJoin ct = designer.getOutline().getAfactory().getAction(EditTableJoin.class);
            if (ct.calculateEnabled(new Object[]{this.getModel().getJoinTable()})) {
                ct.run();
            }
        }
    }

    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        conn.setForegroundColor(UIUtils.getSystemColor((int)2));
        conn.setBackgroundColor(UIUtils.getSystemColor((int)2));
        return conn;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        MFromTableJoin joinTable = this.getModel().getJoinTable();
        final StringBuffer tt = new StringBuffer();
        tt.append(this.getModel().getFromTable().getToolTip()).append(" ").append(joinTable.getToolTip());
        new ModelVisitor<Object>((INode)joinTable){

            public boolean visit(INode n) {
                if (n instanceof IQueryString) {
                    tt.append(((IQueryString)n).toSQLString());
                }
                return true;
            }
        };
        PolylineConnection f = (PolylineConnection)this.getFigure();
        f.setToolTip((IFigure)new Label(tt.toString()));
        if (joinTable.getJoin().equals("INNER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getInnerDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getInnerDecoration());
        } else if (joinTable.getJoin().equals("LEFT OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getOuterDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getInnerDecoration());
        } else if (joinTable.getJoin().equals("RIGHT OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getInnerDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getOuterDecoration());
        } else if (joinTable.getJoin().equals("FULL OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getOuterDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getOuterDecoration());
        } else if (joinTable.getJoin().equals("CROSS JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getCrossDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getCrossDecoration());
        }
    }
}

