/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.metadata;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.metadata.INotInMetadata;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.ui.metadata.MetaDataUtil;
import com.jaspersoft.studio.data.sql.ui.metadata.SchemaUtil;
import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.utils.ModelUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PluginTransfer;

public class DBMetadata {
    private TreeViewer treeViewer;
    private MSQLRoot root;
    private SQLQueryDesigner designer;
    private boolean running = false;
    private Label msg;
    private StackLayout stackLayout;
    private Composite mcmp;
    private Composite composite;
    private DataAdapterService das;
    private String dbproduct;
    private boolean schemaTableQuote = false;
    private String identifierQuote = "";
    private String[] schema;
    private LinkedHashMap<String, MSqlTable> tblMap;
    private List<IProgressMonitor> monitors = new ArrayList<IProgressMonitor>();
    private List<String> tableTypes;
    private Connection connection;

    public DBMetadata(SQLQueryDesigner designer) {
        this.designer = designer;
    }

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.composite.setLayout((Layout)this.stackLayout);
        this.mcmp = new Composite(this.composite, 2048);
        this.mcmp.setLayout((Layout)new GridLayout());
        this.msg = new Label(this.mcmp, 0x1000040);
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.minimumHeight = 100;
        gd.minimumWidth = 200;
        this.msg.setLayoutData((Object)gd);
        this.msg.setText(Messages.DBMetadata_0);
        this.msg.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DBMetadata.this.doRefreshMetadata();
            }
        });
        this.treeViewer = new TreeViewer(this.composite, 2050);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof INode) {
                    INode node = (INode)parentElement;
                    List children = node.getChildren();
                    ArrayList<INode> newchildren = new ArrayList<INode>();
                    for (INode n : children) {
                        if (n instanceof INotInMetadata && ((INotInMetadata)n).isNotInMetadata() || n.getValue() instanceof String && ((String)n.getValue()).isEmpty()) continue;
                        newchildren.add(n);
                    }
                    if (!newchildren.isEmpty()) {
                        return newchildren.toArray();
                    }
                }
                return EMPTY_ARRAY;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addDragSupport(3, new Transfer[]{NodeTransfer.getInstance(), PluginTransfer.getInstance()}, (DragSourceListener)new NodeDragListener((StructuredViewer)this.treeViewer){

            public void dragStart(DragSourceEvent event) {
                TreeSelection s = (TreeSelection)DBMetadata.this.treeViewer.getSelection();
                TreePath[] treePathArray = s.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath tp = treePathArray[n2];
                    if (!(tp.getLastSegment() instanceof IDragable)) {
                        event.doit = false;
                        return;
                    }
                    ++n2;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                DBMetadata.this.treeViewer.refresh(true);
                if (!event.doit) {
                    return;
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)DBMetadata.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (DBMetadata.this.treeViewer.getExpandedState(el)) {
                    DBMetadata.this.treeViewer.collapseToLevel(el, 1);
                } else {
                    DBMetadata.this.treeViewer.expandToLevel(el, 1);
                    if (el instanceof MSqlSchema) {
                        DBMetadata.this.loadSchema((MSqlSchema)el);
                    } else if (el instanceof MSqlTable) {
                        DBMetadata.this.loadTable((MSqlTable)el);
                    }
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (element instanceof MSqlSchema) {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DBMetadata.this.loadSchema((MSqlSchema)element);
                        }
                    });
                } else if (element instanceof MSqlTable) {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DBMetadata.this.loadTable((MSqlTable)element);
                        }
                    });
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        menuMgr.add((IAction)new Action(Messages.DBMetadata_1){

            public void run() {
                DBMetadata.this.doRefreshMetadata();
            }
        });
        this.treeViewer.getControl().setMenu(menu);
        this.stackLayout.topControl = this.mcmp;
        this.root = this.designer.createRoot(this.root);
        this.updateUI(this.root);
        return this.composite;
    }

    public void closeConnection() {
        SchemaUtil.close(this.connection);
    }

    public void updateMetadata(final DataAdapterDescriptor da, DataAdapterService das, IProgressMonitor monitor) {
        if (this.running) {
            return;
        }
        this.das = das;
        this.monitors.add(monitor);
        this.running = true;
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (DBMetadata.this.msg.isDisposed()) {
                    return;
                }
                DBMetadata.this.msg.setText(String.valueOf(Messages.DBMetadata_2) + da.getName() + Messages.DBMetadata_3);
                this.safelyAttachContextMenu(DBMetadata.this.mcmp);
                DBMetadata.this.stackLayout.topControl = DBMetadata.this.mcmp;
                DBMetadata.this.mcmp.layout(true);
                DBMetadata.this.composite.layout(true);
            }

            private void safelyAttachContextMenu(Composite mcmp) {
                if (mcmp.getMenu() == null) {
                    MenuManager menuMgr = new MenuManager();
                    Menu menu = menuMgr.createContextMenu((Control)mcmp);
                    menuMgr.add((IAction)new Action(Messages.DBMetadata_Retry){

                        public void run() {
                            DBMetadata.this.doRefreshMetadata();
                        }
                    });
                    mcmp.setMenu(menu);
                }
            }
        });
        this.root.removeChildren();
        if (this.tblMap != null) {
            this.tblMap.clear();
        }
        this.connection = this.getConnection(das, true);
        if (this.connection != null) {
            try {
                DatabaseMetaData meta = this.connection.getMetaData();
                this.tableTypes = DBMetadata.readTableTypes(meta);
                List<MSqlSchema> mcurrent = MetaDataUtil.readSchemas(monitor, this.root, meta, this.schema);
                this.updateUI(this.root);
                for (MSqlSchema mcs : mcurrent) {
                    meta = this.checkClosed(meta);
                    this.readSchema(this, meta, mcs, monitor, true);
                }
            }
            catch (Throwable e) {
                this.updateUI(this.root);
                this.designer.showError(e);
            }
        }
        this.updateItermediateUI();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Util.refreshTables(DBMetadata.this.root, DBMetadata.this.designer.getRoot(), DBMetadata.this.designer);
                DBMetadata.this.updateItermediateUI();
            }
        });
        this.closeConnection();
        this.monitors.remove(monitor);
        this.running = false;
    }

    public DatabaseMetaData checkClosed(DatabaseMetaData meta) throws SQLException {
        try {
            if (meta.getConnection() == null) {
                this.connection = this.getConnection(this.das, true);
            }
            if (meta.getConnection().isClosed()) {
                this.connection = this.getConnection(this.das, true);
                return this.connection.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            this.connection = this.getConnection(this.das, true);
            return this.connection.getMetaData();
        }
        return meta;
    }

    public DatabaseMetaData getMetadata() throws SQLException {
        this.connection = this.getConnection(this.das, true);
        return this.connection.getMetaData();
    }

    public void loadTable(final MSqlTable mtable) {
        if (this.das != null && ModelUtils.isEmpty((ANode)mtable)) {
            try {
                this.designer.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.DBMetadata_4, -1);
                        try {
                            DBMetadata.this.monitors.add(monitor);
                            DatabaseMetaData meta = DBMetadata.this.getConnection(DBMetadata.this.das, false).getMetaData();
                            MetaDataUtil.readTableColumns(meta, mtable, monitor);
                            DBMetadata.this.updateItermediateUI();
                            if (monitor.isCanceled()) {
                                return;
                            }
                            try {
                                MetaDataUtil.readTableKeys(meta, mtable, monitor);
                                DBMetadata.this.updateItermediateUI();
                            }
                            catch (Throwable e) {
                                DBMetadata.this.designer.showError(e);
                            }
                        }
                        finally {
                            DBMetadata.this.closeConnection();
                            DBMetadata.this.monitors.remove(monitor);
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSchema(final MSqlSchema mschema) {
        if (this.das != null && ModelUtils.isEmpty((ANode)mschema)) {
            try {
                this.designer.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.DBMetadata_5, -1);
                        try {
                            try {
                                DBMetadata.this.monitors.add(monitor);
                                DBMetadata.this.readSchema(DBMetadata.this, DBMetadata.this.getConnection(DBMetadata.this.das, false).getMetaData(), mschema, monitor, false);
                            }
                            catch (Throwable e) {
                                DBMetadata.this.designer.showError(e);
                                DBMetadata.this.closeConnection();
                                DBMetadata.this.monitors.remove(monitor);
                                monitor.done();
                            }
                        }
                        finally {
                            DBMetadata.this.closeConnection();
                            DBMetadata.this.monitors.remove(monitor);
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void readSchema(DBMetadata dbmeta, DatabaseMetaData meta, MSqlSchema schema, IProgressMonitor monitor, boolean firstSelection) {
        try {
            MetaDataUtil.readSchema(dbmeta, meta, schema, monitor, this.tableTypes);
            this.updateItermediateUI(false);
            if (monitor.isCanceled()) {
                return;
            }
            if (schema.isNotInMetadata()) {
                return;
            }
            schema.setDbMetadata(this);
            this.checkClosed(meta);
            MetaDataUtil.readSchemaTables(this, meta, schema, this.getTables(), monitor);
            this.updateItermediateUI();
            if (monitor.isCanceled()) {
                return;
            }
            if (firstSelection) {
                this.setFirstSelection();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (schema.isNotInMetadata()) {
            MetaDataUtil.readProcedures(meta, schema, monitor);
            this.updateItermediateUI();
        }
    }

    public MRoot getRoot() {
        return this.root;
    }

    public Connection getConnection(DataAdapterService das, boolean readCurrentSchema) {
        this.schema = null;
        SchemaUtil.close(this.connection);
        HashMap parameters = new HashMap();
        try {
            if (das != null) {
                das.contributeParameters(parameters);
            }
        }
        catch (JRException e1) {
            this.updateUI(this.root);
            this.designer.showError(e1);
        }
        catch (JRRuntimeException jRRuntimeException) {
            return null;
        }
        this.connection = (Connection)parameters.get("REPORT_CONNECTION");
        if (this.connection == null) {
            return this.connection;
        }
        if (readCurrentSchema) {
            this.schema = SchemaUtil.getSchemaPath(this.connection);
        }
        try {
            block14: {
                DatabaseMetaData metaData = this.connection.getMetaData();
                this.dbproduct = metaData.getDatabaseProductName();
                this.identifierQuote = metaData.getIdentifierQuoteString();
                this.designer.doRefreshRoots(false);
                try {
                    System.out.println("db product name: " + this.dbproduct);
                    System.out.println("JDBC Quotes: " + metaData.getIdentifierQuoteString());
                    System.out.println("getExtraNameCharacters: " + metaData.getExtraNameCharacters());
                    System.out.println("storesLowerCaseIdentifiers: " + metaData.storesLowerCaseIdentifiers());
                    System.out.println("storesLowerCaseQuotedIdentifiers: " + metaData.storesLowerCaseQuotedIdentifiers());
                    System.out.println("storesMixedCaseIdentifiers: " + metaData.storesMixedCaseIdentifiers());
                    System.out.println("storesMixedCaseQuotedIdentifiers: " + metaData.storesMixedCaseQuotedIdentifiers());
                    System.out.println("storesUpperCaseIdentifiers: " + metaData.storesUpperCaseIdentifiers());
                    System.out.println("storesUpperCaseQuotedIdentifiers: " + metaData.storesUpperCaseQuotedIdentifiers());
                    System.out.println("supportsMixedCaseIdentifiers: " + metaData.supportsMixedCaseIdentifiers());
                    System.out.println("supportsMixedCaseQuotedIdentifiers: " + metaData.supportsMixedCaseQuotedIdentifiers());
                    System.out.println("catalogSeparator: " + metaData.getCatalogSeparator());
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                    if (!this.connection.isClosed()) break block14;
                    try {
                        if (das != null) {
                            das.contributeParameters(parameters);
                        }
                        this.connection = (Connection)parameters.get("REPORT_CONNECTION");
                        if (this.connection == null) {
                            return this.connection;
                        }
                    }
                    catch (JRException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            this.schemaTableQuote = this.dbproduct.equalsIgnoreCase("GoogleBigQuery");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.connection;
    }

    public boolean isSchemaTableQuote() {
        return this.schemaTableQuote;
    }

    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    public String[] getCurrentSchema() {
        return this.schema;
    }

    protected void updateUI(final MSQLRoot root) {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (DBMetadata.this.treeViewer.getControl().isDisposed()) {
                    return;
                }
                DBMetadata.this.root = root;
                if (DBMetadata.this.root == null) {
                    DBMetadata.this.root = DBMetadata.this.designer.createRoot(root);
                }
                DBMetadata.this.treeViewer.setInput((Object)DBMetadata.this.root);
                DBMetadata.this.designer.refreshQueryModel();
                DBMetadata.this.setFirstSelection();
                if (DBMetadata.isEmptySchema(root)) {
                    DBMetadata.this.msg.setText(Messages.DBMetadata_6);
                    DBMetadata.this.stackLayout.topControl = DBMetadata.this.mcmp;
                } else {
                    DBMetadata.this.stackLayout.topControl = DBMetadata.this.treeViewer.getControl();
                }
                if (!DBMetadata.this.composite.isDisposed()) {
                    DBMetadata.this.composite.layout(true);
                }
            }
        });
    }

    public static boolean isEmptySchema(MRoot root) {
        if (root.getChildren().isEmpty()) {
            return true;
        }
        for (INode n : root.getChildren()) {
            if (!(n instanceof MSqlSchema) || ((MSqlSchema)n).isNotInMetadata()) continue;
            return false;
        }
        return true;
    }

    public void updateMessageText(final String newText) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DBMetadata.this.msg != null && !DBMetadata.this.msg.isDisposed()) {
                    DBMetadata.this.msg.setText(newText);
                }
            }
        });
    }

    protected void updateItermediateUI() {
        this.updateItermediateUI(true);
    }

    protected void updateItermediateUI(final boolean refreshMetadata) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DBMetadata.this.treeViewer.getControl().isDisposed()) {
                    DBMetadata.this.treeViewer.refresh(true);
                    if (refreshMetadata) {
                        DBMetadata.this.designer.refreshedMetadata();
                    }
                }
            }
        });
    }

    protected void setFirstSelection() {
        if (this.schema == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (INode n : DBMetadata.this.root.getChildren()) {
                    if (!(n instanceof MSqlSchema) || n.getValue() == null || !n.getValue().equals(DBMetadata.this.schema)) continue;
                    ((MSqlSchema)n).setCurrent(true);
                    DBMetadata.this.treeViewer.expandToLevel((Object)((MSqlSchema)n), 1);
                    break;
                }
            }
        });
    }

    public LinkedHashMap<String, MSqlTable> getTables() {
        if (this.tblMap == null) {
            this.tblMap = new LinkedHashMap();
        }
        return this.tblMap;
    }

    public void dispose() {
        this.closeConnection();
        if (this.monitors != null) {
            for (IProgressMonitor m : this.monitors) {
                m.setCanceled(true);
            }
        }
    }

    protected void doRefreshMetadata() {
        if (!this.running) {
            this.designer.showInfo("");
            this.designer.updateMetadata();
        }
    }

    public static List<String> readTableTypes(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> tableTypes = new ArrayList<String>();
        ResultSet rs = meta.getTableTypes();
        while (rs.next()) {
            tableTypes.add(rs.getString("TABLE_TYPE"));
        }
        rs.close();
        return tableTypes;
    }

    public void forceRunningStatus(boolean running) {
        this.running = running;
    }
}

