/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.metadata;

import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.MDBObjects;
import com.jaspersoft.studio.data.sql.model.metadata.MFunction;
import com.jaspersoft.studio.data.sql.model.metadata.MProcedure;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.metadata.MTables;
import com.jaspersoft.studio.data.sql.model.metadata.keys.ForeignKey;
import com.jaspersoft.studio.data.sql.model.metadata.keys.PrimaryKey;
import com.jaspersoft.studio.data.sql.ui.metadata.DBMetadata;
import com.jaspersoft.studio.data.sql.ui.metadata.SchemaUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.model.MRoot;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.IProgressMonitor;

public class MetaDataUtil {
    public static synchronized List<MSqlSchema> readSchemas(IProgressMonitor monitor, MRoot root, DatabaseMetaData meta, String[] cschemas) throws SQLException {
        ArrayList<MSqlSchema> mcurrent = new ArrayList<MSqlSchema>();
        boolean isSchema = meta.supportsSchemasInTableDefinitions();
        boolean isCatalog = meta.supportsCatalogsInTableDefinitions();
        ResultSet rs = isSchema ? meta.getSchemas() : meta.getCatalogs();
        try {
            while (rs.next()) {
                String tableCatalog = isCatalog && !isSchema ? rs.getString("TABLE_CAT") : null;
                String tableSchema = isSchema ? rs.getString("TABLE_SCHEM") : tableCatalog;
                MSqlSchema mschema = new MSqlSchema((ANode)root, tableSchema, tableCatalog);
                new MDummy((ANode)mschema);
                if (!monitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
        if (Misc.isNullOrEmpty((Collection)root.getChildren())) {
            MSqlSchema mschema = new MSqlSchema((ANode)root, null, null);
            new MDummy((ANode)mschema);
        }
        if (cschemas != null) {
            String[] stringArray = cschemas;
            int n = cschemas.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                for (INode n3 : root.getChildren()) {
                    if (!(n3 instanceof MSqlSchema) || !s.equals(((MSqlSchema)n3).getValue())) continue;
                    mcurrent.add((MSqlSchema)n3);
                    ((MSqlSchema)n3).setCurrent(true);
                }
                ++n2;
            }
        }
        return mcurrent;
    }

    public static synchronized void readSchema(DBMetadata dbmeta, DatabaseMetaData meta, MSqlSchema schema, IProgressMonitor monitor, List<String> tableTypes) {
        block12: {
            ResultSet rs = null;
            try {
                try {
                    boolean isSchema = meta.supportsSchemasInTableDefinitions();
                    boolean isCatalog = meta.supportsCatalogsInTableDefinitions();
                    if (!isSchema && !isCatalog && schema.getValue() == null) {
                        schema.removeChildren();
                        schema.setNotInMetadata(false);
                        for (String ttype : tableTypes) {
                            new MDummy((ANode)new MTables(schema, ttype));
                        }
                    } else {
                        meta = dbmeta.checkClosed(meta);
                        rs = isSchema ? meta.getSchemas() : meta.getCatalogs();
                        boolean hasSchemas = false;
                        while (rs.next()) {
                            String tableSchema;
                            hasSchemas = true;
                            String tableCatalog = isCatalog && !isSchema ? rs.getString("TABLE_CAT") : null;
                            String string = tableSchema = isSchema ? rs.getString("TABLE_SCHEM") : tableCatalog;
                            if (tableSchema == null || !tableSchema.equals(schema.getValue())) continue;
                            schema.removeChildren();
                            schema.setNotInMetadata(false);
                            for (String ttype : tableTypes) {
                                new MDummy((ANode)new MTables(schema, ttype));
                            }
                        }
                        if (!hasSchemas) {
                            schema.removeChildren();
                            schema.setNotInMetadata(false);
                            for (String ttype : tableTypes) {
                                new MDummy((ANode)new MTables(schema, ttype));
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SchemaUtil.close(rs);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                SchemaUtil.close(rs);
                throw throwable;
            }
            SchemaUtil.close(rs);
        }
    }

    public static synchronized void readSchemaTables(DBMetadata dbmeta, DatabaseMetaData meta, MSqlSchema schema, LinkedHashMap<String, MSqlTable> tables, IProgressMonitor monitor) {
        try {
            for (INode n : schema.getChildren()) {
                if (!(n instanceof MTables)) continue;
                ((MTables)n).setDbMetadata(schema.getDbMetadata());
                MetaDataUtil.readTables(dbmeta, meta, schema.getValue(), schema.getTableCatalog(), (MTables)n, tables, monitor);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void readTables(DBMetadata dbmeta, DatabaseMetaData meta, String tableSchema, String tableCatalog, MTables mview, LinkedHashMap<String, MSqlTable> tblMap, IProgressMonitor monitor) {
        block7: {
            mview.removeChildren();
            ResultSet rs = null;
            try {
                try {
                    meta = dbmeta.checkClosed(meta);
                    rs = meta.getTables(tableCatalog, tableSchema, "%", new String[]{mview.getValue()});
                    while (rs.next()) {
                        String tblName = rs.getString("TABLE_NAME");
                        MSqlTable mt = new MSqlTable((ANode)mview, tblName, rs);
                        new MDummy((ANode)mt);
                        tblMap.put(mt.toSQLString(), mt);
                        if (!monitor.isCanceled()) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    SchemaUtil.close(rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SchemaUtil.close(rs);
                throw throwable;
            }
            SchemaUtil.close(rs);
        }
    }

    public static synchronized void readTableColumns(DatabaseMetaData meta, MSqlTable mtable, IProgressMonitor monitor) throws SQLException {
        MTables tables = (MTables)mtable.getParent();
        mtable.removeChildren();
        ResultSet rs = meta.getColumns(tables.getTableCatalog(), tables.getTableSchema(), mtable.getValue(), SchemaUtil.getMetadataAllSymbol(meta));
        try {
            while (rs.next()) {
                new MSQLColumn((ANode)mtable, rs.getString("COLUMN_NAME"), rs);
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
    }

    public static synchronized void readTableKeys(DatabaseMetaData meta, MSqlTable mtable, IProgressMonitor monitor) throws SQLException {
        MetaDataUtil.readPrimaryKeys(meta, mtable, monitor);
        if (!monitor.isCanceled()) {
            MetaDataUtil.readForeignKeys(meta, mtable, monitor);
        }
        if (!monitor.isCanceled()) {
            MetaDataUtil.readRemarks(meta, mtable, monitor);
        }
    }

    private static void readRemarks(DatabaseMetaData meta, MSqlTable mt, IProgressMonitor monitor) throws SQLException {
        MTables tables = (MTables)mt.getParent();
        ResultSet rs = meta.getColumns(tables.getTableCatalog(), tables.getTableSchema(), mt.getValue(), SchemaUtil.getMetadataAllSymbol(meta));
        try {
            while (rs.next()) {
                String cname = rs.getString("COLUMN_NAME");
                String remark = rs.getString("REMARKS");
                if (!Misc.isNullOrEmpty((String)remark)) {
                    for (INode n : mt.getChildren()) {
                        if (!n.getValue().equals(cname)) continue;
                        ((MSQLColumn)n).setRemarks(remark);
                        break;
                    }
                }
                if (!monitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
    }

    private static void readPrimaryKeys(DatabaseMetaData meta, MSqlTable mt, IProgressMonitor monitor) throws SQLException {
        MTables tables = (MTables)mt.getParent();
        ResultSet rs = meta.getPrimaryKeys(tables.getTableCatalog(), tables.getTableSchema(), mt.getValue());
        PrimaryKey pk = null;
        ArrayList<MSQLColumn> cols = new ArrayList<MSQLColumn>();
        try {
            while (rs.next()) {
                if (pk == null) {
                    pk = new PrimaryKey(rs.getString("PK_NAME"));
                }
                String cname = rs.getString("COLUMN_NAME");
                for (INode n : mt.getChildren()) {
                    if (!n.getValue().equals(cname)) continue;
                    ((MSQLColumn)n).setPrimaryKey(pk);
                    cols.add((MSQLColumn)n);
                    break;
                }
                if (!monitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
        if (pk != null) {
            pk.setColumns(cols.toArray(new MSQLColumn[cols.size()]));
        }
    }

    private static void readForeignKeys(DatabaseMetaData meta, MSqlTable mt, IProgressMonitor monitor) throws SQLException {
        MTables tables = (MTables)mt.getParent();
        ResultSet rs = meta.getImportedKeys(tables.getTableCatalog(), tables.getTableSchema(), mt.getValue());
        ForeignKey fk = null;
        ArrayList<MSQLColumn> srcCols = new ArrayList<MSQLColumn>();
        ArrayList<MSQLColumn> dstCols = new ArrayList<MSQLColumn>();
        ArrayList<String[]> fks = new ArrayList<String[]>();
        try {
            while (rs.next()) {
                fks.add(new String[]{rs.getString("PKTABLE_CAT"), rs.getString("PKTABLE_SCHEM"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("FK_NAME")});
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
        for (String[] f : fks) {
            String pkcatalog = f[0];
            String pkschema = f[1];
            String pktable = f[2];
            String pkcolname = f[3];
            String fkcolname = f[4];
            String fkname = f[5];
            MSqlTable dTable = null;
            if (fk == null || !fk.getFkName().equals(fkname)) {
                MetaDataUtil.closeForeignKey(fk, srcCols, dstCols);
                srcCols.clear();
                dstCols.clear();
                fk = new ForeignKey(fkname, mt);
                dTable = Util.getTable(tables.getRoot(), pkcatalog, pkschema, pktable);
                if (dTable.getChildren().isEmpty() || dTable.getChildren().get(0) instanceof MDummy) {
                    MetaDataUtil.readTableColumns(meta, dTable, monitor);
                    MetaDataUtil.readTableKeys(meta, dTable, monitor);
                }
            }
            for (INode n : mt.getChildren()) {
                if (!n.getValue().equals(fkcolname)) continue;
                srcCols.add((MSQLColumn)n);
                break;
            }
            if (dTable != null) {
                for (INode n : dTable.getChildren()) {
                    if (!n.getValue().equals(pkcolname)) continue;
                    dstCols.add((MSQLColumn)n);
                    break;
                }
            } else {
                fk = null;
            }
            if (monitor.isCanceled()) break;
        }
        MetaDataUtil.closeForeignKey(fk, srcCols, dstCols);
    }

    private static void closeForeignKey(ForeignKey fk, List<MSQLColumn> srcCols, List<MSQLColumn> dstCols) {
        if (fk != null) {
            for (MSQLColumn c : srcCols) {
                c.addForeignKey(fk);
            }
            for (MSQLColumn c : dstCols) {
                c.addForeignKey(fk);
            }
            fk.setColumns(srcCols.toArray(new MSQLColumn[srcCols.size()]), dstCols.toArray(new MSQLColumn[dstCols.size()]));
        }
    }

    public static synchronized void readProcedures(DatabaseMetaData meta, MSqlSchema schema, IProgressMonitor monitor) {
        ResultSet rs;
        block13: {
            rs = null;
            try {
                try {
                    rs = meta.getProcedures(schema.getTableCatalog(), schema.getValue(), "%");
                    MDBObjects mprocs = new MDBObjects((ANode)schema, "Procedures", "icons/function.png");
                    while (rs.next()) {
                        new MProcedure((ANode)mprocs, rs.getString("PROCEDURE_NAME"), rs);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    SchemaUtil.close(rs);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                SchemaUtil.close(rs);
                throw throwable;
            }
            SchemaUtil.close(rs);
        }
        if (monitor.isCanceled()) {
            return;
        }
        try {
            try {
                rs = meta.getFunctions(schema.getTableCatalog(), schema.getValue(), "%");
                MDBObjects mfunct = new MDBObjects((ANode)schema, "Functions", "icons/function.png");
                while (rs.next()) {
                    new MFunction((ANode)mfunct, rs.getString("FUNCTION_NAME"), rs);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                SchemaUtil.close(rs);
            }
        }
        finally {
            SchemaUtil.close(rs);
        }
    }
}

