/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.widgets;

import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FunctionOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ParameterNotPOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ParameterPOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ScalarOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.UnknownOperand;
import com.jaspersoft.studio.data.sql.widgets.AOperandWidget;
import com.jaspersoft.studio.data.sql.widgets.FieldWidget;
import com.jaspersoft.studio.data.sql.widgets.FunctionWidget;
import com.jaspersoft.studio.data.sql.widgets.ParameterWidget;
import com.jaspersoft.studio.data.sql.widgets.UnknownOperandWidget;
import com.jaspersoft.studio.data.sql.widgets.scalar.DateWidget;
import com.jaspersoft.studio.data.sql.widgets.scalar.NumberWidget;
import com.jaspersoft.studio.data.sql.widgets.scalar.StringWidget;
import com.jaspersoft.studio.data.sql.widgets.scalar.TimeWidget;
import com.jaspersoft.studio.data.sql.widgets.scalar.TimestampWidget;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Factory {
    public static final String OPERANDWIDGET = "operandwidget";
    public static final String OPERAND = "operand";
    public static final String OPERANDS = "OPERANDS";
    public static final String OPERANDS_INDEX = "OPERANDS_INDEX";
    private static SelectionAdapter slistener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem mi = (MenuItem)e.getSource();
            AOperandWidget w = (AOperandWidget)((Object)mi.getData(Factory.OPERANDWIDGET));
            AOperand op = (AOperand)mi.getData(Factory.OPERAND);
            List operands = (List)mi.getData(Factory.OPERANDS);
            int index = (Integer)mi.getData(Factory.OPERANDS_INDEX);
            Composite parent = w.getParent();
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            if (index < operands.size()) {
                operands.set(index, op);
            } else {
                operands.add(op);
            }
            AOperandWidget<?> neww = Factory.createWidget(parent, (AOperand)operands.get(index), w.getDesigner());
            neww.setOperandMap(w.getOperandMap());
            neww.setMenuOperands(w.getMenuOperands());
            neww.setOperands(operands, index);
            Factory.createWidgetMenu(neww, operands, index, op.getExpression());
            parent.layout(true);
        }
    };

    public static Control createWidget(Composite parent, List<AOperand> operands, int index, AMExpression<?> mexpr, AQueryDesigner designer) {
        return Factory.createWidget(parent, operands, index, mexpr, false, designer);
    }

    public static Control createWidget(Composite parent, List<AOperand> operands, int index, AMExpression<?> mexpr, boolean exludeField, AQueryDesigner designer) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new FillLayout());
        AOperand op = null;
        if (index >= 0 && index < operands.size()) {
            op = operands.get(index);
        } else {
            op = new ScalarOperand<String>(mexpr, "Venice");
            operands.add(op);
        }
        AOperandWidget<?> w = Factory.createWidget(cmp, op, designer);
        w.setExludeField(exludeField);
        w.setOperandMap(w.getOperandMap());
        w.setOperands(operands, index);
        Factory.createWidgetMenu(w, operands, index, mexpr);
        return cmp;
    }

    public static Control createWidget(Composite parent, List<AOperand> operands, int index, AMExpression<?> mexpr, Set<Class<? extends AOperand>> menuOperand, AQueryDesigner designer) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new FillLayout());
        AOperand op = null;
        op = index >= 0 && index < operands.size() ? operands.get(index) : new FieldOperand(null, null, mexpr);
        AOperandWidget<?> w = Factory.createWidget(cmp, op, designer);
        w.setMenuOperands(menuOperand);
        w.setOperandMap(w.getOperandMap());
        w.setOperands(operands, index);
        Factory.createWidgetMenu(w, operands, index, mexpr);
        return cmp;
    }

    protected static void createWidgetMenu(AOperandWidget<?> w, List<AOperand> operands, int index, AMExpression<?> mexpr) {
        Control[] controlArray = w.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Menu popupMenu = new Menu(c);
            Factory.buildMenu(popupMenu, w, operands, index, mexpr);
            c.setMenu(popupMenu);
            ++n2;
        }
    }

    public static <T extends AOperand> AOperandWidget<?> createWidget(Composite parent, T operand, AQueryDesigner designer) {
        AOperandWidget<?> w = null;
        if (operand instanceof FieldOperand) {
            return new FieldWidget(parent, (FieldOperand)operand, designer);
        }
        if (operand instanceof ParameterNotPOperand) {
            return new ParameterWidget(parent, (ParameterNotPOperand)operand, designer);
        }
        if (operand instanceof ParameterPOperand) {
            return new ParameterWidget(parent, (ParameterPOperand)operand, designer);
        }
        if (operand instanceof ScalarOperand) {
            Class type = ((ScalarOperand)operand).getType();
            if (Number.class.isAssignableFrom(type)) {
                return new NumberWidget(parent, (ScalarOperand)operand, designer);
            }
            if (Time.class.isAssignableFrom(type)) {
                return new TimeWidget(parent, (ScalarOperand)operand, designer);
            }
            if (Date.class.isAssignableFrom(type)) {
                return new DateWidget(parent, (ScalarOperand)operand, designer);
            }
            if (java.util.Date.class.isAssignableFrom(type)) {
                return new TimestampWidget(parent, (ScalarOperand)operand, designer);
            }
            return new StringWidget(parent, (ScalarOperand)operand, designer);
        }
        if (operand instanceof FunctionOperand) {
            return new FunctionWidget(parent, (FunctionOperand)operand, designer);
        }
        if (operand instanceof UnknownOperand) {
            return new UnknownOperandWidget(parent, (UnknownOperand)operand, designer);
        }
        return w;
    }

    public static void buildMenu(Menu pMenu, AOperandWidget<?> w, List<AOperand> operands, int index, AMExpression<?> mexpr) {
        Map<String, AOperand> opMap = Factory.buildMap(w, mexpr);
        Menu newMenu = null;
        for (String key : opMap.keySet()) {
            MenuItem mi1 = null;
            AOperand aOperand = opMap.get(key);
            if (!w.isMenuOperands(aOperand.getClass()) || aOperand instanceof FieldOperand && w.isExludeField()) continue;
            if (aOperand instanceof ScalarOperand) {
                if (newMenu == null) {
                    MenuItem cmi = new MenuItem(pMenu, 64);
                    cmi.setText(Messages.Factory_5);
                    newMenu = new Menu(pMenu);
                    cmi.setMenu(newMenu);
                }
                mi1 = new MenuItem(newMenu, 32);
            } else {
                mi1 = new MenuItem(pMenu, 32);
            }
            mi1.setText(key);
            mi1.setData(OPERAND, (Object)aOperand);
            Factory.setupMenuItem(mi1, w, operands, index);
            if (w.getValue() != aOperand && (w.getValue() == null || w.getValue() instanceof ScalarOperand || !w.getValue().getClass().equals(aOperand.getClass())) && (!(w.getValue() instanceof ScalarOperand) || !(aOperand instanceof ScalarOperand) || !((ScalarOperand)w.getValue()).getType().equals(((ScalarOperand)aOperand).getType()))) continue;
            mi1.setSelection(true);
        }
    }

    private static void setupMenuItem(MenuItem mi1, AOperandWidget<?> w, List<AOperand> operands, int index) {
        mi1.setData(OPERANDWIDGET, w);
        mi1.setData(OPERANDS, operands);
        mi1.setData(OPERANDS_INDEX, (Object)index);
        mi1.addSelectionListener((SelectionListener)slistener);
    }

    public static Map<String, AOperand> buildMap(AOperandWidget<?> w, AMExpression<?> mexpr) {
        Map<String, AOperand> opMap = w.getOperandMap();
        if (opMap == null) {
            opMap = new LinkedHashMap<String, AOperand>();
            opMap.put(Messages.Factory_6, Factory.getOperand(w, new ParameterPOperand(mexpr)));
            opMap.put(Messages.Factory_7, Factory.getOperand(w, new ParameterNotPOperand(mexpr)));
            opMap.put(Messages.Factory_8, Factory.getOperand(w, new FieldOperand(null, null, mexpr)));
            opMap.put(Messages.Factory_9, Factory.getOperand(w, Factory.getDefaultOperand(mexpr)));
            opMap.put(Messages.Factory_10, Factory.getOperand(w, new ScalarOperand<BigDecimal>(mexpr, BigDecimal.ZERO)));
            opMap.put(Messages.Factory_11, Factory.getOperand(w, new ScalarOperand<Date>(mexpr, new Date(new java.util.Date().getTime()))));
            opMap.put(Messages.Factory_12, Factory.getOperand(w, new ScalarOperand<Time>(mexpr, new Time(new java.util.Date().getTime()))));
            opMap.put(Messages.Factory_13, Factory.getOperand(w, new ScalarOperand<Timestamp>(mexpr, new Timestamp(new java.util.Date().getTime()))));
            opMap.put(Messages.Factory_14, Factory.getOperand(w, new UnknownOperand(mexpr, "")));
            w.setOperandMap(opMap);
        }
        return opMap;
    }

    private static AOperand getOperand(AOperandWidget<?> w, AOperand operand) {
        if (w.getValue().getClass().isInstance(operand)) {
            if (operand instanceof ScalarOperand) {
                ScalarOperand op = (ScalarOperand)operand;
                ScalarOperand wop = (ScalarOperand)w.getValue();
                if (op.getType().isAssignableFrom(wop.getType())) {
                    return w.getValue();
                }
            } else {
                return w.getValue();
            }
        }
        return operand;
    }

    public static final AOperand getDefaultOperand(AMExpression<?> mexpr) {
        return new ScalarOperand<String>(mexpr, Messages.Factory_16);
    }
}

