/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book;

import com.jaspersoft.studio.book.JRBookActivator;
import com.jaspersoft.studio.utils.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookUtils {
    public static final int BOOK_VALID = 2;
    public static final int BOOK_INVALID = 0;

    public static void scanWSForBookReports() throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isOpen() && proj.hasNature("net.sf.jasperreports.nature")) {
                BookUtils.checkContainerMembersForDefaultEditor((IContainer)proj);
            }
            ++n2;
        }
    }

    private static void checkContainerMembersForDefaultEditor(IContainer resource) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = resource.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r instanceof IFile) {
                BookUtils.checkFileResourceForDefaultEditor((IFile)r);
            } else if (r instanceof IContainer) {
                BookUtils.checkContainerMembersForDefaultEditor((IContainer)r);
            }
            ++n2;
        }
    }

    public static void checkFileResourceForDefaultEditor(IFile fileResource) {
        String fileExtension = fileResource.getFileExtension();
        IEditorDescriptor defaultEditor = IDE.getDefaultEditor((IFile)fileResource);
        if ("jrxml".equals(fileExtension) && defaultEditor != null && !"com.jaspersoft.studio.book.editors.JRBookEditor".equals(defaultEditor.getId()) && BookUtils.isValidJRBook(fileResource)) {
            IDE.setDefaultEditor((IFile)fileResource, (String)"com.jaspersoft.studio.book.editors.JRBookEditor");
        }
    }

    public static boolean isValidJRBook(IFile file) {
        try {
            IContentDescription contentDescription = file.getContentDescription();
            InputStream contents = file.getContents();
            int validationResult = BookUtils.validateBook(contents, contentDescription);
            contents.close();
            return 2 == validationResult;
        }
        catch (CoreException e) {
            JRBookActivator.getDefault().logError(e);
            return false;
        }
        catch (IOException e) {
            JRBookActivator.getDefault().logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int validateBook(InputStream in, IContentDescription description) throws IOException {
        try {
            NodeList bookParts;
            Document document;
            if (in.markSupported()) {
                try {
                    in.mark(0);
                    int firstRead = in.read();
                    if (firstRead == -1) {
                        return 0;
                    }
                }
                finally {
                    in.reset();
                }
            }
            if ((document = XMLUtils.parseNoValidation((InputStream)in)) == null) return 0;
            if (document.getDocumentElement() != null) {
                document.getDocumentElement().normalize();
            }
            if ((bookParts = document.getElementsByTagName("part")) == null) return 0;
            if (bookParts.getLength() <= 0) return 0;
            return 2;
        }
        catch (ParserConfigurationException e) {
            JRBookActivator.getDefault().logError(e);
            return 0;
        }
        catch (SAXException e) {
            JRBookActivator.getDefault().logError(e);
        }
        return 0;
    }
}

