/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.dnd;

import com.jaspersoft.studio.book.JRBookActivator;
import com.jaspersoft.studio.book.dnd.PageEditPartTracker;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import com.jaspersoft.studio.book.model.commands.CreatePartAfterCommand;
import com.jaspersoft.studio.book.wizards.PageWizard;
import java.io.File;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    private PageEditPartTracker partTracker;

    public ResourceTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)ResourceTransfer.getInstance());
    }

    protected void updateTargetRequest() {
    }

    protected void eraseTargetFeedback() {
        if (this.partTracker != null) {
            this.partTracker.eraseTargetFeedback();
            this.partTracker.setTargetEditPart(null);
        }
        this.partTracker = null;
    }

    protected EditPart getTargetEditPart() {
        this.partTracker = null;
        EditPart hoveredEditPart = super.getTargetEditPart();
        if (hoveredEditPart == null) {
            return null;
        }
        if (hoveredEditPart.getDragTracker(this.getTargetRequest()) instanceof PageEditPartTracker) {
            this.partTracker = (PageEditPartTracker)hoveredEditPart.getDragTracker(this.getTargetRequest());
            this.partTracker.setViewer(this.getViewer());
            this.partTracker.updateDropLocation(PageEditPartTracker.getDropLocation(hoveredEditPart, this.getDropLocation()));
            return this.partTracker.getContainer();
        }
        return hoveredEditPart;
    }

    protected Command getCommand() {
        DropTargetEvent event = this.getCurrentEvent();
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData eventData = transferDataArray[n2];
            if (ResourceTransfer.getInstance().isSupportedType(eventData)) {
                return this.parseExternalResources((IResource[])event.data, null, null, null);
            }
            ++n2;
        }
        return super.getCommand();
    }

    protected Command getDropCommand(JRExpression connectionExp, JRExpression datasourceExp, JRSubreportParameter[] jrSubreportParameters) {
        DropTargetEvent event = this.getCurrentEvent();
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData eventData = transferDataArray[n2];
            if (ResourceTransfer.getInstance().isSupportedType(eventData)) {
                return this.parseExternalResources((IResource[])event.data, connectionExp, datasourceExp, jrSubreportParameters);
            }
            ++n2;
        }
        return super.getCommand();
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null && this.hasParts()) {
            PageWizard wizard = new PageWizard();
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                Command command = this.getDropCommand(wizard.getConnectionExpression(), wizard.getDatasourceExpression(), wizard.getParameters());
                if (command != null && command.canExecute()) {
                    this.getViewer().getEditDomain().getCommandStack().execute(command);
                }
            } else {
                this.getCurrentEvent().detail = 0;
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
    }

    protected Request createTargetRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setLocation(this.getDropLocation());
        return request;
    }

    private void setDataParameters(JRDesignPart newPart, JRExpression connectionExp, JRExpression datasourceExp, JRSubreportParameter[] jrSubreportParameters) {
        if (newPart.getComponent() instanceof StandardSubreportPartComponent) {
            JRDesignSubreportParameter param;
            StandardSubreportPartComponent subPart = (StandardSubreportPartComponent)newPart.getComponent();
            if (connectionExp != null) {
                param = new JRDesignSubreportParameter();
                param.setName("REPORT_CONNECTION");
                param.setExpression(connectionExp);
                try {
                    subPart.addParameter((JRSubreportParameter)param);
                }
                catch (JRException e) {
                    JRBookActivator.getDefault().logError(e);
                }
            }
            if (datasourceExp != null) {
                param = new JRDesignSubreportParameter();
                param.setName("REPORT_DATA_SOURCE");
                param.setExpression(datasourceExp);
                try {
                    subPart.addParameter((JRSubreportParameter)param);
                }
                catch (JRException e) {
                    JRBookActivator.getDefault().logError(e);
                }
            }
            if (jrSubreportParameters != null) {
                JRSubreportParameter[] jRSubreportParameterArray = jrSubreportParameters;
                int n = jrSubreportParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    param = jRSubreportParameterArray[n2];
                    try {
                        subPart.addParameter((JRSubreportParameter)param);
                    }
                    catch (JRException e) {
                        JRBookActivator.getDefault().logError(e);
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean hasParts() {
        if (this.partTracker == null || this.partTracker.getContainer() == null) {
            return false;
        }
        DropTargetEvent event = this.getCurrentEvent();
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData eventData = transferDataArray[n2];
            if (ResourceTransfer.getInstance().isSupportedType(eventData)) {
                IResource[] iResourceArray = (IResource[])event.data;
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile file;
                    String fileName;
                    IResource resource = iResourceArray[n4];
                    if (resource instanceof IFile && ((fileName = (file = (IFile)resource).getName().toLowerCase()).endsWith(".jrxml") || fileName.endsWith(".jasper"))) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    private Command parseExternalResources(IResource[] input, JRExpression connectionExp, JRExpression datasourceExp, JRSubreportParameter[] jrSubreportParameters) {
        if (this.partTracker == null || this.partTracker.getContainer() == null) {
            return null;
        }
        ArrayList<String> readElements = new ArrayList<String>();
        IResource[] iResourceArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileName;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && ((fileName = (file = (IFile)resource).getName().toLowerCase()).endsWith(".jrxml") || fileName.endsWith(".jasper"))) {
                IPath fileLocation = file.getLocation();
                if ("jrxml".equals(fileLocation.getFileExtension())) {
                    fileLocation = fileLocation.removeFileExtension();
                    fileLocation = fileLocation.addFileExtension("jasper");
                }
                readElements.add(fileLocation.toPortableString());
            }
            ++n2;
        }
        MReportPartContainer modelContainer = this.partTracker.getContainer().getBookModel();
        MReportPart afterPart = this.partTracker.getAfterPart() != null ? (MReportPart)((Object)this.partTracker.getAfterPart().getModel()) : null;
        CompoundCommand cc = new CompoundCommand();
        int i = readElements.size() - 1;
        while (i > -1) {
            String readElement = (String)readElements.get(i);
            File fileElement = new File(readElement);
            JRDesignExpression partExptession = new JRDesignExpression("\"" + fileElement.getName() + "\"");
            JRDesignPart newPart = MReportPart.createJRElement(partExptession);
            this.setDataParameters(newPart, connectionExp, datasourceExp, jrSubreportParameters);
            CreatePartAfterCommand createCommand = new CreatePartAfterCommand(modelContainer, newPart, afterPart);
            cc.add((Command)createCommand);
            --i;
        }
        return cc;
    }
}

