/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editors.figures;

import com.jaspersoft.studio.book.ReportThumbnailsManager;
import com.jaspersoft.studio.book.editors.figures.BookSectionFigure;
import com.jaspersoft.studio.book.editors.figures.BusyImageFigure;
import com.jaspersoft.studio.book.editors.figures.TooltipFigure;
import com.jaspersoft.studio.book.model.MReportPart;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wb.swt.ResourceManager;

public class BookPagesFigure
extends RectangleFigure {
    public static final int PREFERRED_HEIGHT = 150;
    public static final int PREFERRED_WIDTH = 150;
    public static final int PREFERRED_LABEL_HEIGHT = 20;
    private MReportPart model;
    private Image previewImage = null;
    private BusyImageFigure imageFigure = null;
    private TooltipFigure toolTipFigure;
    private Label textFigure;
    private double lastScaleValue = 1.0;
    private boolean loadingJobRunning = false;

    public BookPagesFigure(MReportPart model) {
        this(model, null);
    }

    public BookPagesFigure(MReportPart model, Image previewImage) {
        this.model = model;
        this.setPreferredSize(150, 150);
        this.setOutline(false);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(0);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(ResourceManager.getColor((int)255, (int)255, (int)255));
        if (previewImage == null || previewImage.isDisposed()) {
            Image defaultImage = ResourceManager.getImage((ImageDescriptor)model.getImageDescriptor());
            this.imageFigure = new BusyImageFigure(defaultImage);
        } else {
            this.previewImage = previewImage;
            this.imageFigure = new BusyImageFigure(previewImage);
        }
        this.imageFigure.setAlignment(2);
        this.add((IFigure)this.imageFigure);
        String text = this.model.getDisplayText();
        if (text.length() >= 20) {
            text = String.valueOf(text.substring(0, 16)) + "..\"";
        }
        this.textFigure = new Label(text);
        this.textFigure.setPreferredSize(180, 20);
        this.textFigure.setTextAlignment(2);
        this.add((IFigure)this.textFigure);
        this.toolTipFigure = new TooltipFigure();
        this.toolTipFigure.setMessage(model.getDisplayText());
        this.setToolTip((IFigure)this.toolTipFigure);
    }

    protected void loadPreviewImage(final int size) {
        this.loadingJobRunning = true;
        this.imageFigure.setBusy(true);
        UIJob j = new UIJob("Loading preview image"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    try {
                        Image sourceImage;
                        String reportFileName = ReportThumbnailsManager.getLocation(BookPagesFigure.this.model);
                        if (reportFileName != null && (sourceImage = ReportThumbnailsManager.produceImage(reportFileName, BookPagesFigure.this.model.getJasperConfiguration(), size, true, false)) != null) {
                            BookPagesFigure.this.updateFigure(sourceImage);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        BookPagesFigure.this.imageFigure.setBusy(false);
                        return null;
                    }
                }
                finally {
                    BookPagesFigure.this.imageFigure.setBusy(false);
                }
                BookPagesFigure.this.loadingJobRunning = false;
                return Status.OK_STATUS;
            }
        };
        j.setPriority(50);
        j.schedule();
    }

    public synchronized void updateFigure(Image newImage) {
        this.updateFigure(newImage, false);
    }

    public synchronized void updateFigure(final Image newImage, boolean preventDispose) {
        if (UIUtils.getDisplay() == null || UIUtils.getDisplay().isDisposed()) {
            return;
        }
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Image oldImage = BookPagesFigure.this.previewImage;
                BookPagesFigure.this.previewImage = newImage;
                if (BookPagesFigure.this.previewImage != oldImage) {
                    BookPagesFigure.this.imageFigure.setImage(newImage);
                    if (oldImage != null && !oldImage.isDisposed()) {
                        oldImage.dispose();
                    }
                }
                BookPagesFigure.this.invalidateTree();
                BookPagesFigure.this.repaint();
            }
        });
    }

    public void updateText() {
        String text = this.model.getDisplayText();
        if (text.length() >= 20) {
            text = String.valueOf(text.substring(0, 16)) + "..\"";
        }
        this.textFigure.setText(text);
        this.toolTipFigure.setMessage(this.model.getDisplayText());
    }

    public void setBounds(Rectangle rect) {
        int offsetY = BookSectionFigure.HORIZONTAL_LINE_OFFSET + 4;
        super.setBounds(new Rectangle(rect.x + 15, rect.y + offsetY, rect.width, rect.height));
    }

    public void dispose() {
        if (this.previewImage != null && !this.previewImage.isDisposed()) {
            this.previewImage.dispose();
        }
    }

    public void paint(Graphics graphics) {
        if (!(this.previewImage != null && graphics.getAbsoluteScale() == this.lastScaleValue || this.loadingJobRunning)) {
            this.lastScaleValue = graphics.getAbsoluteScale();
            int width = (int)Math.round((double)this.imageFigure.getPreferredSize().width * this.lastScaleValue);
            int height = (int)Math.round((double)this.imageFigure.getPreferredSize().height * this.lastScaleValue);
            this.loadPreviewImage(Math.max(width, height));
        }
        super.paint(graphics);
    }

    public Image getThubmnailImage() {
        return this.previewImage;
    }
}

