/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editors.figures;

import com.jaspersoft.studio.book.editparts.BookPagesEditPart;
import com.jaspersoft.studio.book.editparts.BookSectionEditPart;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.model.APropertyNode;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.swt.ResourceManager;

public class BookSectionFigure
extends RectangleFigure {
    private static final int TITLE_FONT_HEIGHT = 14;
    private static final int HORIZONTAL_LINE_WIDTH = 1;
    public static int HORIZONTAL_LINE_OFFSET = 27;
    private BookSectionEditPart parentPart;
    private boolean drawFeedback = false;
    private EditPart afterPart = null;

    public BookSectionFigure(BookSectionEditPart parentPart) {
        this.parentPart = parentPart;
        this.setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                int pageWidth = BookSectionFigure.this.getParent().getClientArea().width - 15;
                int figureWidth = Math.round(150.0f);
                int numberForLine = Math.max(pageWidth / (figureWidth + 5), 1);
                int placedOnCurrentLine = 0;
                int x = 10;
                int y = BookSectionFigure.this.getBounds().y + 10;
                int maxRowHeight = 0;
                for (Object child : BookSectionFigure.this.getChildren()) {
                    IFigure childFigure = (IFigure)child;
                    Dimension figureSize = childFigure.getPreferredSize();
                    maxRowHeight = Math.max(maxRowHeight, figureSize.height);
                    childFigure.setBounds(new Rectangle(x, y, figureSize.width, figureSize.height));
                    if (++placedOnCurrentLine >= numberForLine) {
                        placedOnCurrentLine = 0;
                        y += maxRowHeight;
                        x = 10;
                        maxRowHeight = 0;
                        continue;
                    }
                    x += figureSize.width;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return BookSectionFigure.this.getPreferredSize(wHint, hHint);
            }
        });
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int preferredWidth;
        int preferredHeight = 150;
        int pageWidth = wHint > 0 ? wHint : this.getParent().getClientArea().width - 15;
        int figureWidth = 150;
        int numberForLine = Math.max(pageWidth / (figureWidth + 5), 1);
        int numberOfPages = this.parentPart.getChildren().size();
        int numberOfLines = numberOfPages / numberForLine;
        if (numberOfPages % numberForLine > 0) {
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            ++numberOfLines;
        }
        preferredHeight = (preferredHeight + 4) * numberOfLines;
        int n = preferredWidth = numberOfLines == 1 ? 150 * numberOfPages : 150 * numberForLine;
        if (preferredWidth == 0) {
            preferredWidth = 150;
        }
        return new Dimension(preferredWidth, preferredHeight + HORIZONTAL_LINE_OFFSET + 16);
    }

    protected void fillShape(Graphics graphics) {
        int oldLineWidth = graphics.getLineWidth();
        Color oldForeColor = graphics.getForegroundColor();
        Color oldBackColor = graphics.getBackgroundColor();
        Font oldFont = graphics.getFont();
        graphics.setForegroundColor(ResourceManager.getColor((int)189, (int)189, (int)189));
        Rectangle figureBounds = this.getBounds();
        Font titleFont = ResourceManager.getFont((String)oldFont.getFontData()[0].getName(), (int)14, (int)0);
        graphics.setFont(titleFont);
        APropertyNode model = (APropertyNode)this.parentPart.getModel();
        graphics.drawText(model.getDisplayText(), figureBounds.x + 10, figureBounds.y + 1);
        graphics.setLineWidth(5);
        graphics.drawLine(figureBounds.x, figureBounds.y, figureBounds.x, figureBounds.y + figureBounds.height - 10);
        HORIZONTAL_LINE_OFFSET = graphics.getFontMetrics().getHeight() + 2;
        graphics.setLineWidth(1);
        ZoomManager zoomManager = (ZoomManager)this.parentPart.getViewer().getProperty(ZoomManager.class.toString());
        int pageWidth = (int)((double)((MainDesignerRootEditPart)this.parentPart.getViewer().getRootEditPart()).getFigure().getBounds().width / zoomManager.getZoom());
        graphics.drawLine(figureBounds.x + 10, figureBounds.y + HORIZONTAL_LINE_OFFSET, figureBounds.x + pageWidth, figureBounds.y + HORIZONTAL_LINE_OFFSET);
        graphics.setLineWidth(oldLineWidth);
        graphics.setForegroundColor(oldForeColor);
        graphics.setBackgroundColor(oldBackColor);
        graphics.setFont(oldFont);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child.isVisible()) {
                child.paint(graphics);
            }
            ++i;
        }
        this.paintDropFeedBack(graphics);
    }

    protected void paintDropFeedBack(Graphics graphics) {
        if (this.drawFeedback) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(ResourceManager.getColor((int)0, (int)0, (int)0));
            if (this.afterPart == null) {
                if (this.getChildren().size() > 0) {
                    IFigure childFigure = (IFigure)this.getChildren().get(0);
                    Rectangle figureBound = childFigure.getBounds();
                    graphics.drawLine(figureBound.x, figureBound.y, figureBound.x, figureBound.y + figureBound.height);
                }
            } else {
                Rectangle figureBound = ((BookPagesEditPart)this.afterPart).getFigure().getBounds();
                int x = figureBound.x + figureBound.width - 10;
                graphics.drawLine(x, figureBound.y, x, figureBound.y + figureBound.height);
            }
        }
    }

    public void validate() {
        for (Object figure : this.getChildren()) {
            Figure child = (Figure)figure;
            child.setValid(false);
        }
        super.validate();
    }

    protected void outlineShape(Graphics graphics) {
    }

    public void clearFeedback() {
        this.drawFeedback = false;
    }

    public void drawFeedback(EditPart afterPart) {
        this.afterPart = afterPart;
        this.drawFeedback = true;
    }

    public boolean hasFeedback() {
        return this.drawFeedback;
    }

    public EditPart afterPart() {
        return this.afterPart;
    }
}

