/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.commands;

import com.jaspersoft.studio.book.gallery.controls.GalleryComposite;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import com.jaspersoft.studio.book.model.MReportPart;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MoveElementAfter
extends AbstractOperation {
    private IGalleryElement previousItem;
    private IGalleryElement elementMoved;
    private GalleryComposite source;
    private GalleryComposite target;
    private IGalleryElement oldPreviousItem = null;
    private JRDesignPart part;

    public MoveElementAfter(IGalleryElement previousItem, IGalleryElement elementMoved, GalleryComposite source, GalleryComposite target) {
        super("Move Item");
        this.source = source;
        this.target = target;
        this.elementMoved = elementMoved;
        MReportPart mpart = (MReportPart)((Object)elementMoved.getData());
        this.part = mpart.getValue();
        this.previousItem = previousItem;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        JRDesignSection jrsectionTarget;
        int oldIndex = this.source.getIndexOf(this.elementMoved);
        this.oldPreviousItem = oldIndex == 0 ? null : this.source.getElementAt(oldIndex - 1);
        this.source.removeItem(oldIndex);
        JRDesignSection jrsectionSource = this.source.getPartsContainer().getSection();
        if (jrsectionSource != null) {
            jrsectionSource.removePart(oldIndex);
        }
        int newIndex = 0;
        if (this.previousItem != null) {
            newIndex = this.target.getIndexOf(this.previousItem) + 1;
        }
        if ((jrsectionTarget = this.target.getPartsContainer().getSection()) != null) {
            jrsectionTarget.addPart(newIndex, (JRPart)this.part);
        }
        this.target.createItem(this.elementMoved, newIndex);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int oldIndex = this.target.getIndexOf(this.elementMoved);
        this.target.removeItem(oldIndex);
        int newIndex = 0;
        if (this.oldPreviousItem != null) {
            newIndex = this.source.getIndexOf(this.oldPreviousItem) + 1;
        }
        this.source.createItem(this.elementMoved, newIndex);
        return Status.OK_STATUS;
    }
}

