/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.controls.render;

import com.jaspersoft.studio.book.gallery.controls.DropEffectLocation;
import com.jaspersoft.studio.book.gallery.controls.render.DraggableGalleryItemRenderer;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class DraggableGroupRenderer
extends NoGroupRenderer {
    private DropEffectLocation dropTargetEffect = null;

    public void draw(GC gc, GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
        super.draw(gc, group, x, y, clipX, clipY, clipWidth, clipHeight);
        this.paintDropTargetEffect(gc);
    }

    protected void paintDropTargetEffect(GC graphicContext) {
        if (this.dropTargetEffect != null && this.dropTargetEffect.isValid()) {
            int oldStroke = graphicContext.getLineWidth();
            graphicContext.setLineWidth(2);
            GalleryItem elementGroups = this.dropTargetEffect.getItem().getParentItem();
            int index = ArrayUtils.indexOf((Object[])elementGroups.getItems(), (Object)this.dropTargetEffect.getItem());
            Rectangle itemBounds = this.dropTargetEffect.getItem().getBounds();
            if (this.dropTargetEffect.isPlacedAfter()) {
                if (index == elementGroups.getItemCount() - 1) {
                    int xAxis = itemBounds.x + itemBounds.width;
                    graphicContext.drawLine(xAxis, itemBounds.y, xAxis, itemBounds.y + itemBounds.height);
                } else {
                    GalleryItem nextItem = elementGroups.getItem(index + 1);
                    Rectangle nextItemBounds = nextItem.getBounds();
                    if (nextItemBounds.y != itemBounds.y) {
                        int xAxis = itemBounds.x + itemBounds.width;
                        graphicContext.drawLine(xAxis, itemBounds.y, xAxis, itemBounds.y + itemBounds.height);
                    } else {
                        DraggableGalleryItemRenderer itemRender = (DraggableGalleryItemRenderer)this.gallery.getItemRenderer();
                        Rectangle image1Bounds = itemRender.imagesBounds.get(this.dropTargetEffect.getItem());
                        Rectangle image2Bounds = itemRender.imagesBounds.get(nextItem);
                        int mX = image1Bounds.x + image1Bounds.width;
                        int mWidth = image2Bounds.x - mX;
                        int drawLineX = mX + mWidth / 2 - graphicContext.getLineWidth() / 2;
                        graphicContext.drawLine(drawLineX, itemBounds.y, drawLineX, itemBounds.y + itemBounds.height);
                    }
                }
            } else if (index == 0) {
                graphicContext.drawLine(itemBounds.x, itemBounds.y, itemBounds.x, itemBounds.y + itemBounds.height);
            } else {
                GalleryItem previousItem = elementGroups.getItem(index - 1);
                Rectangle previousItemBounds = previousItem.getBounds();
                if (previousItemBounds.y != itemBounds.y) {
                    graphicContext.drawLine(itemBounds.x, itemBounds.y, itemBounds.x, itemBounds.y + itemBounds.height);
                } else {
                    DraggableGalleryItemRenderer itemRender = (DraggableGalleryItemRenderer)this.gallery.getItemRenderer();
                    Rectangle image1Bounds = itemRender.imagesBounds.get(previousItem);
                    Rectangle image2Bounds = itemRender.imagesBounds.get(this.dropTargetEffect.getItem());
                    int mX = image1Bounds.x + image1Bounds.width;
                    int mWidth = image2Bounds.x - mX;
                    int drawLineX = mX + mWidth / 2 - graphicContext.getLineWidth() / 2;
                    graphicContext.drawLine(drawLineX, itemBounds.y, drawLineX, itemBounds.y + itemBounds.height);
                }
            }
            graphicContext.setLineWidth(oldStroke);
        }
    }

    public void setDropTargetLocation(DropEffectLocation location) {
        this.dropTargetEffect = location;
    }
}

