/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.controls.render;

import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class PageDragSourceEffect
extends DragSourceEffect {
    private Gallery g = null;
    private int width;
    private int height;
    private Image lastImage = null;

    public PageDragSourceEffect(Gallery gallery, int width, int height) {
        super((Control)gallery);
        this.g = gallery;
        this.width = width;
        this.height = height;
    }

    public void dragStart(DragSourceEvent event) {
        Image img;
        GalleryItem[] selection = this.g.getSelection();
        if (selection != null && selection.length > 0 && (img = selection[0].getImage()) != null) {
            event.image = this.scaleImage(img);
        }
    }

    private Image scaleImage(Image sourceImage) {
        Image scaled;
        this.disposeImage();
        int newWidth = 0;
        int newHeight = 0;
        int srcWidth = sourceImage.getImageData().width;
        int srcHeight = sourceImage.getImageData().height;
        if (srcWidth > srcHeight) {
            newWidth = this.width;
            newHeight = newWidth * srcHeight / srcWidth;
        } else {
            newHeight = this.height;
            newWidth = newHeight * srcWidth / srcHeight;
        }
        this.lastImage = scaled = new Image((Device)UIUtils.getDisplay(), sourceImage.getImageData().scaledTo(newWidth, newHeight));
        return this.lastImage;
    }

    public void disposeImage() {
        if (this.lastImage != null) {
            this.lastImage.dispose();
            this.lastImage = null;
        }
    }
}

