/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.model;

import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import java.beans.PropertyChangeEvent;
import java.util.List;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MReportPartContainer
extends APropertyNode {
    public static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CONTAINER_TYPE = "property_partcontainer_type";
    public static final String JSSPROPERTY_GROUPLABEL_PREFIX = "com.jaspersoft.studio.book.group.";
    public static final String JSSPROPERTY_GROUPLABEL_HEADER_POSTFIX = ".header";
    public static final String JSSPROPERTY_GROUPLABEL_FOOTER_POSTFIX = ".footer";
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;

    public MReportPartContainer(ANode parent, JRSection jrsection, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrsection);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("reportpartcontainer");
        }
        return iconDescriptor;
    }

    public Object getPropertyValue(Object id) {
        JRDesignSection jrsection = this.getValue();
        if (jrsection != null) {
            if ("parts".equals(id)) {
                return jrsection.getPartsList();
            }
            if (PROPERTY_CONTAINER_TYPE.equals(id)) {
                JROrigin origin = jrsection.getOrigin();
                if (origin != null) {
                    return origin.getBandTypeValue();
                }
                return BandTypeEnum.UNKNOWN;
            }
        }
        return null;
    }

    public JRDesignSection getValue() {
        return (JRDesignSection)super.getValue();
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignSection jrsection = this.getValue();
        if (jrsection != null && "parts".equals(id)) {
            JRPart[] parts;
            JRPart[] jRPartArray = parts = jrsection.getParts();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                JRPart p = jRPartArray[n2];
                jrsection.removePart(p);
                ++n2;
            }
            List newParts = (List)value;
            for (JRPart p : newParts) {
                jrsection.addPart(p);
            }
        }
    }

    public ImageDescriptor getImagePath() {
        return MReportPartContainer.getIconDescriptor().getIcon16();
    }

    public boolean isDetail() {
        BandTypeEnum type = (BandTypeEnum)this.getPropertyValue(PROPERTY_CONTAINER_TYPE);
        return BandTypeEnum.DETAIL.equals((Object)type);
    }

    public String getDisplayText() {
        if (this.isDetail()) {
            return "Content";
        }
        return "<UNDEFINED>";
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("parts")) {
            if (evt.getNewValue() == null && evt.getOldValue() != null) {
                for (INode node : this.getChildren()) {
                    if (node.getValue() != evt.getOldValue()) continue;
                    this.removeChild((ANode)node);
                    break;
                }
            }
            if (evt.getNewValue() != null && evt.getOldValue() == null) {
                JRDesignSection jrsection = this.getValue();
                int partIndex = jrsection.getPartsList().indexOf(evt.getNewValue());
                new MReportPart((ANode)this, (JRPart)evt.getNewValue(), partIndex);
            }
        }
        super.propertyChange(evt);
    }

    public Object getAdapter(Class adapter) {
        if (ExpressionContext.class.equals((Object)adapter)) {
            return ExpressionEditorSupportUtil.getReportExpressionContext();
        }
        return super.getAdapter(adapter);
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
    }
}

