/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.model.commands;

import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.gef.commands.Command;

public class RemoveChildrenCommand
extends Command {
    private MReportPart partToRemove = null;
    private MReportPartContainer container = null;
    private int oldIndex = -1;

    public RemoveChildrenCommand(MReportPartContainer container, MReportPart partToRemove) {
        this.container = container;
        this.partToRemove = partToRemove;
    }

    public boolean canExecute() {
        return this.partToRemove != null && this.container != null;
    }

    public void execute() {
        System.out.println("Executing remove part " + (Object)((Object)this) + " " + this.partToRemove.getValue().getUUID());
        this.oldIndex = this.container.getValue().getPartsList().indexOf(this.partToRemove.getValue());
        this.container.getValue().removePart((JRPart)this.partToRemove.getValue());
    }

    public boolean canUndo() {
        return this.oldIndex > -1;
    }

    public void undo() {
        JRDesignSection section = this.container.getValue();
        if (section.getPartsList().size() <= this.oldIndex) {
            section.addPart((JRPart)this.partToRemove.getValue());
        } else {
            section.addPart(this.oldIndex, (JRPart)this.partToRemove.getValue());
        }
    }
}

