/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.mongodb;

import com.jaspersoft.mongodb.adapter.MongoDbDataAdapter;
import com.jaspersoft.mongodb.adapter.MongoDbDataAdapterImpl;
import com.jaspersoft.mongodb.adapter.MongoDbDataAdapterService;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.mongodb.Activator;
import com.jaspersoft.studio.data.mongodb.MongoDBCreator;
import com.jaspersoft.studio.data.mongodb.MongoDbDataAdapterDescriptor;
import com.jaspersoft.studio.data.mongodb.messages.Messages;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.swt.graphics.Image;

public class MongoDbDataAdapterFactory
implements DataAdapterFactory {
    public DataAdapterDescriptor createDataAdapter() {
        MongoDbDataAdapterDescriptor descriptor = new MongoDbDataAdapterDescriptor();
        descriptor.getDataAdapter().setMongoURI("mongodb://HOST:27017/DB_NAME");
        descriptor.getDataAdapter().setUsername("");
        descriptor.getDataAdapter().setPassword("");
        return descriptor;
    }

    public String getDataAdapterClassName() {
        return MongoDbDataAdapterImpl.class.getName();
    }

    public String getLabel() {
        return Messages.MongoDbDataAdapterFactory_label;
    }

    public String getDescription() {
        return Messages.MongoDbDataAdapterFactory_description;
    }

    public Image getIcon(int size) {
        if (size == 16) {
            return Activator.getDefault().getImage("icons/mongodb.png");
        }
        return null;
    }

    public DataAdapterService createDataAdapterService(JasperReportsContext jasperReportsContext, DataAdapter dataAdapter) {
        if (dataAdapter instanceof MongoDbDataAdapter) {
            return new MongoDbDataAdapterService(jasperReportsContext, (MongoDbDataAdapter)dataAdapter);
        }
        return null;
    }

    public IDataAdapterCreator iReportConverter() {
        return new MongoDBCreator();
    }

    public boolean isDeprecated() {
        return false;
    }
}

