/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.barcode.command;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.barcode.messages.Messages;
import com.jaspersoft.studio.components.barcode.model.MBarcode;
import com.jaspersoft.studio.components.barcode.model.MBarcodeBarbecue;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MCodabar;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MCode128;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MCode39;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MDataMatrix;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MEAN128;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MEAN13;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MEAN8;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MInterleaved2Of5;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MPDF417;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MPOSTNET;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MQRCode;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MRoyalMail;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MUPCA;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MUPCE;
import com.jaspersoft.studio.components.barcode.model.barcode4j.MUSPSIntelligent;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BarcodeWizardPage
extends JSSHelpWizardPage {
    private MBarcode barcode = new MCodabar();
    private String bbcCode = null;
    private String b4jCode = null;

    public MBarcode getBarcode() {
        return this.barcode;
    }

    protected BarcodeWizardPage() {
        super("barcodepage");
        this.setTitle(Messages.common_barcode_wizard);
        this.setDescription(String.valueOf(Messages.BarcodeWizardPage_barcode_wizard_description_a) + Messages.BarcodeWizardPage_barcode_wizard_description_b);
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SELECT_BARCODE;
    }

    public void dispose() {
        if (this.b4jCode != null) {
            if (this.b4jCode.equals("Codabar")) {
                this.barcode = new MCodabar();
            } else if (this.b4jCode.equals("Code128")) {
                this.barcode = new MCode128();
            } else if (this.b4jCode.equals("Code39")) {
                this.barcode = new MCode39();
            } else if (this.b4jCode.equals("EAN128")) {
                this.barcode = new MEAN128();
            } else if (this.b4jCode.equals("EAN13")) {
                this.barcode = new MEAN13();
            } else if (this.b4jCode.equals("EAN8")) {
                this.barcode = new MEAN8();
            } else if (this.b4jCode.equals("PDF417")) {
                this.barcode = new MPDF417();
            } else if (this.b4jCode.equals("DataMatrix")) {
                this.barcode = new MDataMatrix();
            } else if (this.b4jCode.equals("Int2of5")) {
                this.barcode = new MInterleaved2Of5();
            } else if (this.b4jCode.equals("RoyalMailCustomer")) {
                this.barcode = new MRoyalMail();
            } else if (this.b4jCode.equals("UPCA")) {
                this.barcode = new MUPCA();
            } else if (this.b4jCode.equals("UPCE")) {
                this.barcode = new MUPCE();
            } else if (this.b4jCode.equals("USPS")) {
                this.barcode = new MUSPSIntelligent();
            } else if (this.b4jCode.equals("PostNet")) {
                this.barcode = new MPOSTNET();
            } else if (this.b4jCode.equals("QRCode")) {
                this.barcode = new MQRCode();
            }
        } else if (this.bbcCode != null) {
            this.barcode = new MBarcodeBarbecue();
            JRDesignComponentElement de = (JRDesignComponentElement)this.barcode.createJRElement(null);
            StandardBarbecueComponent sbc = (StandardBarbecueComponent)de.getComponent();
            sbc.setType(this.bbcCode);
            JRDesignExpression expr = (JRDesignExpression)sbc.getCodeExpression();
            if (this.bbcCode.equals("Bookland")) {
                expr.setText("\"0123456789\"");
                sbc.setCodeExpression((JRExpression)expr);
            }
            if (this.bbcCode.equals("EAN13")) {
                expr.setText("\"012345678900\"");
                sbc.setCodeExpression((JRExpression)expr);
            }
            if (this.bbcCode.equals("RandomWeightUPCA")) {
                expr.setText("\"01234567890\"");
                sbc.setCodeExpression((JRExpression)expr);
            }
            if (this.bbcCode.equals("UPCA")) {
                expr.setText("\"01234567890\"");
                sbc.setCodeExpression((JRExpression)expr);
            }
            if (this.bbcCode.equals("UCC128")) {
                sbc.setApplicationIdentifierExpression((JRExpression)new JRDesignExpression("\"00\""));
            }
            this.barcode = new MBarcodeBarbecue(null, de, -1);
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.BarcodeWizardPage_barbecue_types);
        lbl = new Label(composite, 0);
        lbl.setText(Messages.BarcodeWizardPage_barcode4j_types);
        final Table table = new Table(composite, 68100);
        GridData gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        column[0].setText(Messages.BarcodeWizardPage_name);
        column[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        table.setLayout((Layout)tlayout);
        this.fillTableBarbecue(table);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (table.getSelectionCount() == 1) {
                    // empty if block
                }
            }
        });
        final Table table2 = new Table(composite, 68100);
        gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 250;
        table2.setLayoutData((Object)gd);
        table2.setHeaderVisible(false);
        table2.setLinesVisible(true);
        TableColumn[] column2 = new TableColumn[]{new TableColumn(table2, 0)};
        column2[0].setText(Messages.BarcodeWizardPage_name);
        column2[0].pack();
        tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        table2.setLayout((Layout)tlayout);
        table2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (table2.getSelectionCount() == 1) {
                    // empty if block
                }
            }
        });
        this.fillTableb4j(table2);
        table2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] sel = table2.getSelection();
                if (sel != null && sel.length > 0) {
                    BarcodeWizardPage.this.b4jCode = sel[0].getText();
                    table.setSelection(-1);
                    BarcodeWizardPage.this.bbcCode = null;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] sel = table.getSelection();
                if (sel != null && sel.length > 0) {
                    BarcodeWizardPage.this.bbcCode = sel[0].getText();
                    table2.setSelection(-1);
                    BarcodeWizardPage.this.b4jCode = null;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fillTableb4j(Table table) {
        table.setRedraw(false);
        String[] items = new String[]{"Codabar", "Code128", "Code39", "EAN128", "EAN13", "EAN8", "PDF417", "PostNet", "DataMatrix", "Int2of5", "RoyalMailCustomer", "UPCA", "UPCE", "USPS", "QRCode"};
        int i = 0;
        while (i < items.length) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(items[i]);
            ti.setImage(Activator.getDefault().getImage("/icons/resources/" + items[i] + ".png"));
            ++i;
        }
        table.setRedraw(true);
    }

    private void fillTableBarbecue(Table table) {
        table.setRedraw(false);
        String[] items = new String[]{"2of7", "3of9", "Bookland", "Codabar", "Code128", "Code128A", "Code128B", "Code128C", "Code39", "Code39 (Extended)", "EAN128", "EAN13", "GlobalTradeItemNumber", "Int2of5", "Monarch", "NW7", "PDF417", "PostNet", "RandomWeightUPCA", "SCC14ShippingCode", "ShipmentIdentificationNumber", "SSCC18", "Std2of5", "UCC128", "UPCA", "USD3", "USD4", "USPS"};
        int i = 0;
        while (i < items.length) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(items[i]);
            if (items[i].equals("Code39 (Extended)")) {
                ti.setImage(Activator.getDefault().getImage("/icons/resources/Code39.png"));
            } else {
                ti.setImage(Activator.getDefault().getImage("/icons/resources/" + items[i] + ".png"));
            }
            ++i;
        }
        table.setRedraw(true);
    }
}

