/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.barcode.figure;

import com.jaspersoft.studio.jasper.AComponentDesignConverter;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.components.barcode4j.BarcodeDesignEvaluator;
import net.sf.jasperreports.components.barcode4j.QRCodeComponent;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.renderers.Renderable;

public class LazyBarcodeDesignConverter
extends AComponentDesignConverter {
    public String getComponentName() {
        return "QRCode";
    }

    public LazyBarcodeDesignConverter() {
        super("net/sf/jasperreports/engine/images/component-16.png");
    }

    protected OnErrorTypeEnum getOnErrorType(Component cmp) {
        return OnErrorTypeEnum.BLANK;
    }

    protected String getEKey(JRComponentElement element) {
        QRCodeComponent map = (QRCodeComponent)element.getComponent();
        String ekey = "" + element.getUUID() + element.getWidth() + element.getHeight();
        if (map.getCodeExpression() != null) {
            ekey = String.valueOf(ekey) + map.getCodeExpression().getText();
        }
        if (map.getErrorCorrectionLevel() != null) {
            ekey = String.valueOf(ekey) + map.getErrorCorrectionLevel();
        }
        if (map.getMargin() != null) {
            ekey = String.valueOf(ekey) + map.getMargin();
        }
        return ekey;
    }

    protected Renderable doRenderable(ReportConverter reportConverter, JRComponentElement element, Component cmp, String expr, JasperReportsConfiguration jrContext, KeyValue<String, Long> kv) throws JRException {
        try {
            JasperReportsContext jcontext = reportConverter.getJasperReportsContext();
            BarcodeDesignEvaluator evaluator = new BarcodeDesignEvaluator(jcontext, element, reportConverter.getDefaultStyleProvider());
            return evaluator.evaluateImage();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

