/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.barcode.model;

import com.jaspersoft.studio.components.barcode.BarcodeNodeIconDescriptor;
import com.jaspersoft.studio.components.barcode.messages.Messages;
import com.jaspersoft.studio.components.barcode.model.MBarcode;
import com.jaspersoft.studio.components.barcode.property.JSSPixelBarcodeSizeValidator;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IRotatable;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MBarcodeBarbecue
extends MBarcode
implements IRotatable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<RotationEnum> rotationD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new BarcodeNodeIconDescriptor("barcode");
        }
        return iconDescriptor;
    }

    public MBarcodeBarbecue() {
    }

    public MBarcodeBarbecue(ANode parent, JRDesignComponentElement jrBarcode, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrBarcode);
    }

    public JRDesignComponentElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignComponentElement el = new JRDesignComponentElement((JRDefaultStyleProvider)jasperDesign);
        StandardBarbecueComponent component = new StandardBarbecueComponent();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("\"1234\"");
        component.setCodeExpression((JRExpression)exp);
        el.setComponent((Component)component);
        el.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "barbecue"));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(((Object)((Object)this)).getClass(), (JRElement)el);
        }
        return el;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MBarcodeBarbecue.getIconDescriptor().getTitle() : p;
    }

    public ImageDescriptor getImagePath() {
        return MBarcodeBarbecue.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MBarcodeBarbecue.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> properties = super.generateGraphicalProperties();
        properties.add("barWidth");
        properties.add("barHeight");
        properties.add("type");
        properties.add("rotation");
        properties.add("drawText");
        return properties;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        PixelPropertyDescriptor widthD = new PixelPropertyDescriptor((Object)"barWidth", Messages.MBarcodeBarbecue_bar_width);
        widthD.setValidator((ICellEditorValidator)new JSSPixelBarcodeSizeValidator());
        widthD.setDescription(Messages.MBarcodeBarbecue_bar_width_description);
        desc.add((IPropertyDescriptor)widthD);
        PixelPropertyDescriptor heightD = new PixelPropertyDescriptor((Object)"barHeight", Messages.MBarcodeBarbecue_bar_height);
        heightD.setValidator((ICellEditorValidator)new JSSPixelBarcodeSizeValidator());
        heightD.setDescription(Messages.MBarcodeBarbecue_bar_height_description);
        desc.add((IPropertyDescriptor)heightD);
        JRExpressionPropertyDescriptor appIDexprD = new JRExpressionPropertyDescriptor((Object)"applicationIdentifierExpression", Messages.MBarcodeBarbecue_application_identifier_expression);
        appIDexprD.setDescription(Messages.MBarcodeBarbecue_application_identifier_expression_description);
        desc.add((IPropertyDescriptor)appIDexprD);
        RComboBoxPropertyDescriptor typeD = new RComboBoxPropertyDescriptor((Object)"type", Messages.MBarcodeBarbecue_type, new String[]{"2of7", "3of9", "Bookland", "Codabar", "Code128", "Code128A", "Code128B", "Code128C", "Code39", "Code39 (Extended)", "EAN128", "EAN13", "GlobalTradeItemNumber", "Int2of5", "Monarch", "NW7", "PDF417", "PostNet", "RandomWeightUPCA", "SCC14ShippingCode", "ShipmentIdentificationNumber", "SSCC18", "Std2of5", "UCC128", "UPCA", "USD3", "USD4", "USPS"});
        typeD.setDescription(Messages.MBarcodeBarbecue_type_description);
        desc.add((IPropertyDescriptor)typeD);
        CheckBoxPropertyDescriptor checksumRequiredD = new CheckBoxPropertyDescriptor((Object)"checksumRequired", Messages.MBarcodeBarbecue_checksum_required);
        checksumRequiredD.setDescription(Messages.MBarcodeBarbecue_checksum_required_description);
        desc.add((IPropertyDescriptor)checksumRequiredD);
        CheckBoxPropertyDescriptor drawTextD = new CheckBoxPropertyDescriptor((Object)"drawText", Messages.MBarcodeBarbecue_draw_text);
        drawTextD.setDescription(Messages.MBarcodeBarbecue_draw_text_description);
        desc.add((IPropertyDescriptor)drawTextD);
        rotationD = new NamedEnumPropertyDescriptor((Object)"rotation", Messages.MBarcodeBarbecue_rotation, (Enum)RotationEnum.LEFT, NullEnum.INHERITED);
        rotationD.setDescription(Messages.MBarcodeBarbecue_rotation_description);
        desc.add((IPropertyDescriptor)rotationD);
        rotationD.setCategory(Messages.common_properties_category);
        widthD.setCategory(Messages.common_properties_category);
        typeD.setCategory(Messages.common_properties_category);
        drawTextD.setCategory(Messages.common_properties_category);
        checksumRequiredD.setCategory(Messages.common_properties_category);
        heightD.setCategory(Messages.common_properties_category);
        appIDexprD.setCategory(Messages.common_properties_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("evaluationTime", new DefaultValue((Object)EvaluationTimeEnum.NOW, false));
        defaultsMap.put("rotation", new DefaultValue(null, true));
        defaultsMap.put("barWidth", new DefaultValue(true));
        defaultsMap.put("barHeight", new DefaultValue(true));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        StandardBarbecueComponent barbecueComponent = (StandardBarbecueComponent)jrElement.getComponent();
        if (id.equals("evaluationTime")) {
            return barbecueComponent.getEvaluationTimeValue();
        }
        if (id.equals("evaluationGroup")) {
            return barbecueComponent.getEvaluationGroup();
        }
        if (id.equals("checksumRequired")) {
            return new Boolean(barbecueComponent.isChecksumRequired());
        }
        if (id.equals("drawText")) {
            return new Boolean(barbecueComponent.isDrawText());
        }
        if (id.equals("type")) {
            return barbecueComponent.getType();
        }
        if (id.equals("barHeight")) {
            return barbecueComponent.getBarHeight();
        }
        if (id.equals("barWidth")) {
            return barbecueComponent.getBarWidth();
        }
        if (id.equals("codeExpression")) {
            return ExprUtil.getExpression((JRExpression)barbecueComponent.getCodeExpression());
        }
        if (id.equals("rotation")) {
            return rotationD.getIntValue((Enum)barbecueComponent.getOwnRotation());
        }
        if (id.equals("applicationIdentifierExpression")) {
            return ExprUtil.getExpression((JRExpression)barbecueComponent.getApplicationIdentifierExpression());
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        StandardBarbecueComponent barbecueComponent = (StandardBarbecueComponent)jrElement.getComponent();
        if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            barbecueComponent.setEvaluationTimeValue(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                barbecueComponent.setEvaluationGroup(null);
            }
        } else if (id.equals("evaluationGroup")) {
            barbecueComponent.setEvaluationGroup(ModelUtils.getGroupNameForProperty((Object)value));
        } else if (id.equals("checksumRequired")) {
            barbecueComponent.setChecksumRequired(((Boolean)value).booleanValue());
        } else if (id.equals("drawText")) {
            barbecueComponent.setDrawText(((Boolean)value).booleanValue());
        } else if (id.equals("type")) {
            barbecueComponent.setType((String)value);
        } else if (id.equals("rotation")) {
            barbecueComponent.setRotation((RotationEnum)rotationD.getEnumValue(value));
        } else if (id.equals("barHeight")) {
            Integer intv = (Integer)value;
            if (intv != null) {
                intv = Math.abs(intv);
            }
            barbecueComponent.setBarHeight(intv);
        } else if (id.equals("barWidth")) {
            Integer intv = (Integer)value;
            if (intv != null) {
                intv = Math.abs(intv);
            }
            barbecueComponent.setBarWidth((Integer)value);
        } else if (id.equals("codeExpression")) {
            barbecueComponent.setCodeExpression(ExprUtil.setValues((JRExpression)barbecueComponent.getCodeExpression(), (Object)value, null));
        } else if (id.equals("applicationIdentifierExpression")) {
            barbecueComponent.setApplicationIdentifierExpression(ExprUtil.setValues((JRExpression)barbecueComponent.getApplicationIdentifierExpression(), (Object)value, null));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignComponentElement jrSourceElement = (JRDesignComponentElement)this.getValue();
        StandardBarbecueComponent jrSourceCode = (StandardBarbecueComponent)jrSourceElement.getComponent();
        JRDesignComponentElement jrTargetElement = (JRDesignComponentElement)target;
        StandardBarbecueComponent jrTargetCode = (StandardBarbecueComponent)jrTargetElement.getComponent();
        jrTargetCode.setChecksumRequired(jrSourceCode.isChecksumRequired());
        jrTargetCode.setDrawText(jrSourceCode.isDrawText());
        jrTargetCode.setType(this.getStringClone(jrSourceCode.getType()));
        jrTargetCode.setBarHeight(jrSourceCode.getBarHeight());
        jrTargetCode.setBarWidth(jrSourceCode.getBarWidth());
        jrTargetCode.setRotation(jrSourceCode.getOwnRotation());
    }
}

