/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.barcode.model.barcode4j;

import com.jaspersoft.studio.components.barcode.BarcodeNodeIconDescriptor;
import com.jaspersoft.studio.components.barcode.messages.Messages;
import com.jaspersoft.studio.components.barcode.model.MBarcode;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptors.DoublePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.barcode4j.ErrorCorrectionLevelEnum;
import net.sf.jasperreports.components.barcode4j.QRCodeComponent;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MQRCode
extends MBarcode {
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<ErrorCorrectionLevelEnum> errLevelD;
    private static IIconDescriptor iconDescriptor;

    public MQRCode() {
    }

    public MQRCode(ANode parent, JRDesignComponentElement jrBarcode, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrBarcode);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new BarcodeNodeIconDescriptor("barcode");
        }
        return iconDescriptor;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MQRCode.getIconDescriptor().getTitle() : p;
    }

    public ImageDescriptor getImagePath() {
        return MQRCode.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MQRCode.getIconDescriptor().getToolTip();
    }

    public JRDesignComponentElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignComponentElement el = new JRDesignComponentElement();
        QRCodeComponent component = new QRCodeComponent();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("\"123456789\"");
        component.setCodeExpression((JRExpression)exp);
        el.setComponent((Component)component);
        el.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "QRCode"));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(((Object)((Object)this)).getClass(), (JRElement)el);
        }
        return el;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        errLevelD = new NamedEnumPropertyDescriptor((Object)"errorCorrectionLevel", Messages.MQRCode_2, (Enum)ErrorCorrectionLevelEnum.H, NullEnum.NOTNULL);
        errLevelD.setDescription(Messages.MQRCode_3);
        errLevelD.setCategory(Messages.MQRCode_4);
        desc.add((IPropertyDescriptor)errLevelD);
        PixelPropertyDescriptor margind = new PixelPropertyDescriptor((Object)"margin", Messages.MQRCode_5);
        margind.setDescription(Messages.MQRCode_6);
        margind.setCategory("QR Code");
        desc.add((IPropertyDescriptor)margind);
        DoublePropertyDescriptor vertQuietZoneD = new DoublePropertyDescriptor((Object)"verticalQuietZone", Messages.MBarcode4j_vertical_quiet_zone);
        vertQuietZoneD.setDescription(Messages.MBarcode4j_vertical_quiet_zone_description);
        desc.add((IPropertyDescriptor)vertQuietZoneD);
        vertQuietZoneD.setCategory(Messages.common_properties_category);
        IntegerPropertyDescriptor qrVersion = new IntegerPropertyDescriptor((Object)"qrVersion", Messages.MQRCode_0);
        qrVersion.setDescription(Messages.MQRCode_desc);
        qrVersion.setBounds(1, 40);
        desc.add((IPropertyDescriptor)qrVersion);
        qrVersion.setCategory(Messages.common_properties_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("errorCorrectionLevel", new DefaultValue((Object)ErrorCorrectionLevelEnum.H, false));
        defaultsMap.put("margin", new DefaultValue((Object)new Integer(1), false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        QRCodeComponent qrCodeComponent = (QRCodeComponent)jrElement.getComponent();
        if (id.equals("errorCorrectionLevel")) {
            return errLevelD.getIntValue((Enum)qrCodeComponent.getErrorCorrectionLevel());
        }
        if (id.equals("margin")) {
            return qrCodeComponent.getMargin();
        }
        if (id.equals("qrVersion")) {
            return qrCodeComponent.getQrVersion();
        }
        if (id.equals("codeExpression")) {
            return ExprUtil.getExpression((JRExpression)qrCodeComponent.getCodeExpression());
        }
        if (id.equals("evaluationTime")) {
            return qrCodeComponent.getEvaluationTimeValue();
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        QRCodeComponent qrcodeComponent = (QRCodeComponent)jrElement.getComponent();
        if (id.equals("errorCorrectionLevel")) {
            qrcodeComponent.setErrorCorrectionLevel((ErrorCorrectionLevelEnum)errLevelD.getEnumValue(value));
        } else if (id.equals("margin")) {
            qrcodeComponent.setMargin((Integer)value);
        } else if (id.equals("qrVersion")) {
            qrcodeComponent.setQrVersion((Integer)value);
        } else if (id.equals("codeExpression")) {
            qrcodeComponent.setCodeExpression(ExprUtil.setValues((JRExpression)qrcodeComponent.getCodeExpression(), (Object)value, null));
        } else if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            qrcodeComponent.setEvaluationTimeValue(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                qrcodeComponent.setEvaluationGroup(null);
            }
        }
        super.setPropertyValue(id, value);
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignComponentElement jrSourceElement = (JRDesignComponentElement)this.getValue();
        QRCodeComponent jrSourceBarcode = (QRCodeComponent)jrSourceElement.getComponent();
        JRDesignComponentElement jrTargetElement = (JRDesignComponentElement)target;
        QRCodeComponent jrTargetBarcode = (QRCodeComponent)jrTargetElement.getComponent();
        jrTargetBarcode.setMargin(jrSourceBarcode.getMargin());
        jrTargetBarcode.setQrVersion(jrSourceBarcode.getQrVersion());
        jrTargetBarcode.setErrorCorrectionLevel(jrSourceBarcode.getErrorCorrectionLevel());
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> properties = super.generateGraphicalProperties();
        properties.add("errorCorrectionLevel");
        properties.add("margin");
        return properties;
    }
}

