/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.editor;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.gef.ui.actions.RZoomComboContributionItem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class JrctxEditorContributor
extends MultiPageEditorActionBarContributor {
    private List<String> globalActionKeys = new ArrayList<String>();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();
    private ActionRegistry registry = new ActionRegistry();
    private RZoomComboContributionItem zoomCombo;
    private TextEditorActionContributor textEditorContributor = null;

    public JrctxEditorContributor() {
        this.createActions();
    }

    public void init(IActionBars bars) {
        this.buildActions();
        this.declareGlobalActionKeys();
        super.init(bars);
    }

    protected void buildActions() {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        RetargetAction raction = new RetargetAction("EXPORTCHARTHEMEJAR", "Export Chart Theme jar");
        raction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/charttheme_export-16.png"));
        this.addRetargetAction(raction);
    }

    protected void addRetargetAction(RetargetAction action) {
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
        this.addGlobalActionKey(action.getId());
    }

    protected void addGlobalActionKey(String key) {
        this.globalActionKeys.add(key);
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected ActionRegistry getActionRegistry() {
        return this.registry;
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.COPY.getId());
        this.addGlobalActionKey(ActionFactory.PASTE.getId());
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
        this.addGlobalActionKey(ActionFactory.DELETE.getId());
    }

    protected IAction getAction(String id) {
        return this.getActionRegistry().getAction((Object)id);
    }

    public void setActivePage(IEditorPart activeEditor) {
        CommonToolbarHandler.clearToolbars((IActionBars)this.getActionBars());
        IActionBars bars = this.getActionBars();
        this.removeZoom(bars.getToolBarManager());
        bars.clearGlobalActionHandlers();
        if (activeEditor instanceof ITextEditor) {
            if (this.textEditorContributor == null) {
                this.textEditorContributor = new TextEditorActionContributor();
                this.textEditorContributor.init(bars, activeEditor.getSite().getPage());
            }
            this.textEditorContributor.setActiveEditor(activeEditor);
        } else if (activeEditor instanceof IGraphicalEditor) {
            ActionRegistry registry;
            GraphicalViewer graphicalViewer;
            ZoomManager property;
            this.addZoom(bars.getToolBarManager());
            if (activeEditor instanceof IGraphicalEditor && (property = (ZoomManager)(graphicalViewer = ((IGraphicalEditor)activeEditor).getGraphicalViewer()).getProperty(ZoomManager.class.toString())) != null) {
                this.zoomCombo.setZoomManager(property);
            }
            if ((registry = (ActionRegistry)activeEditor.getAdapter(ActionRegistry.class)) != null) {
                for (String id : this.globalActionKeys) {
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                }
            }
        }
        bars.updateActionBars();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    private void createActions() {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction(ActionFactory.UNDO.getId()));
        tbm.add(this.getAction(ActionFactory.REDO.getId()));
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.getAction("EXPORTCHARTHEMEJAR"));
        this.addZoom(tbm);
    }

    private void addZoom(IToolBarManager tbm) {
        tbm.add(this.getAction("org.eclipse.gef.zoom_in"));
        tbm.add(this.getAction("org.eclipse.gef.zoom_out"));
        if (this.zoomCombo == null) {
            this.zoomCombo = new RZoomComboContributionItem();
        }
        this.zoomCombo.setEnabled(true);
        tbm.add((IContributionItem)this.zoomCombo);
        tbm.update(true);
    }

    private void removeZoom(IToolBarManager tbm) {
        tbm.remove("org.eclipse.gef.zoom_in");
        tbm.remove("org.eclipse.gef.zoom_out");
        tbm.remove(this.zoomCombo.getId());
        this.zoomCombo.setEnabled(false);
        tbm.update(true);
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        MenuManager viewMenu = new MenuManager(Messages.JrxmlEditorContributor_view);
        viewMenu.add(this.getAction("org.eclipse.gef.zoom_in"));
        viewMenu.add(this.getAction("org.eclipse.gef.zoom_out"));
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        if (this.textEditorContributor != null) {
            this.textEditorContributor.contributeToStatusLine(statusLineManager);
        }
        statusLineManager.setMessage("");
    }

    public void dispose() {
        int i = 0;
        while (i < this.retargetActions.size()) {
            RetargetAction action = this.retargetActions.get(i);
            this.getPage().removePartListener((IPartListener)action);
            action.dispose();
            ++i;
        }
        this.registry.dispose();
        this.retargetActions = null;
        this.registry = null;
    }
}

