/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import java.util.List;
import net.sf.jasperreports.engine.NamedChartCustomizer;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class ChartSetValueCommandProvider
implements ISetValueCommandProvider {
    public static ChartSetValueCommandProvider INSTANCE = new ChartSetValueCommandProvider();

    public Command getSetValueCommand(IPropertySource source, String commandName, Object propertyId, Object newVal) {
        if (this.isCustomizerProperty(propertyId)) {
            CustomizerPropertyExpressionsDTO currentDTO = null;
            currentDTO = newVal instanceof CustomizerPropertyExpressionsDTO ? (CustomizerPropertyExpressionsDTO)((Object)newVal) : new CustomizerPropertyExpressionsDTO((PropertyExpressionsDTO)newVal, (MChart)source);
            JSSCompoundCommand command = new JSSCompoundCommand("Set Chart Customizers", (ANode)source);
            SetValueCommand setDTOCommand = new SetValueCommand();
            setDTOCommand.setTarget(source);
            setDTOCommand.setPropertyId(propertyId);
            setDTOCommand.setPropertyValue((Object)currentDTO);
            command.add((Command)setDTOCommand);
            List<ChartCustomizerDefinition> definedCustmizers = currentDTO.getDefinedCustomizers();
            if (definedCustmizers.isEmpty()) {
                SetValueCommand setCustomizer = new SetValueCommand();
                setCustomizer.setPropertyId((Object)"customizerClass");
                setCustomizer.setPropertyValue(null);
                setCustomizer.setTarget((IPropertySource)((APropertyNode)source));
                command.add((Command)setCustomizer);
            } else if (definedCustmizers.size() == 1) {
                ChartCustomizerDefinition definedCustomizer = definedCustmizers.get(0);
                if (this.isConfigurableCustmizer(definedCustomizer)) {
                    SetValueCommand setCustomizer = new SetValueCommand();
                    setCustomizer.setPropertyId((Object)"customizerClass");
                    setCustomizer.setPropertyValue(null);
                    setCustomizer.setTarget((IPropertySource)((APropertyNode)source));
                    command.add((Command)setCustomizer);
                    if (!definedCustomizer.isPropertiesCustomizer()) {
                        currentDTO.createCustomizerEntry(definedCustomizer.getCustomizerClass(), true);
                    }
                } else {
                    SetValueCommand setCustomizer = new SetValueCommand();
                    setCustomizer.setPropertyId((Object)"customizerClass");
                    setCustomizer.setPropertyValue((Object)definedCustomizer.getCustomizerClass());
                    setCustomizer.setTarget((IPropertySource)((APropertyNode)source));
                    command.add((Command)setCustomizer);
                    if (definedCustomizer.isPropertiesCustomizer()) {
                        currentDTO.deleteCustomizer(definedCustomizer, true);
                    }
                }
            } else if (definedCustmizers.size() > 1) {
                SetValueCommand setCustomizer = new SetValueCommand();
                setCustomizer.setPropertyId((Object)"customizerClass");
                setCustomizer.setPropertyValue(null);
                setCustomizer.setTarget((IPropertySource)((APropertyNode)source));
                command.add((Command)setCustomizer);
                String currentCustomizer = currentDTO.getPnode().getValue().getCustomizerClass();
                if (currentCustomizer != null && !currentCustomizer.trim().isEmpty()) {
                    currentDTO.createCustomizerEntry(currentCustomizer, true);
                }
            }
            return command;
        }
        SetValueCommand setCommand = new SetValueCommand(commandName);
        setCommand.setPropertyId(propertyId);
        setCommand.setTarget(source);
        setCommand.setPropertyValue(newVal);
        return setCommand;
    }

    protected boolean isConfigurableCustmizer(ChartCustomizerDefinition definition) {
        if (definition.isOnlyClass()) {
            String classCustomizer = definition.getCustomizerClass();
            boolean isConfigurableCustmizer = false;
            try {
                Class customizerClass = JRClassLoader.loadClassForName((String)classCustomizer);
                isConfigurableCustmizer = NamedChartCustomizer.class.isAssignableFrom(customizerClass);
            }
            catch (Exception exception) {}
            return isConfigurableCustmizer;
        }
        return true;
    }

    protected boolean isCustomizerProperty(Object propertyId) {
        return "multiCustomizerProperty".equals(propertyId) || "propertyExpressions".equals(propertyId) || "PROPERTY_MAP".equals(propertyId);
    }
}

