/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.gantt.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.gantt.MGanttSeries;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttSeries;
import org.eclipse.gef.commands.Command;

public class ReorderGanttSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignGanttSeries jrElement;
    private JRDesignGanttDataset jrGroup;

    public ReorderGanttSeriesCommand(MGanttSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignGanttDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removeGanttSeries((JRGanttSeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addGanttSeries(this.newIndex, (JRGanttSeries)this.jrElement);
        } else {
            this.jrGroup.addGanttSeries((JRGanttSeries)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removeGanttSeries((JRGanttSeries)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addGanttSeries(this.oldIndex, (JRGanttSeries)this.jrElement);
        } else {
            this.jrGroup.addGanttSeries((JRGanttSeries)this.jrElement);
        }
    }
}

