/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.pie.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.pie.MPieSeries;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import org.eclipse.gef.commands.Command;

public class ReorderPieSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignPieSeries jrElement;
    private JRDesignPieDataset jrGroup;

    public ReorderPieSeriesCommand(MPieSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignPieDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removePieSeries((JRPieSeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addPieSeries(this.newIndex, (JRPieSeries)this.jrElement);
        } else {
            this.jrGroup.addPieSeries((JRPieSeries)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removePieSeries((JRPieSeries)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addPieSeries(this.oldIndex, (JRPieSeries)this.jrElement);
        } else {
            this.jrGroup.addPieSeries((JRPieSeries)this.jrElement);
        }
    }
}

