/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.time.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.time.MTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import org.eclipse.gef.commands.Command;

public class ReorderTimeSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignTimeSeries jrElement;
    private JRDesignTimeSeriesDataset jrGroup;

    public ReorderTimeSeriesCommand(MTimeSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignTimeSeriesDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removeTimeSeries((JRTimeSeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addTimeSeries(this.newIndex, (JRTimeSeries)this.jrElement);
        } else {
            this.jrGroup.addTimeSeries((JRTimeSeries)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removeTimeSeries((JRTimeSeries)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addTimeSeries(this.oldIndex, (JRTimeSeries)this.jrElement);
        } else {
            this.jrGroup.addTimeSeries((JRTimeSeries)this.jrElement);
        }
    }
}

