/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.series.xyseries.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.dataset.MChartDataset;
import com.jaspersoft.studio.components.chart.model.series.xyseries.MXYSeries;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXySeries;
import org.eclipse.gef.commands.Command;

public class ReorderXYSeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignXySeries jrElement;
    private JRDesignXyDataset jrGroup;

    public ReorderXYSeriesCommand(MXYSeries child, MChartDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (JRDesignXyDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removeXySeries((JRXySeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addXySeries(this.newIndex, (JRXySeries)this.jrElement);
        } else {
            this.jrGroup.addXySeries((JRXySeries)this.jrElement);
        }
    }

    public void undo() {
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addXySeries(this.oldIndex, (JRXySeries)this.jrElement);
        } else {
            this.jrGroup.addXySeries((JRXySeries)this.jrElement);
        }
    }
}

