/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.enums.JFreeChartAlignEnum;
import com.jaspersoft.studio.components.chart.model.theme.MChartThemeSettings;
import com.jaspersoft.studio.components.chart.model.theme.imageprovider.ImageProviderPropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.paintprovider.PaintProviderPropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.stroke.StrokePropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.util.PadUtil;
import com.jaspersoft.studio.jasper.CachedImageProvider;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TransparencyPropertyDescriptor;
import java.awt.Stroke;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.chartthemes.simple.ChartSettings;
import net.sf.jasperreports.chartthemes.simple.FileImageProvider;
import net.sf.jasperreports.chartthemes.simple.ImageProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jfree.ui.RectangleInsets;

public class MChartSettings
extends APropertyNode {
    public static final long serialVersionUID = 10200L;
    private static NamedEnumPropertyDescriptor<JFreeChartAlignEnum> bia;
    private IPropertyDescriptor[] descriptors;

    public MChartSettings(MChartThemeSettings parent, ChartSettings cs) {
        super((ANode)parent, -1);
        this.setValue(cs);
    }

    public ChartSettings getValue() {
        return (ChartSettings)super.getValue();
    }

    public ImageDescriptor getImagePath() {
        return null;
    }

    public String getDisplayText() {
        return "Chart";
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        Object pd = new CheckBoxPropertyDescriptor((Object)"textAntiAlias", Messages.MChartSettings_textAATitle);
        pd.setDescription(Messages.MChartSettings_textAADescription);
        desc.add((IPropertyDescriptor)pd);
        pd = new CheckBoxPropertyDescriptor((Object)"antiAlias", Messages.MChartSettings_antiAliasTitle);
        pd.setDescription(Messages.MChartSettings_antiAliasDescription);
        desc.add((IPropertyDescriptor)pd);
        pd = new CheckBoxPropertyDescriptor((Object)"borderVisible", Messages.MChartSettings_borderVisibleTitle);
        pd.setDescription(Messages.MChartSettings_borderVisibleDescription);
        pd.setCategory("Borders");
        desc.add((IPropertyDescriptor)pd);
        pd = new TransparencyPropertyDescriptor((Object)"backgroundImageAlpha", Messages.MChartSettings_imageAlphaTitle);
        pd.setDescription(Messages.MChartSettings_imageAlphaDescription);
        pd.setCategory("Background");
        desc.add((IPropertyDescriptor)pd);
        bia = new NamedEnumPropertyDescriptor((Object)"backgroundImageAlignment", Messages.MChartSettings_imageAlignTitle, (Enum)JFreeChartAlignEnum.BOTTOM, NullEnum.NOTNULL);
        bia.setDescription(Messages.MChartSettings_imageAlignDescription);
        bia.setCategory("Background");
        desc.add((IPropertyDescriptor)bia);
        PadUtil.createPropertyDescriptors(desc);
        pd = new PaintProviderPropertyDescriptor("backgroundPaint", Messages.MChartSettings_paintTitle);
        pd.setDescription(Messages.MChartSettings_paintDescription);
        pd.setCategory("Background");
        desc.add((IPropertyDescriptor)pd);
        pd = new PaintProviderPropertyDescriptor("borderPaint", Messages.MChartSettings_borderColorTitle);
        pd.setDescription(Messages.MChartSettings_borderColorDescription);
        pd.setCategory("Borders");
        desc.add((IPropertyDescriptor)pd);
        pd = new ImageProviderPropertyDescriptor("backgroundImage", Messages.MChartSettings_backgroundImageTitle);
        pd.setDescription(Messages.MChartSettings_backgroundImageDescription);
        pd.setCategory("Background");
        desc.add((IPropertyDescriptor)pd);
        pd = new StrokePropertyDescriptor("borderStroke", Messages.MChartSettings_borderStrokeTitle);
        pd.setDescription(Messages.MChartSettings_borderStrokeDescription);
        pd.setCategory("Borders");
        desc.add((IPropertyDescriptor)pd);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/sample.reference/chartthemes/index.html#chartthemes");
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("backgroundPaint", new DefaultValue(null, true));
        defaultsMap.put("borderPaint", new DefaultValue(null, true));
        defaultsMap.put("backgroundImage", new DefaultValue(null, true));
        defaultsMap.put("borderStroke", new DefaultValue(null, true));
        defaultsMap.put("textAntiAlias", new DefaultValue((Object)Boolean.TRUE, false));
        defaultsMap.put("antiAlias", new DefaultValue((Object)Boolean.TRUE, false));
        defaultsMap.put("borderVisible", new DefaultValue((Object)Boolean.TRUE, false));
        int backAlignValue = NamedEnumPropertyDescriptor.getIntValue((Enum)JFreeChartAlignEnum.TOP_LEFT, (NullEnum)NullEnum.NOTNULL, (Enum)JFreeChartAlignEnum.TOP_LEFT);
        defaultsMap.put("backgroundImageAlignment", new DefaultValue((Object)backAlignValue, false));
        PadUtil.createDefaults("", defaultsMap);
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        ChartSettings cs = this.getValue();
        if (id.equals("textAntiAlias")) {
            return cs.getTextAntiAlias();
        }
        if (id.equals("antiAlias")) {
            return cs.getAntiAlias();
        }
        if (id.equals("borderVisible")) {
            return cs.getBorderVisible();
        }
        if (id.equals("backgroundImageAlpha")) {
            return cs.getBackgroundImageAlpha();
        }
        if (id.equals("backgroundImageAlignment")) {
            return Misc.nvl((Object)cs.getBackgroundImageAlignment(), (Object)new Integer(JFreeChartAlignEnum.TOP_LEFT.getValue()));
        }
        Object pad = PadUtil.getPropertyValue(id, cs.getPadding());
        if (pad != null) {
            return pad;
        }
        if (id.equals("backgroundPaint")) {
            return cs.getBackgroundPaint();
        }
        if (id.equals("borderPaint")) {
            return cs.getBorderPaint();
        }
        if (id.equals("backgroundImage")) {
            ImageProvider bimg = cs.getBackgroundImage();
            if (bimg != null && bimg instanceof FileImageProvider) {
                return ((FileImageProvider)bimg).getFile();
            }
            return null;
        }
        if (id.equals("borderStroke")) {
            return cs.getBorderStroke();
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        ChartSettings cs = this.getValue();
        if (id.equals("textAntiAlias")) {
            cs.setTextAntiAlias((Boolean)value);
        } else if (id.equals("antiAlias")) {
            cs.setAntiAlias((Boolean)value);
        } else if (id.equals("borderVisible")) {
            cs.setBorderVisible((Boolean)value);
        } else if (id.equals("backgroundImageAlpha")) {
            cs.setBackgroundImageAlpha((Float)value);
        } else if (id.equals("backgroundImageAlignment")) {
            cs.setBackgroundImageAlignment((Integer)value);
        } else if (id.equals("backgroundPaint")) {
            cs.setBackgroundPaint((PaintProvider)value);
        } else if (id.equals("borderPaint")) {
            cs.setBorderPaint((PaintProvider)value);
        } else if (id.equals("backgroundImage")) {
            if (value == null || ((String)value).trim().isEmpty()) {
                cs.setBackgroundImage(null);
            } else {
                cs.setBackgroundImage((ImageProvider)new CachedImageProvider((String)value));
            }
        } else if (id.equals("borderStroke")) {
            cs.setBorderStroke((Stroke)value);
        }
        RectangleInsets ri = PadUtil.setPropertyValue(id, value, cs.getPadding());
        if (ri != null) {
            cs.setPadding(ri);
        }
    }
}

