/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.enums.JFreeChartHorizontalAlignmentEnum;
import com.jaspersoft.studio.components.chart.model.enums.JFreeChartVerticalAlignmentEnum;
import com.jaspersoft.studio.components.chart.model.theme.MChartThemeSettings;
import com.jaspersoft.studio.components.chart.model.theme.paintprovider.PaintProviderPropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.util.PadUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.model.text.MFontUtil;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.FontPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.chartthemes.simple.BlockFrameProvider;
import net.sf.jasperreports.chartthemes.simple.LegendSettings;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRFont;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jfree.ui.RectangleInsets;

public class MLegendSettings
extends APropertyNode {
    public static final long serialVersionUID = 10200L;
    private static NamedEnumPropertyDescriptor<EdgeEnum> posD;
    private static NamedEnumPropertyDescriptor<JFreeChartHorizontalAlignmentEnum> hp;
    private static NamedEnumPropertyDescriptor<JFreeChartVerticalAlignmentEnum> vp;
    private IPropertyDescriptor[] descriptors;
    private MFont clFont;

    public MLegendSettings(MChartThemeSettings parent, LegendSettings cts) {
        super((ANode)parent, -1);
        this.setValue(cts);
    }

    public LegendSettings getValue() {
        return (LegendSettings)super.getValue();
    }

    public ImageDescriptor getImagePath() {
        return null;
    }

    public String getDisplayText() {
        return "Legend";
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        Object pd = new CheckBoxPropertyDescriptor((Object)"showLegend", Messages.MLegendSettings_showLegendTitle);
        pd.setDescription(Messages.MLegendSettings_showLegendDescription);
        desc.add((IPropertyDescriptor)pd);
        pd = new FontPropertyDescriptor((Object)"font", "Font");
        pd.setDescription("Font");
        desc.add((IPropertyDescriptor)pd);
        posD = new NamedEnumPropertyDescriptor((Object)"position", Messages.MLegendSettings_positionTitle, (Enum)EdgeEnum.BOTTOM, NullEnum.NULL);
        posD.setDescription(Messages.MLegendSettings_positionDescription);
        desc.add((IPropertyDescriptor)posD);
        hp = new NamedEnumPropertyDescriptor((Object)"horizontalAlignment", Messages.MLegendSettings_legendHAlignTitle, (Enum)JFreeChartHorizontalAlignmentEnum.CENTER, NullEnum.NULL);
        hp.setDescription(Messages.MLegendSettings_legendHAlignDescription);
        desc.add((IPropertyDescriptor)hp);
        vp = new NamedEnumPropertyDescriptor((Object)"verticalAlignment", Messages.MLegendSettings_legendVAlignTitle, (Enum)JFreeChartVerticalAlignmentEnum.BOTTOM, NullEnum.NULL);
        vp.setDescription(Messages.MLegendSettings_legendVAlignDescription);
        desc.add((IPropertyDescriptor)vp);
        PadUtil.createPropertyDescriptors(desc);
        pd = new PaintProviderPropertyDescriptor("foregroundPaint", Messages.MLegendSettings_legendForegroundColorTitle);
        pd.setDescription(Messages.MLegendSettings_legendForegroundColorDescription);
        desc.add((IPropertyDescriptor)pd);
        pd = new PaintProviderPropertyDescriptor("backgroundPaint", Messages.MLegendSettings_legendBackgroundColorTitle);
        pd.setDescription(Messages.MLegendSettings_legendBackgroundColorDescription);
        desc.add((IPropertyDescriptor)pd);
        PadUtil.createBlockFramePropertyDescriptors(desc, "Block Frame");
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/sample.reference/chartthemes/index.html#chartthemes");
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("backgroundPaint", new DefaultValue(null, true));
        defaultsMap.put("foregroundPaint", new DefaultValue(null, true));
        defaultsMap.put("showLegend", new DefaultValue((Object)true, false));
        int positionValue = NamedEnumPropertyDescriptor.getIntValue((NullEnum)NullEnum.NULL, (Enum)EdgeEnum.TOP);
        defaultsMap.put("position", new DefaultValue((Object)positionValue, true));
        int horizontalValue = NamedEnumPropertyDescriptor.getIntValue((NullEnum)NullEnum.NULL, (Enum)JFreeChartHorizontalAlignmentEnum.LEFT);
        defaultsMap.put("horizontalAlignment", new DefaultValue((Object)horizontalValue, true));
        int vertivalValue = NamedEnumPropertyDescriptor.getIntValue((NullEnum)NullEnum.NULL, (Enum)JFreeChartVerticalAlignmentEnum.TOP);
        defaultsMap.put("verticalAlignment", new DefaultValue((Object)vertivalValue, true));
        PadUtil.createDefaults("", defaultsMap);
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        LegendSettings ts = this.getValue();
        if (id.equals("showLegend")) {
            return Misc.nvl((Object)ts.getShowLegend(), (Object)Boolean.TRUE);
        }
        if (id.equals("font")) {
            this.clFont = MFontUtil.getMFont((MFont)this.clFont, (JRFont)ts.getFont(), null, (APropertyNode)this);
            return this.clFont;
        }
        if (id.equals("position")) {
            return posD.getIntValue((Enum)ts.getPositionValue());
        }
        if (id.equals("horizontalAlignment")) {
            return hp.getIntValue((Enum)JFreeChartHorizontalAlignmentEnum.getValue(ts.getHorizontalAlignment()));
        }
        if (id.equals("verticalAlignment")) {
            return vp.getIntValue((Enum)JFreeChartVerticalAlignmentEnum.getValue(ts.getVerticalAlignment()));
        }
        if (id.equals("backgroundPaint")) {
            return ts.getBackgroundPaint();
        }
        if (id.equals("foregroundPaint")) {
            return ts.getForegroundPaint();
        }
        Object pad = PadUtil.getPropertyValue(id, ts.getPadding());
        if (pad != null) {
            return pad;
        }
        BlockFrameProvider bf = ts.getFrame();
        pad = PadUtil.getBlockFrameValue(id, bf);
        if (pad != null) {
            return pad;
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        LegendSettings ts = this.getValue();
        if (id.equals("showLegend")) {
            ts.setShowLegend((Boolean)value);
        } else if (id.equals("font")) {
            ts.setFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("position")) {
            ts.setPosition((EdgeEnum)posD.getEnumValue(value));
        } else if (id.equals("horizontalAlignment")) {
            ts.setHorizontalAlignment(((JFreeChartHorizontalAlignmentEnum)hp.getEnumValue(value)).getJFreeChartValue());
        } else if (id.equals("verticalAlignment")) {
            ts.setVerticalAlignment(((JFreeChartVerticalAlignmentEnum)vp.getEnumValue(value)).getJFreeChartValue());
        } else if (id.equals("backgroundPaint")) {
            ts.setBackgroundPaint((PaintProvider)value);
        } else if (id.equals("foregroundPaint")) {
            ts.setForegroundPaint((PaintProvider)value);
        }
        RectangleInsets ri = PadUtil.setPropertyValue(id, value, ts.getPadding());
        if (ri != null) {
            ts.setPadding(ri);
        } else {
            PadUtil.setFramePropertyValue(id, value, ts);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }
}

